/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.unitselection.select.Target;
import marytts.unitselection.select.VocalizationFFRTargetCostFunction;
import marytts.util.MaryUtils;
import marytts.util.math.MathUtils;
import marytts.util.math.Polynomial;
import marytts.vocalizations.SourceTargetPair;
import marytts.vocalizations.VocalizationCandidate;
import marytts.vocalizations.VocalizationFeatureFileReader;
import marytts.vocalizations.VocalizationIntonationReader;
import marytts.vocalizations.VocalizationUnit;
import marytts.vocalizations.VocalizationUnitFileReader;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class VocalizationSelector {
    protected VocalizationFeatureFileReader featureFileReader;
    protected FeatureDefinition featureDefinition;
    protected FeatureDefinition f0FeatureDefinition;
    protected VocalizationIntonationReader vIntonationReader;
    protected VocalizationUnitFileReader unitFileReader;
    protected VocalizationFFRTargetCostFunction vffrtUnitCostFunction = null;
    protected VocalizationFFRTargetCostFunction vffrtContourCostFunction = null;
    protected boolean f0ContourImposeSupport;
    protected boolean usePrecondition;
    protected double contourCostWeight;
    private DecimalFormat df;
    protected int noOfSuitableUnits = 1;
    protected Logger logger = MaryUtils.getLogger("Vocalization Selector");

    public VocalizationSelector(Voice voice) throws MaryConfigurationException {
        String unitFileName = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.unitfile");
        String featureFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.featurefile");
        String featureDefinitionFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.featureDefinitionFile");
        this.f0ContourImposeSupport = MaryProperties.getBoolean("voice." + voice.getName() + ".f0ContourImposeSupport", false);
        this.df = new DecimalFormat("##.##");
        try {
            BufferedReader fDBufferedReader = new BufferedReader(new FileReader(new File(featureDefinitionFile)));
            this.featureDefinition = new FeatureDefinition(fDBufferedReader, true);
            this.featureFileReader = new VocalizationFeatureFileReader(featureFile);
            this.vffrtUnitCostFunction = new VocalizationFFRTargetCostFunction(this.featureFileReader, this.featureDefinition);
            this.unitFileReader = new VocalizationUnitFileReader(unitFileName);
            if (this.featureFileReader.getNumberOfUnits() != this.unitFileReader.getNumberOfUnits()) {
                throw new MaryConfigurationException("Feature file reader and unit file reader is not aligned properly");
            }
            if (this.f0ContourImposeSupport) {
                String intonationFDFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.intonation.featureDefinitionFile");
                String intonationFile = MaryProperties.getFilename("voice." + voice.getName() + ".vocalization.intonationfile");
                this.usePrecondition = MaryProperties.getBoolean("voice." + voice.getName() + ".vocalization.usePrecondition", false);
                this.contourCostWeight = new Double(MaryProperties.getProperty("voice." + voice.getName() + ".vocalization.contourCostWeight", "0.5"));
                if (this.contourCostWeight < 0.0 || this.contourCostWeight > 1.0) {
                    throw new MaryConfigurationException("contourCostWeight should be between 0 and 1");
                }
                BufferedReader f0FDBufferedReader = new BufferedReader(new FileReader(new File(intonationFDFile)));
                this.f0FeatureDefinition = new FeatureDefinition(f0FDBufferedReader, true);
                this.vIntonationReader = new VocalizationIntonationReader(intonationFile);
                this.noOfSuitableUnits = MaryProperties.getInteger("voice." + voice.getName() + ".vocalization.intonation.numberOfSuitableUnits");
                this.vffrtContourCostFunction = new VocalizationFFRTargetCostFunction(this.featureFileReader, this.f0FeatureDefinition);
            }
        }
        catch (IOException e) {
            throw new MaryConfigurationException("Problem loading vocalization files for voice ", e);
        }
    }

    public FeatureDefinition getFeatureDefinition() {
        return this.featureDefinition;
    }

    public SourceTargetPair getBestCandidatePairtoImposeF0(Element domElement) {
        VocalizationCandidate[] vCosts = this.getBestMatchingCandidates(domElement);
        VocalizationCandidate[] vIntonationCosts = this.getBestIntonationCandidates(domElement);
        int noOfSuitableF0Units = this.usePrecondition ? this.getNumberContoursAboveThreshold(vCosts, vIntonationCosts) : this.noOfSuitableUnits;
        if (noOfSuitableF0Units == 0) {
            return new SourceTargetPair(vCosts[0].unitIndex, vCosts[0].unitIndex, 0.0);
        }
        VocalizationCandidate[] suitableCandidates = new VocalizationCandidate[this.noOfSuitableUnits];
        System.arraycopy(vCosts, 0, suitableCandidates, 0, this.noOfSuitableUnits);
        VocalizationCandidate[] suitableF0Candidates = new VocalizationCandidate[noOfSuitableF0Units];
        System.arraycopy(vIntonationCosts, 0, suitableF0Candidates, 0, noOfSuitableF0Units);
        Target targetUnit = this.createTarget(domElement);
        if (this.logger.getEffectiveLevel().equals((Object)Level.DEBUG)) {
            this.debugLogCandidates(targetUnit, suitableCandidates, suitableF0Candidates);
        }
        SourceTargetPair[] sortedImposeF0Data = this.vocalizationF0DistanceComputer(suitableCandidates, suitableF0Candidates, domElement);
        return sortedImposeF0Data[0];
    }

    private int getNumberContoursAboveThreshold(VocalizationCandidate[] vCosts, VocalizationCandidate[] vIntonationCosts) {
        double[] costs = new double[this.noOfSuitableUnits];
        int i = 0;
        while (i < costs.length) {
            int unitIndex = vCosts[i].unitIndex;
            VocalizationCandidate contourCandidate = this.getCandidateByIndex(vIntonationCosts, unitIndex);
            costs[i] = contourCandidate != null ? contourCandidate.cost : Double.MAX_VALUE;
            ++i;
        }
        double threshold = MathUtils.min(costs);
        int contourSetSize = 0;
        int i2 = 0;
        while (i2 < vIntonationCosts.length) {
            if (!(vIntonationCosts[i2].cost < threshold)) break;
            contourSetSize = i2 + 1;
            ++i2;
        }
        return contourSetSize;
    }

    private VocalizationCandidate getCandidateByIndex(VocalizationCandidate[] vIntonationCosts, int unitIndex) {
        int i = 0;
        while (i < vIntonationCosts.length) {
            if (vIntonationCosts[i].unitIndex == unitIndex) {
                return vIntonationCosts[i];
            }
            ++i;
        }
        return null;
    }

    private SourceTargetPair[] vocalizationF0DistanceComputer(VocalizationCandidate[] suitableCandidates, VocalizationCandidate[] suitableF0Candidates, Element domElement) {
        int noPossibleImpositions = suitableCandidates.length * suitableF0Candidates.length;
        Object[] imposeF0Data = new SourceTargetPair[noPossibleImpositions];
        int count = 0;
        int i = 0;
        while (i < suitableCandidates.length) {
            int j = 0;
            while (j < suitableF0Candidates.length) {
                int sourceIndex = suitableCandidates[i].unitIndex;
                int targetIndex = suitableF0Candidates[j].unitIndex;
                double contourCost = this.getContourCostDistance(sourceIndex, targetIndex);
                double mergeCost = this.getMergeCost(sourceIndex, targetIndex, domElement);
                double cost = contourCost * this.contourCostWeight + mergeCost * (1.0 - this.contourCostWeight);
                this.logger.debug((Object)("Unit Index " + sourceIndex + " & Contour Index " + targetIndex + " :: Countour cost: " + this.df.format(contourCost) + " + Merge Cost: " + this.df.format(mergeCost) + " --> TotalCost: " + this.df.format(cost)));
                imposeF0Data[count++] = new SourceTargetPair(sourceIndex, targetIndex, cost);
                ++j;
            }
            ++i;
        }
        Arrays.sort(imposeF0Data);
        return imposeF0Data;
    }

    private double getMergeCost(int sourceIndex, int targetIndex, Element domElement) {
        Target targetUnit = this.createTarget(domElement);
        Target targetContour = this.createIntonationTarget(domElement);
        VocalizationUnit unitCandidate = this.unitFileReader.getUnit(sourceIndex);
        VocalizationUnit contourCandidate = this.unitFileReader.getUnit(targetIndex);
        double segmentalCost = this.vffrtUnitCostFunction.featureCost(targetUnit, unitCandidate, "name");
        double voiceQualityCost = this.vffrtUnitCostFunction.featureCost(targetUnit, unitCandidate, "voicequality");
        double meaningUnitCost = 0.0;
        String[] meaningFeatureNames = this.vffrtUnitCostFunction.getFeatureDefinition().getContinuousFeatureNameArray();
        int i = 0;
        while (i < meaningFeatureNames.length) {
            meaningUnitCost += this.vffrtUnitCostFunction.featureCost(targetUnit, unitCandidate, meaningFeatureNames[i]);
            ++i;
        }
        double intonationCost = this.vffrtContourCostFunction.featureCost(targetContour, contourCandidate, "intonation");
        double meaningContourCost = 0.0;
        String[] meaningContourFeatures = this.vffrtContourCostFunction.getFeatureDefinition().getContinuousFeatureNameArray();
        int i2 = 0;
        while (i2 < meaningContourFeatures.length) {
            meaningContourCost += this.vffrtContourCostFunction.featureCost(targetContour, contourCandidate, meaningContourFeatures[i2]);
            ++i2;
        }
        double mergeCost = segmentalCost + voiceQualityCost + intonationCost + 0.5 * (meaningUnitCost + meaningContourCost);
        return mergeCost;
    }

    private double getContourCostDistance(int sourceIndex, int targetIndex) {
        double distance;
        if (targetIndex == sourceIndex) {
            distance = 0.0;
        } else {
            double[] targetCoeffs = this.vIntonationReader.getIntonationCoeffs(targetIndex);
            double[] sourceCoeffs = this.vIntonationReader.getIntonationCoeffs(sourceIndex);
            distance = targetCoeffs != null && sourceCoeffs != null && targetCoeffs.length == sourceCoeffs.length ? Polynomial.polynomialDistance(sourceCoeffs, targetCoeffs) : Double.MAX_VALUE;
        }
        return distance;
    }

    public int getBestMatchingCandidate(Element domElement) {
        Target targetUnit = this.createTarget(domElement);
        int numberUnits = this.unitFileReader.getNumberOfUnits();
        double minCost = Double.MAX_VALUE;
        int index = 0;
        int i = 0;
        while (i < numberUnits) {
            VocalizationUnit singleUnit = this.unitFileReader.getUnit(i);
            double cost = this.vffrtUnitCostFunction.cost(targetUnit, singleUnit);
            if (cost < minCost) {
                minCost = cost;
                index = i;
            }
            ++i;
        }
        return index;
    }

    public VocalizationCandidate[] getBestMatchingCandidates(Element domElement) {
        Target targetUnit = this.createTarget(domElement);
        int numberUnits = this.unitFileReader.getNumberOfUnits();
        Object[] vocalizationCandidates = new VocalizationCandidate[numberUnits];
        int i = 0;
        while (i < numberUnits) {
            VocalizationUnit singleUnit = this.unitFileReader.getUnit(i);
            double cost = this.vffrtUnitCostFunction.cost(targetUnit, singleUnit);
            vocalizationCandidates[i] = new VocalizationCandidate(i, cost);
            ++i;
        }
        Arrays.sort(vocalizationCandidates);
        return vocalizationCandidates;
    }

    private void debugLogCandidates(Target targetUnit, VocalizationCandidate[] suitableCandidates, VocalizationCandidate[] suitableF0Candidates) {
        String featureName;
        int j;
        StringBuilder sb;
        FeatureVector fv;
        double unitCost;
        int unitIndex;
        FeatureVector targetFeatures = targetUnit.getFeatureVector();
        FeatureDefinition fd = this.featureFileReader.getFeatureDefinition();
        int fiName = fd.getFeatureIndex("name");
        int fiIntonation = fd.getFeatureIndex("intonation");
        int fiVQ = fd.getFeatureIndex("voicequality");
        int i = 0;
        while (i < suitableCandidates.length) {
            unitIndex = suitableCandidates[i].unitIndex;
            unitCost = suitableCandidates[i].cost;
            fv = this.featureFileReader.getFeatureVector(unitIndex);
            sb = new StringBuilder();
            sb.append("Candidate ").append(i).append(": ").append(unitIndex).append(" ( " + unitCost + " ) ").append(" -- ");
            fv.getByteFeature(fiName);
            if (fv.getByteFeature(fiName) != 0 && targetFeatures.getByteFeature(fiName) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiName, fd));
            }
            if (fv.getByteFeature(fiVQ) != 0 && targetFeatures.getByteFeature(fiName) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiVQ, fd));
            }
            if (fv.getByteFeature(fiIntonation) != 0 && targetFeatures.getByteFeature(fiIntonation) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiIntonation, fd));
            }
            j = 0;
            while (j < targetFeatures.getLength()) {
                if (targetFeatures.isContinuousFeature(j) && !Float.isNaN(((Float)targetFeatures.getFeature(j)).floatValue()) && !Float.isNaN(((Float)fv.getFeature(j)).floatValue())) {
                    featureName = fd.getFeatureName(j);
                    sb.append(" ").append(featureName).append("=").append(fv.getFeature(j));
                }
                ++j;
            }
            this.logger.debug((Object)sb.toString());
            ++i;
        }
        i = 0;
        while (i < suitableF0Candidates.length) {
            unitIndex = suitableF0Candidates[i].unitIndex;
            unitCost = suitableF0Candidates[i].cost;
            fv = this.featureFileReader.getFeatureVector(unitIndex);
            sb = new StringBuilder();
            sb.append("F0 Candidate ").append(i).append(": ").append(unitIndex).append(" ( " + unitCost + " ) ").append(" -- ");
            fv.getByteFeature(fiName);
            if (fv.getByteFeature(fiName) != 0 && targetFeatures.getByteFeature(fiName) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiName, fd));
            }
            if (fv.getByteFeature(fiVQ) != 0 && targetFeatures.getByteFeature(fiName) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiVQ, fd));
            }
            if (fv.getByteFeature(fiIntonation) != 0 && targetFeatures.getByteFeature(fiIntonation) != 0) {
                sb.append(" ").append(fv.getFeatureAsString(fiIntonation, fd));
            }
            j = 0;
            while (j < targetFeatures.getLength()) {
                if (targetFeatures.isContinuousFeature(j) && !Float.isNaN(((Float)targetFeatures.getFeature(j)).floatValue()) && !Float.isNaN(((Float)fv.getFeature(j)).floatValue())) {
                    featureName = fd.getFeatureName(j);
                    sb.append(" ").append(featureName).append("=").append(fv.getFeature(j));
                }
                ++j;
            }
            this.logger.debug((Object)sb.toString());
            ++i;
        }
    }

    private VocalizationCandidate[] getBestIntonationCandidates(Element domElement) {
        Target targetUnit = this.createIntonationTarget(domElement);
        int numberUnits = this.unitFileReader.getNumberOfUnits();
        Object[] vocalizationCandidates = new VocalizationCandidate[numberUnits];
        int i = 0;
        while (i < numberUnits) {
            VocalizationUnit singleUnit = this.unitFileReader.getUnit(i);
            double cost = this.vffrtContourCostFunction.cost(targetUnit, singleUnit);
            vocalizationCandidates[i] = new VocalizationCandidate(i, cost);
            ++i;
        }
        Arrays.sort(vocalizationCandidates);
        return vocalizationCandidates;
    }

    private Target createTarget(Element domElement) {
        FeatureDefinition featDef = this.featureDefinition;
        int numFeatures = featDef.getNumberOfFeatures();
        int numByteFeatures = featDef.getNumberOfByteFeatures();
        int numShortFeatures = featDef.getNumberOfShortFeatures();
        int numContiniousFeatures = featDef.getNumberOfContinuousFeatures();
        byte[] byteFeatures = new byte[numByteFeatures];
        short[] shortFeatures = new short[numShortFeatures];
        float[] floatFeatures = new float[numContiniousFeatures];
        int byteCount = 0;
        int shortCount = 0;
        int floatCount = 0;
        int i = 0;
        while (i < numFeatures) {
            String featName = featDef.getFeatureName(i);
            String featValue = "0";
            if (featDef.isByteFeature(featName) || featDef.isShortFeature(featName)) {
                boolean hasFeature;
                if (domElement.hasAttribute(featName)) {
                    featValue = domElement.getAttribute(featName);
                }
                if (!(hasFeature = featDef.hasFeatureValue(featName, featValue))) {
                    featValue = "0";
                }
                if (featDef.isByteFeature(i)) {
                    byteFeatures[byteCount++] = featDef.getFeatureValueAsByte(i, featValue);
                } else if (featDef.isShortFeature(i)) {
                    shortFeatures[shortCount++] = featDef.getFeatureValueAsShort(i, featValue);
                }
            } else {
                if (domElement.hasAttribute("meaning")) {
                    featValue = domElement.getAttribute("meaning");
                }
                floatFeatures[floatCount++] = this.getMeaningScaleValue(featName, featValue);
            }
            ++i;
        }
        FeatureVector newFV = featDef.toFeatureVector(0, byteFeatures, shortFeatures, floatFeatures);
        String name = "0";
        if (domElement.hasAttribute("name")) {
            name = domElement.getAttribute("name");
        }
        Target newTarget = new Target(name, domElement);
        newTarget.setFeatureVector(newFV);
        return newTarget;
    }

    private Target createIntonationTarget(Element domElement) {
        FeatureDefinition featDef = this.f0FeatureDefinition;
        int numFeatures = featDef.getNumberOfFeatures();
        int numByteFeatures = featDef.getNumberOfByteFeatures();
        int numShortFeatures = featDef.getNumberOfShortFeatures();
        int numContiniousFeatures = featDef.getNumberOfContinuousFeatures();
        byte[] byteFeatures = new byte[numByteFeatures];
        short[] shortFeatures = new short[numShortFeatures];
        float[] floatFeatures = new float[numContiniousFeatures];
        int byteCount = 0;
        int shortCount = 0;
        int floatCount = 0;
        int i = 0;
        while (i < numFeatures) {
            String featName = featDef.getFeatureName(i);
            String featValue = "0";
            if (featDef.isByteFeature(featName) || featDef.isShortFeature(featName)) {
                boolean hasFeature;
                if (domElement.hasAttribute(featName)) {
                    featValue = domElement.getAttribute(featName);
                }
                if (!(hasFeature = featDef.hasFeatureValue(featName, featValue))) {
                    featValue = "0";
                }
                if (featDef.isByteFeature(i)) {
                    byteFeatures[byteCount++] = featDef.getFeatureValueAsByte(i, featValue);
                } else if (featDef.isShortFeature(i)) {
                    shortFeatures[shortCount++] = featDef.getFeatureValueAsShort(i, featValue);
                }
            } else {
                if (domElement.hasAttribute("meaning")) {
                    featValue = domElement.getAttribute("meaning");
                }
                floatFeatures[floatCount++] = this.getMeaningScaleValue(featName, featValue);
            }
            ++i;
        }
        FeatureVector newFV = featDef.toFeatureVector(0, byteFeatures, shortFeatures, floatFeatures);
        String name = "0";
        if (domElement.hasAttribute("name")) {
            name = domElement.getAttribute("name");
        }
        Target newTarget = new Target(name, domElement);
        newTarget.setFeatureVector(newFV);
        return newTarget;
    }

    private float getMeaningScaleValue(String featureName, String meaningAttribute) {
        String[] categories = meaningAttribute.split("\\s+");
        List<String> categoriesList = Arrays.asList(categories);
        if ("anger".equals(featureName) && categoriesList.contains("anger")) {
            return 5.0f;
        }
        if ("sadness".equals(featureName) && categoriesList.contains("sadness")) {
            return 5.0f;
        }
        if ("amusement".equals(featureName) && categoriesList.contains("amusement")) {
            return 5.0f;
        }
        if ("happiness".equals(featureName) && categoriesList.contains("happiness")) {
            return 5.0f;
        }
        if ("contempt".equals(featureName) && categoriesList.contains("contempt")) {
            return 5.0f;
        }
        if ("certain".equals(featureName) && categoriesList.contains("uncertain")) {
            return -2.0f;
        }
        if ("certain".equals(featureName) && categoriesList.contains("certain")) {
            return 2.0f;
        }
        if ("agreeing".equals(featureName) && categoriesList.contains("disagreeing")) {
            return -2.0f;
        }
        if ("agreeing".equals(featureName) && categoriesList.contains("agreeing")) {
            return 2.0f;
        }
        if ("interested".equals(featureName) && categoriesList.contains("uninterested")) {
            return -2.0f;
        }
        if ("interested".equals(featureName) && categoriesList.contains("interested")) {
            return 2.0f;
        }
        if ("anticipation".equals(featureName) && categoriesList.contains("low-anticipation")) {
            return -2.0f;
        }
        if ("anticipation".equals(featureName) && categoriesList.contains("anticipation")) {
            return 2.0f;
        }
        if ("anticipation".equals(featureName) && categoriesList.contains("high-anticipation")) {
            return 2.0f;
        }
        if ("solidarity".equals(featureName) && categoriesList.contains("solidarity")) {
            return 5.0f;
        }
        if ("solidarity".equals(featureName) && categoriesList.contains("low-solidarity")) {
            return 1.0f;
        }
        if ("solidarity".equals(featureName) && categoriesList.contains("high-solidarity")) {
            return 5.0f;
        }
        if ("antagonism".equals(featureName) && categoriesList.contains("antagonism")) {
            return 5.0f;
        }
        if ("antagonism".equals(featureName) && categoriesList.contains("high-antagonism")) {
            return 5.0f;
        }
        if ("antagonism".equals(featureName) && categoriesList.contains("low-antagonism")) {
            return 1.0f;
        }
        return Float.NaN;
    }
}

