/*
 * Decompiled with CFR 0.152.
 */
package marytts.vocalizations;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import marytts.exceptions.MaryConfigurationException;
import marytts.util.data.MaryHeader;

public class MLSAFeatureFileReader {
    private MaryHeader hdr = null;
    private int numberOfUnits;
    private int STRVECTORSIZE;
    private int MGCVECTORSIZE;
    private int LF0VECTORSIZE;
    private int[] numberOfFrames;
    private boolean[][] voiced;
    private double[][] logf0;
    private double[][][] strengths;
    private double[][][] mgc;

    public MLSAFeatureFileReader(String fileName) throws IOException, MaryConfigurationException {
        this.load(fileName);
    }

    private void load(String fileName) throws IOException, MaryConfigurationException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MaryConfigurationException("File [" + fileName + "] was not found.");
        }
        this.hdr = new MaryHeader(dis);
        if (this.hdr.getType() != 325) {
            throw new MaryConfigurationException("File [" + fileName + "] is not a valid Mary Units file.");
        }
        this.numberOfUnits = dis.readInt();
        if (this.numberOfUnits < 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has a negative number of units. Aborting.");
        }
        this.LF0VECTORSIZE = dis.readInt();
        this.MGCVECTORSIZE = dis.readInt();
        this.STRVECTORSIZE = dis.readInt();
        if (this.LF0VECTORSIZE != 1 || this.MGCVECTORSIZE <= 0 || this.STRVECTORSIZE <= 0) {
            throw new MaryConfigurationException("File [" + fileName + "] has no proper feature vector size information... Aborting.");
        }
        this.logf0 = new double[this.numberOfUnits][];
        this.voiced = new boolean[this.numberOfUnits][];
        this.mgc = new double[this.numberOfUnits][][];
        this.strengths = new double[this.numberOfUnits][][];
        this.numberOfFrames = new int[this.numberOfUnits];
        int i = 0;
        while (i < this.numberOfUnits) {
            this.numberOfFrames[i] = dis.readInt();
            int checkLF0Size = dis.readInt();
            assert (checkLF0Size == this.numberOfFrames[i] * this.LF0VECTORSIZE) : String.valueOf(fileName) + " feature file do not has proper format";
            this.logf0[i] = new double[this.numberOfFrames[i]];
            this.voiced[i] = new boolean[this.numberOfFrames[i]];
            int j = 0;
            while (j < this.numberOfFrames[i]) {
                this.logf0[i][j] = dis.readFloat();
                this.voiced[i][j] = !(this.logf0[i][j] < 0.0);
                ++j;
            }
            int checkMGCSize = dis.readInt();
            assert (checkMGCSize == this.numberOfFrames[i] * this.MGCVECTORSIZE) : String.valueOf(fileName) + " feature file do not has proper format";
            this.mgc[i] = new double[this.numberOfFrames[i]][this.MGCVECTORSIZE];
            int j2 = 0;
            while (j2 < this.numberOfFrames[i]) {
                int k = 0;
                while (k < this.MGCVECTORSIZE) {
                    this.mgc[i][j2][k] = dis.readFloat();
                    ++k;
                }
                ++j2;
            }
            int checkSTRSize = dis.readInt();
            assert (checkSTRSize == this.numberOfFrames[i] * this.STRVECTORSIZE) : String.valueOf(fileName) + " feature file do not has proper format";
            this.strengths[i] = new double[this.numberOfFrames[i]][this.STRVECTORSIZE];
            int j3 = 0;
            while (j3 < this.numberOfFrames[i]) {
                int k = 0;
                while (k < this.STRVECTORSIZE) {
                    this.strengths[i][j3][k] = dis.readFloat();
                    ++k;
                }
                ++j3;
            }
            ++i;
        }
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public boolean[] getVoicedFrames(int unitnumber) {
        if (unitnumber >= this.numberOfUnits) {
            throw new IllegalArgumentException("the given unit index number(" + unitnumber + ") must be less than number of available units(" + this.numberOfUnits + ")");
        }
        return this.voiced[unitnumber];
    }

    public double[] getUnitLF0(int unitnumber) {
        if (unitnumber >= this.numberOfUnits) {
            throw new IllegalArgumentException("the given unit index number(" + unitnumber + ") must be less than number of available units(" + this.numberOfUnits + ")");
        }
        return this.logf0[unitnumber];
    }

    public double[][] getUnitMGCs(int unitnumber) {
        if (unitnumber >= this.numberOfUnits) {
            throw new IllegalArgumentException("the given unit index number(" + unitnumber + ") must be less than number of available units(" + this.numberOfUnits + ")");
        }
        return this.mgc[unitnumber];
    }

    public double[][] getUnitStrengths(int unitnumber) {
        if (unitnumber >= this.numberOfUnits) {
            throw new IllegalArgumentException("the given unit index number(" + unitnumber + ") must be less than number of available units(" + this.numberOfUnits + ")");
        }
        return this.strengths[unitnumber];
    }

    public int getMGCVectorSize() {
        return this.MGCVECTORSIZE;
    }

    public int getLF0VectorSize() {
        return this.LF0VECTORSIZE;
    }

    public int getSTRVectorSize() {
        return this.STRVECTORSIZE;
    }

    public static void main(String[] args) throws Exception {
        String fileName = "/home/sathish/Work/phd/voices/mlsa-poppy-listener/vocalizations/files/vocalization_mlsa_features.mry";
        new MLSAFeatureFileReader(fileName);
    }
}

