/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.concat;

import java.io.IOException;
import java.util.List;
import javax.sound.sampled.AudioInputStream;
import marytts.signalproc.adaptation.prosody.BasicProsodyModifierParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechFrame;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmSpeechSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizedSignal;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizer;
import marytts.signalproc.sinusoidal.hntm.synthesis.HntmSynthesizerParams;
import marytts.unitselection.concat.OverlapUnitConcatenator;
import marytts.unitselection.data.HnmDatagram;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.SelectedUnit;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.Datagram;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.math.MathUtils;

public class HnmUnitConcatenator
extends OverlapUnitConcatenator {
    @Override
    protected void getDatagramsFromTimeline(List<SelectedUnit> units) throws IOException {
        for (SelectedUnit unit : units) {
            assert (!unit.getUnit().isEdgeUnit()) : "We should never have selected any edge units!";
            HnmUnitData unitData = new HnmUnitData();
            unit.setConcatenationData(unitData);
            int unitSize = this.unitToTimeline(unit.getUnit().duration);
            long unitStart = this.unitToTimeline(unit.getUnit().startTime);
            Datagram[] datagrams = this.timeline.getDatagrams(unitStart, (long)unitSize);
            unitData.setFrames(datagrams);
            Datagram leftContextFrame = null;
            Unit prevInDB = this.database.getUnitFileReader().getPreviousUnit(unit.getUnit());
            long unitPrevStart = this.unitToTimeline(prevInDB.startTime);
            if (prevInDB != null && !prevInDB.isEdgeUnit()) {
                long unitPrevSize = this.unitToTimeline(prevInDB.duration);
                Datagram[] unitPrevDatagrams = this.timeline.getDatagrams(unitPrevStart, unitPrevSize);
                if (unitPrevDatagrams != null && unitPrevDatagrams.length > 0) {
                    leftContextFrame = unitPrevDatagrams[unitPrevDatagrams.length - 1];
                }
                unitData.setLeftContextFrame(leftContextFrame);
            }
            Datagram rightContextFrame = null;
            Unit nextInDB = this.database.getUnitFileReader().getNextUnit(unit.getUnit());
            if (nextInDB == null || nextInDB.isEdgeUnit()) continue;
            rightContextFrame = this.timeline.getDatagram(unitStart + (long)unitSize);
            unitData.setRightContextFrame(rightContextFrame);
        }
    }

    @Override
    protected AudioInputStream generateAudioStream(List<SelectedUnit> units) {
        int len = units.size();
        Datagram[][] datagrams = new Datagram[len][];
        Datagram[] leftContexts = new Datagram[len];
        Datagram[] rightContexts = new Datagram[len];
        int i = 0;
        while (i < len) {
            SelectedUnit unit = units.get(i);
            HnmUnitData unitData = (HnmUnitData)unit.getConcatenationData();
            assert (unitData != null) : "Should not have null unitdata here";
            Datagram[] frames = unitData.getFrames();
            assert (frames != null) : "Cannot generate audio from null frames";
            datagrams[i] = frames;
            Unit prevInDB = this.database.getUnitFileReader().getPreviousUnit(unit.getUnit());
            Unit prevSelected = i == 0 ? null : units.get(i - 1).getUnit();
            if (prevInDB != null && !prevInDB.equals(prevSelected)) {
                leftContexts[i] = (HnmDatagram)unitData.getLeftContextFrame();
            }
            Unit nextInDB = this.database.getUnitFileReader().getNextUnit(unit.getUnit());
            Unit nextSelected = i + 1 == len ? null : units.get(i + 1).getUnit();
            if (nextInDB != null && !nextInDB.equals(nextSelected)) {
                rightContexts[i] = unitData.getRightContextFrame();
            }
            ++i;
        }
        BufferedDoubleDataSource audioSource = this.synthesize(datagrams, leftContexts, rightContexts);
        return new DDSAudioInputStream(audioSource, this.audioformat);
    }

    protected BufferedDoubleDataSource synthesize(Datagram[][] datagrams, Datagram[] leftContexts, Datagram[] rightContexts) {
        int j;
        HntmSynthesizer s = new HntmSynthesizer();
        HntmAnalyzerParams analysisParams = new HntmAnalyzerParams();
        HntmSynthesizerParams synthesisParams = new HntmSynthesizerParams();
        BasicProsodyModifierParams pmodParams = new BasicProsodyModifierParams();
        int samplingRateInHz = 16000;
        int totalFrm = 0;
        float originalDurationInSeconds = 0.0f;
        int i = 0;
        while (i < datagrams.length) {
            j = 0;
            while (j < datagrams[i].length) {
                if (datagrams[i][j] != null && datagrams[i][j] instanceof HnmDatagram) {
                    ++totalFrm;
                    ((HnmDatagram)datagrams[i][j]).getDuration();
                    float deltaTimeInSeconds = ((HnmDatagram)datagrams[i][j]).getFrame().deltaAnalysisTimeInSeconds;
                    originalDurationInSeconds += deltaTimeInSeconds;
                }
                ++j;
            }
            ++i;
        }
        HntmSpeechSignal hnmSignal = null;
        hnmSignal = new HntmSpeechSignal(totalFrm, samplingRateInHz, originalDurationInSeconds);
        HntmSpeechFrame[] leftContextFrames = new HntmSpeechFrame[totalFrm];
        HntmSpeechFrame[] rightContextFrames = new HntmSpeechFrame[totalFrm];
        int frameCount = 0;
        float tAnalysisInSeconds = 0.0f;
        i = 0;
        while (i < datagrams.length) {
            j = 0;
            while (j < datagrams[i].length) {
                if (datagrams[i][j] != null && datagrams[i][j] instanceof HnmDatagram && frameCount < totalFrm) {
                    hnmSignal.frames[frameCount] = ((HnmDatagram)datagrams[i][j]).getFrame();
                    hnmSignal.frames[frameCount].tAnalysisInSeconds = tAnalysisInSeconds += ((HnmDatagram)datagrams[i][j]).getFrame().deltaAnalysisTimeInSeconds;
                    if (j == 0) {
                        if (leftContexts[i] != null && leftContexts[i] instanceof HnmDatagram) {
                            leftContextFrames[frameCount] = ((HnmDatagram)leftContexts[i]).getFrame();
                        }
                    } else if (datagrams[i][j - 1] != null && datagrams[i][j - 1] instanceof HnmDatagram) {
                        leftContextFrames[frameCount] = ((HnmDatagram)datagrams[i][j - 1]).getFrame();
                    }
                    if (j == datagrams[i].length - 1) {
                        if (rightContexts[i] != null && rightContexts[i] instanceof HnmDatagram) {
                            rightContextFrames[frameCount] = ((HnmDatagram)rightContexts[i]).getFrame();
                        }
                    } else if (datagrams[i][j + 1] != null && datagrams[i][j + 1] instanceof HnmDatagram) {
                        rightContextFrames[frameCount] = ((HnmDatagram)datagrams[i][j + 1]).getFrame();
                    }
                    ++frameCount;
                }
                ++j;
            }
            ++i;
        }
        HntmSynthesizedSignal ss = null;
        if (totalFrm > 0) {
            ss = s.synthesize(hnmSignal, leftContextFrames, rightContextFrames, pmodParams, null, analysisParams, synthesisParams);
            if (ss.output != null) {
                ss.output = MathUtils.multiply(ss.output, 3.0517578125E-5);
            }
        }
        if (ss != null && ss.output != null) {
            return new BufferedDoubleDataSource(ss.output);
        }
        return null;
    }

    public static class HnmUnitData
    extends OverlapUnitConcatenator.OverlapUnitData {
        protected Datagram leftContextFrame;

        public void setLeftContextFrame(Datagram aLeftContextFrame) {
            this.leftContextFrame = aLeftContextFrame;
        }

        public Datagram getLeftContextFrame() {
            return this.leftContextFrame;
        }
    }
}

