/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.test;

import java.io.IOException;
import marytts.signalproc.sinusoidal.test.HarmonicsTester;
import marytts.signalproc.sinusoidal.test.NoiseTester;
import marytts.signalproc.sinusoidal.test.SinusoidsNoiseTester;
import marytts.util.string.StringUtils;

public class HarmonicsNoiseTester
extends SinusoidsNoiseTester {
    public HarmonicsNoiseTester(HarmonicsTester s, NoiseTester n) {
        super(s, n);
    }

    public static void main(String[] args) throws IOException {
        HarmonicsTester s = null;
        NoiseTester n = null;
        HarmonicsNoiseTester h = null;
        float f1 = 400.0f;
        int numHarmonics = 8;
        float harmonicsStartTimeInSeconds = 0.0f;
        float harmonicsEndTimeInSeconds = 1.0f;
        s = new HarmonicsTester(f1, numHarmonics, harmonicsStartTimeInSeconds, harmonicsEndTimeInSeconds);
        int numNoises = 1;
        float[][] freqs = new float[numNoises][];
        float[] amps = new float[numNoises];
        float noiseStartTimeInSeconds = 0.0f;
        float noiseEndTimeInSeconds = 1.0f;
        int i = 0;
        while (i < numNoises) {
            freqs[i] = new float[2];
            ++i;
        }
        freqs[0][0] = 4000.0f;
        freqs[0][1] = 6000.0f;
        amps[0] = DEFAULT_AMP;
        n = new NoiseTester((float[][])freqs, amps, noiseStartTimeInSeconds, noiseEndTimeInSeconds);
        String wavFile = args[0];
        String ptcFile = args.length > 1 ? args[1] : StringUtils.modifyExtension(wavFile, "ptc");
        String fileExt = StringUtils.getFileExtension(wavFile, true);
        String harmonicsWavFile = String.valueOf(StringUtils.getFolderName(wavFile)) + StringUtils.getFileName(wavFile, true) + "_harmonicsOrig" + fileExt;
        String noiseWavFile = String.valueOf(StringUtils.getFolderName(wavFile)) + StringUtils.getFileName(wavFile, true) + "_noiseOrig" + fileExt;
        s.write(harmonicsWavFile);
        n.write(noiseWavFile);
        h = new HarmonicsNoiseTester(s, n);
        if (args.length > 1) {
            h.write(wavFile, ptcFile);
        } else {
            h.write(wavFile);
        }
    }
}

