/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.AlignmentData;
import marytts.signalproc.analysis.F0ReaderWriter;
import marytts.signalproc.analysis.FestivalUtt;
import marytts.signalproc.analysis.Labels;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.process.VoiceModificationParameters;
import marytts.util.data.AlignLabelsUtils;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.io.FileUtils;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;
import marytts.util.string.StringUtils;

public class VoiceModificationParametersPreprocessor
extends VoiceModificationParameters {
    public double[] pscalesVar;
    public double[] tscalesVar;
    public double[] escalesVar;
    public double[] vscalesVar;
    public double tscaleSingle;
    public int numPeriods;

    public VoiceModificationParametersPreprocessor(int samplingRate, int LPOrder, double[] pscalesIn, double[] tscalesIn, double[] escalesIn, double[] vscalesIn, int[] pitchMarksIn, double wsFixedIn, double ssFixedIn, int numfrm, int numfrmFixed, int numPeriodsIn, boolean isFixedRate) {
        super(samplingRate, LPOrder, pscalesIn, tscalesIn, escalesIn, vscalesIn);
        this.initialise(pitchMarksIn, wsFixedIn, ssFixedIn, numfrm, numfrmFixed, numPeriodsIn, isFixedRate);
    }

    public VoiceModificationParametersPreprocessor(String sourcePitchFile, boolean isF0File, String sourceLabelFile, String sourceWavFile, String targetPitchFile, String targetWavFile, boolean isPitchFromTargetFile, int pitchFromTargetMethod, boolean isDurationFromTargetFile, int durationFromTargetMethod, boolean isEnergyFromTargetFile, int targetAlignmentFileType, String targetAlignmentFile, int[] pitchMarks, double wsFixed, double ssFixed, int numfrmIn, int numfrmFixedIn, int numPeriodsIn, boolean isFixedRate) throws IOException {
        int i;
        this.numPeriods = numPeriodsIn;
        double[] sourceEns = null;
        double[] targetEns = null;
        if (isEnergyFromTargetFile) {
            AudioInputStream inputAudioSrc = null;
            try {
                inputAudioSrc = AudioSystem.getAudioInputStream(new File(sourceWavFile));
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Cannot open audio " + sourceWavFile, e);
            }
            AudioInputStream inputAudioTgt = null;
            try {
                FileUtils.copy(targetWavFile, String.valueOf(targetWavFile) + ".wav");
                inputAudioTgt = AudioSystem.getAudioInputStream(new File(String.valueOf(targetWavFile) + ".wav"));
            }
            catch (UnsupportedAudioFileException e) {
                throw new IOException("Cannot open audio " + targetWavFile + ".wav", e);
            }
            if (inputAudioSrc != null && inputAudioTgt != null) {
                AudioDoubleDataSource inputSrc = new AudioDoubleDataSource(inputAudioSrc);
                double[] sourceSignal = inputSrc.getAllData();
                int fsSource = (int)inputAudioSrc.getFormat().getSampleRate();
                AudioDoubleDataSource inputTgt = new AudioDoubleDataSource(inputAudioTgt);
                double[] targetSignal = inputTgt.getAllData();
                int fsTarget = (int)inputAudioTgt.getFormat().getSampleRate();
                inputAudioSrc.close();
                inputAudioTgt.close();
                FileUtils.delete(String.valueOf(targetWavFile) + ".wav");
                sourceEns = SignalProcUtils.getEnergyContourRms(sourceSignal, wsFixed, ssFixed, fsSource);
                targetEns = SignalProcUtils.getEnergyContourRms(targetSignal, wsFixed, ssFixed, fsTarget);
            }
        }
        AlignmentData ad = null;
        if ((isPitchFromTargetFile || isDurationFromTargetFile || isEnergyFromTargetFile) && FileUtils.exists(targetAlignmentFile)) {
            if (targetAlignmentFileType == 1) {
                ad = new Labels(targetAlignmentFile);
            } else if (targetAlignmentFileType == 2) {
                ad = new FestivalUtt(targetAlignmentFile);
            }
        }
        PitchReaderWriter sourceF0s = null;
        sourceF0s = isF0File ? new F0ReaderWriter(sourcePitchFile) : new PitchReaderWriter(sourcePitchFile);
        Labels sourceLabels = new Labels(sourceLabelFile);
        PitchReaderWriter targetF0s = null;
        if (targetPitchFile != null && FileUtils.exists(targetPitchFile)) {
            targetF0s = isF0File ? new F0ReaderWriter(targetPitchFile) : new PitchReaderWriter(targetPitchFile);
        }
        this.tscaleSingle = -1.0;
        this.pscalesVar = MathUtils.ones(numfrmIn);
        double[] sourceMappedF0s = MathUtils.zeros(numfrmIn);
        double[] targetMappedF0s = MathUtils.zeros(numfrmIn);
        this.tscalesVar = MathUtils.ones(numfrmIn);
        this.escalesVar = MathUtils.ones(numfrmIn);
        this.vscalesVar = MathUtils.ones(numfrmIn);
        boolean[] voiceds = new boolean[numfrmIn];
        Arrays.fill(voiceds, false);
        int[][] durationMap = null;
        Labels targetDurationLabels = null;
        Labels targetPitchLabels = null;
        if (ad != null) {
            if (ad instanceof FestivalUtt) {
                i = 0;
                while (i < ((FestivalUtt)ad).labels.length) {
                    if (((FestivalUtt)ad).keys[i].compareTo("==Segment==") == 0 && durationMap == null) {
                        durationMap = AlignLabelsUtils.alignLabels(sourceLabels.items, ((FestivalUtt)ad).labels[i].items);
                        targetDurationLabels = new Labels(((FestivalUtt)ad).labels[i].items);
                    } else if (((FestivalUtt)ad).keys[i].compareTo("==Target==") == 0) {
                        targetPitchLabels = new Labels(((FestivalUtt)ad).labels[i]);
                    }
                    ++i;
                }
            } else if (ad instanceof Labels) {
                durationMap = AlignLabelsUtils.alignLabels(sourceLabels.items, ad.items);
                targetDurationLabels = new Labels((Labels)ad);
                targetPitchLabels = new Labels((Labels)ad);
            }
        }
        double[] cfr_ignored_0 = new double[numfrmIn];
        if (durationMap != null && targetDurationLabels != null && targetPitchLabels != null) {
            double targetDuration;
            int targetDurationLabInd;
            double sourceDuration;
            i = 0;
            while (i < numfrmIn) {
                double sourceLocationInLabelPercent;
                double tSource = !isFixedRate ? 0.5 * (double)(pitchMarks[i + this.numPeriods] + pitchMarks[i]) / (double)this.fs : (double)i * ssFixed + 0.5 * wsFixed;
                int sourceLabInd = SignalProcUtils.time2LabelIndex(tSource, sourceLabels);
                if (sourceLabInd > 0) {
                    sourceDuration = sourceLabels.items[sourceLabInd].time - sourceLabels.items[sourceLabInd - 1].time;
                    sourceLocationInLabelPercent = (tSource - sourceLabels.items[sourceLabInd - 1].time) / sourceDuration;
                } else {
                    sourceDuration = sourceLabels.items[sourceLabInd].time;
                    sourceLocationInLabelPercent = tSource / sourceLabels.items[sourceLabInd].time;
                }
                targetDurationLabInd = StringUtils.findInMap(durationMap, sourceLabInd);
                targetDuration = targetDurationLabInd > 0 ? targetDurationLabels.items[targetDurationLabInd].time - targetDurationLabels.items[targetDurationLabInd - 1].time : targetDurationLabels.items[targetDurationLabInd].time;
                this.tscalesVar[i] = 1.0;
                if (durationFromTargetMethod == 2) {
                    double sourceDurationNeigh = sourceDuration;
                    if (sourceLabInd > 1) {
                        sourceDurationNeigh += sourceLabels.items[sourceLabInd - 1].time - sourceLabels.items[sourceLabInd - 2].time;
                    }
                    if (sourceLabInd < sourceLabels.items.length - 1) {
                        sourceDurationNeigh += sourceLabels.items[sourceLabInd + 1].time - sourceLabels.items[sourceLabInd].time;
                    }
                    double targetDurationNeigh = targetDuration;
                    if (targetDurationLabInd > 1) {
                        targetDurationNeigh += targetDurationLabels.items[targetDurationLabInd - 1].time - targetDurationLabels.items[targetDurationLabInd - 2].time;
                    }
                    if (targetDurationLabInd < targetDurationLabels.items.length - 1) {
                        targetDurationNeigh += targetDurationLabels.items[targetDurationLabInd + 1].time - targetDurationLabels.items[targetDurationLabInd].time;
                    }
                    this.tscalesVar[i] = targetDurationNeigh / sourceDurationNeigh;
                } else if (durationFromTargetMethod == 1 && targetDurationLabInd >= 0) {
                    this.tscalesVar[i] = targetDuration / sourceDuration;
                }
                double tTarget = -1.0;
                double targetPitch = 0.0;
                double sourcePitch = 0.0;
                this.pscalesVar[i] = 1.0;
                if (isPitchFromTargetFile) {
                    int sourcePitchInd = SignalProcUtils.time2frameIndex(tSource, sourceF0s.header.windowSizeInSeconds, sourceF0s.header.skipSizeInSeconds);
                    if (sourcePitchInd > sourceF0s.header.numfrm - 1) {
                        sourcePitchInd = sourceF0s.header.numfrm - 1;
                    }
                    if ((sourcePitch = sourceF0s.contour[sourcePitchInd]) > 10.0) {
                        voiceds[i] = true;
                    }
                    if (ad instanceof FestivalUtt) {
                        tTarget = tSource;
                        int targetPitchLabInd = SignalProcUtils.time2LabelIndex(tTarget, targetPitchLabels);
                        targetPitch = targetPitchLabInd > 0 ? MathUtils.linearMap(tTarget, targetPitchLabels.items[targetPitchLabInd - 1].time, targetPitchLabels.items[targetPitchLabInd].time, targetPitchLabels.items[targetPitchLabInd - 1].valuesRest[0], targetPitchLabels.items[targetPitchLabInd].valuesRest[0]) : targetPitchLabels.items[targetPitchLabInd].valuesRest[0];
                    } else if (ad instanceof Labels) {
                        if (targetF0s != null) {
                            tTarget = targetDurationLabInd > 0 ? targetDurationLabels.items[targetDurationLabInd - 1].time + sourceLocationInLabelPercent * targetDuration : sourceLocationInLabelPercent * targetDuration;
                            int targetPitchInd = SignalProcUtils.time2frameIndex(tTarget, targetF0s.header.windowSizeInSeconds, targetF0s.header.skipSizeInSeconds);
                            targetPitchInd = MathUtils.CheckLimits(targetPitchInd, 0, targetF0s.contour.length - 1);
                            targetPitch = targetF0s.contour[targetPitchInd];
                        } else {
                            targetPitch = sourcePitch;
                        }
                    }
                    sourceMappedF0s[i] = sourcePitch;
                    targetMappedF0s[i] = targetPitch;
                    if (pitchFromTargetMethod == 30) {
                        this.pscalesVar[i] = targetPitch > 10.0 && sourcePitch > 10.0 ? targetPitch / sourcePitch : 1.0;
                    }
                }
                if (isEnergyFromTargetFile && sourceEns != null && targetEns != null) {
                    int sourceEnergyInd = SignalProcUtils.time2frameIndex(tSource, wsFixed, ssFixed);
                    sourceEnergyInd = MathUtils.CheckLimits(sourceEnergyInd, 0, sourceEns.length - 1);
                    int targetEnergyInd = SignalProcUtils.time2frameIndex(tTarget, wsFixed, ssFixed);
                    targetEnergyInd = MathUtils.CheckLimits(targetEnergyInd, 0, targetEns.length - 1);
                    this.escalesVar[i] = targetEns[targetEnergyInd] / sourceEns[sourceEnergyInd];
                }
                System.out.println("SLab=" + sourceLabels.items[sourceLabInd].phn + " TLab=" + targetDurationLabels.items[targetDurationLabInd].phn + " STime=" + String.valueOf(tSource) + " TTime=" + String.valueOf(tTarget) + " SPtich=" + sourcePitch + " TPitch=" + targetPitch + " ps=" + String.valueOf(this.pscalesVar[i]) + " ts=" + String.valueOf(this.tscalesVar[i]));
                ++i;
            }
            if (pitchFromTargetMethod == 30) {
                i = 0;
                while (i < numfrmIn) {
                    if (!voiceds[i]) {
                        this.pscalesVar[i] = 1.0;
                    }
                    this.pscalesVar[i] = Math.max(this.pscalesVar[i], 0.6);
                    this.pscalesVar[i] = Math.min(this.pscalesVar[i], 2.5);
                    ++i;
                }
                i = 0;
                while (i < numfrmIn) {
                    this.tscalesVar[i] = Math.max(this.tscalesVar[i], 0.6);
                    this.tscalesVar[i] = Math.min(this.tscalesVar[i], 2.5);
                    ++i;
                }
            } else if (pitchFromTargetMethod == 21 || pitchFromTargetMethod == 26) {
                double[] sourceVoicedF0s = MathUtils.findValues(sourceF0s.contour, 1, 10.0);
                double[] targetVoicedF0s = MathUtils.findValues(targetF0s.contour, 1, 10.0);
                double sourceF0Mean = MathUtils.mean(sourceVoicedF0s);
                double targetF0Mean = MathUtils.mean(targetVoicedF0s);
                if (pitchFromTargetMethod == 26) {
                    double sourceF0Std = MathUtils.standardDeviation(sourceVoicedF0s, sourceF0Mean);
                    double targetF0Std = MathUtils.standardDeviation(targetVoicedF0s, targetF0Mean);
                    i = 0;
                    while (i < numfrmIn) {
                        this.pscalesVar[i] = 1.0;
                        if (sourceMappedF0s[i] > 10.0 && targetMappedF0s[i] > 10.0) {
                            double tF0 = (sourceMappedF0s[i] - sourceF0Mean) / sourceF0Std * targetF0Std + targetF0Mean;
                            this.pscalesVar[i] = tF0 / sourceMappedF0s[i];
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < numfrmIn) {
                        this.pscalesVar[i] = 1.0;
                        if (sourceMappedF0s[i] > 10.0 && targetMappedF0s[i] > 10.0) {
                            this.pscalesVar[i] = targetF0Mean / sourceF0Mean;
                        }
                        ++i;
                    }
                }
            }
            if (isDurationFromTargetFile && durationFromTargetMethod == 3) {
                String[] silenceLabels = new String[]{"H#", "_"};
                double totalSourceDur = 0.0;
                double totalTargetDur = 0.0;
                i = 0;
                while (i < sourceLabels.items.length) {
                    if (!StringUtils.isOneOf(sourceLabels.items[i].phn, silenceLabels)) {
                        sourceDuration = i > 0 ? sourceLabels.items[i].time - sourceLabels.items[i - 1].time : sourceLabels.items[i].time;
                        targetDurationLabInd = StringUtils.findInMap(durationMap, i);
                        targetDuration = targetDurationLabInd > 0 ? targetDurationLabels.items[targetDurationLabInd].time - targetDurationLabels.items[targetDurationLabInd - 1].time : targetDurationLabels.items[targetDurationLabInd].time;
                        totalSourceDur += sourceDuration;
                        totalTargetDur += targetDuration;
                    }
                    ++i;
                }
                Arrays.fill(this.tscalesVar, totalTargetDur / totalSourceDur);
                System.out.println("Average duration scale=" + String.valueOf(totalTargetDur / totalSourceDur));
            }
        }
    }

    private void initialise(int[] pitchMarksIn, double wsFixedIn, double ssFixedIn, int numfrm, int numfrmFixed, int numPeriodsIn, boolean isFixedRate) {
        this.numPeriods = numPeriodsIn;
        if (pitchMarksIn != null) {
            this.getScalesVar(pitchMarksIn, wsFixedIn, ssFixedIn, numfrm, numfrmFixed, isFixedRate);
        }
    }

    private void getScalesVar(int[] pitchMarks, double wsFixed, double ssFixed, int numfrm, int numfrmFixed, boolean isFixedRate) {
        this.tscaleSingle = this.tscales.length == 1 ? this.tscales[0] : -1.0;
        if (this.pscales.length != numfrmFixed) {
            this.pscales = MathUtils.modifySize(this.pscales, numfrmFixed);
        }
        if (this.tscales.length != numfrmFixed) {
            this.tscales = MathUtils.modifySize(this.tscales, numfrmFixed);
        }
        if (this.escales.length != numfrmFixed) {
            this.escales = MathUtils.modifySize(this.escales, numfrmFixed);
        }
        if (this.vscales.length != numfrmFixed) {
            this.vscales = MathUtils.modifySize(this.vscales, numfrmFixed);
        }
        this.pscalesVar = MathUtils.ones(numfrm);
        this.tscalesVar = MathUtils.ones(numfrm);
        this.escalesVar = MathUtils.ones(numfrm);
        this.vscalesVar = MathUtils.ones(numfrm);
        int i = 0;
        while (i < numfrm) {
            double tVar = !isFixedRate ? 0.5 * (double)(pitchMarks[i + this.numPeriods] + pitchMarks[i]) / (double)this.fs : (double)i * ssFixed + 0.5 * wsFixed;
            int ind = (int)Math.floor((tVar - 0.5 * wsFixed) / ssFixed + 0.5);
            if (ind < 0) {
                ind = 0;
            }
            if (ind > numfrmFixed - 1) {
                ind = numfrmFixed - 1;
            }
            this.pscalesVar[i] = this.pscales[ind];
            this.tscalesVar[i] = this.tscales[ind];
            this.escalesVar[i] = this.escales[ind];
            this.vscalesVar[i] = this.vscales[ind];
            ++i;
        }
    }
}

