/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.io.FileReader;
import java.util.Arrays;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.signalproc.window.DynamicTwoHalvesWindow;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.text.ESTTextfileDoubleDataSource;

public class PitchFrameProvider
extends FrameProvider {
    protected DoubleDataSource pitchmarks;
    protected int[] periodLengths;
    protected int shiftPeriods;
    protected int periodsInMemory;
    protected long currPitchmark;
    protected DynamicTwoHalvesWindow twoHalvesWindow;
    protected double[] cutFrame;

    public PitchFrameProvider(DoubleDataSource signal, DoubleDataSource pitchmarks, InlineDataProcessor processor, int samplingRate) {
        this(signal, pitchmarks, processor, samplingRate, 1, 1);
    }

    public PitchFrameProvider(DoubleDataSource signal, DoubleDataSource pitchmarks, InlineDataProcessor processor, int samplingRate, int framePeriods, int shiftPeriods) {
        super(signal, null, 0, 0, samplingRate, true);
        this.pitchmarks = pitchmarks;
        this.periodLengths = new int[framePeriods];
        this.shiftPeriods = shiftPeriods;
        this.periodsInMemory = 0;
        this.currPitchmark = 0L;
        if (processor instanceof DynamicTwoHalvesWindow) {
            this.twoHalvesWindow = (DynamicTwoHalvesWindow)processor;
        } else {
            this.processor = processor;
        }
    }

    @Override
    protected int getData(int nPrefilled) {
        int nPeriodsToGet;
        assert (this.hasMoreData());
        if (nPrefilled == 0) {
            nPeriodsToGet = this.periodLengths.length;
            this.periodsInMemory = 0;
        } else {
            nPeriodsToGet = this.shiftPeriods;
            System.arraycopy(this.periodLengths, this.shiftPeriods, this.periodLengths, 0, this.periodLengths.length - this.shiftPeriods);
            this.periodsInMemory -= this.shiftPeriods;
        }
        int pos = nPrefilled;
        int i = this.periodLengths.length - nPeriodsToGet;
        while (i < this.periodLengths.length) {
            if (this.signal.hasMoreData() && this.pitchmarks.hasMoreData()) {
                long prevPitchmark = this.currPitchmark;
                double pitchmarkInSeconds = this.pitchmarks.getData(1)[0];
                this.currPitchmark = Math.round(pitchmarkInSeconds * (double)this.samplingRate);
                this.periodLengths[i] = (int)(this.currPitchmark - prevPitchmark);
                assert (this.periodLengths[i] < this.samplingRate / 33) : "Found pitch period longer than 30 ms (less than 33 Hz)";
                assert (this.periodLengths[i] > this.samplingRate / 1000) : "Found pitch period shorter than 1 ms (more than 1000 Hz)";
                if (pos + this.periodLengths[i] > this.frame.length) {
                    double[] oldFrame = this.frame;
                    this.frame = new double[pos + this.periodLengths[i]];
                    if (pos > 0) {
                        System.arraycopy(oldFrame, 0, this.frame, 0, pos);
                    }
                }
                int read = this.signal.getData(this.frame, pos, this.periodLengths[i]);
                assert (read == this.periodLengths[i]) : "expected " + this.periodLengths[i] + ", got " + read;
                pos += read;
                ++this.periodsInMemory;
            } else {
                if (this.periodsInMemory <= 0) {
                    return 0;
                }
                assert (i > 0);
                this.periodLengths[i] = this.periodLengths[i - 1];
                if (pos + this.periodLengths[i] > this.frame.length) {
                    double[] oldFrame = this.frame;
                    this.frame = new double[pos + this.periodLengths[i]];
                    if (pos > 0) {
                        System.arraycopy(oldFrame, 0, this.frame, 0, pos);
                    }
                }
                Arrays.fill(this.frame, pos, pos + this.periodLengths[i], 0.0);
                pos += this.periodLengths[i];
            }
            ++i;
        }
        this.frameShift = 0;
        i = 0;
        while (i < this.shiftPeriods) {
            this.frameShift += this.periodLengths[i];
            ++i;
        }
        this.frameLength = 0;
        i = 0;
        while (i < this.periodLengths.length) {
            this.frameLength += this.periodLengths[i];
            ++i;
        }
        return pos - nPrefilled;
    }

    @Override
    public double[] getNextFrame() {
        double[] uncutFrame = super.getNextFrame();
        if (uncutFrame == null) {
            this.cutFrame = null;
            return null;
        }
        int frameLength = super.getFrameLengthSamples();
        this.cutFrame = new double[frameLength];
        System.arraycopy(uncutFrame, 0, this.cutFrame, 0, frameLength);
        if (this.twoHalvesWindow != null) {
            assert (this.periodLengths.length % 2 == 0) : "Using two half windows makes sense only for an even number of periods per frame";
            int middle = 0;
            int i = 0;
            while (i < this.periodLengths.length / 2) {
                middle += this.periodLengths[i];
                ++i;
            }
            assert (middle < frameLength) : "Middle " + middle + " larger than framelength " + frameLength + "!";
            this.twoHalvesWindow.applyInlineLeftHalf(this.cutFrame, 0, middle);
            this.twoHalvesWindow.applyInlineRightHalf(this.cutFrame, middle, frameLength - middle);
        }
        return this.cutFrame;
    }

    @Override
    public double[] getCurrentFrame() {
        return this.cutFrame;
    }

    public int getFramePeriods() {
        return this.periodLengths.length;
    }

    public int getShiftPeriods() {
        return this.shiftPeriods;
    }

    @Override
    public boolean hasMoreData() {
        return this.signal.hasMoreData() && this.pitchmarks.hasMoreData() || this.periodsInMemory - this.shiftPeriods > 0;
    }

    public static void main(String[] args) throws Exception {
        File audioFile = new File(args[0]);
        File pitchmarkFile = new File(args[1]);
        AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        ESTTextfileDoubleDataSource pitchmarks = new ESTTextfileDoubleDataSource(new FileReader(pitchmarkFile));
        PitchFrameProvider pfp = new PitchFrameProvider(signal, pitchmarks, null, samplingRate);
        int n = 0;
        int avgF0 = 0;
        while (pfp.getNextFrame() != null) {
            int periodLength = pfp.validSamplesInFrame();
            if (periodLength > 0) {
                int f0 = samplingRate / periodLength;
                double frameStartTime = pfp.getFrameStartTime();
                double frameEndTime = frameStartTime + pfp.getFrameLengthTime();
                avgF0 += f0;
                ++n;
                System.err.println("Frame " + frameStartTime + " - " + frameEndTime + " s: " + periodLength + " samples, " + f0 + " Hz");
                continue;
            }
            System.err.println("Read empty frame");
        }
        System.err.println("Average F0: " + (avgF0 /= n) + " Hz");
    }
}

