/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.display;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import marytts.signalproc.display.CursorEvent;
import marytts.signalproc.display.CursorListener;
import marytts.signalproc.display.CursorSource;

public class CursorDisplayer
extends JPanel
implements CursorListener {
    protected List cursorSources;

    public CursorDisplayer() {
        this.setOpaque(false);
        this.setVisible(true);
        this.cursorSources = new ArrayList();
    }

    public void addCursorSource(CursorSource s) {
        this.cursorSources.add(s);
    }

    public CursorSource[] getCursorSources() {
        return this.cursorSources.toArray(new CursorSource[0]);
    }

    public boolean removeCursorSource(CursorSource s) {
        return this.cursorSources.remove(s);
    }

    @Override
    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        for (CursorSource source : this.cursorSources) {
            Label valueLabel;
            CursorLine rangeCursor;
            CursorLine positionCursor = source.getPositionCursor();
            if (positionCursor != null) {
                int x = positionCursor.getX(this);
                g.setColor(positionCursor.getColor());
                g.drawLine(x, positionCursor.getYMin(this), x, positionCursor.getYMax(this));
            }
            if ((rangeCursor = source.getRangeCursor()) != null) {
                int x = rangeCursor.getX(this);
                g.setColor(rangeCursor.getColor());
                g.drawLine(x, rangeCursor.getYMin(this), x, rangeCursor.getYMax(this));
            }
            if (positionCursor != null && rangeCursor != null) {
                Composite origC = g.getComposite();
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.3f);
                g.setComposite(ac);
                g.fillRect(positionCursor.getX(this), positionCursor.getYMin(this), rangeCursor.getX(this) - positionCursor.getX(this), rangeCursor.getYMax(this) - positionCursor.getYMin(this));
                g.setComposite(origC);
            }
            if ((valueLabel = source.getValueLabel()) == null) continue;
            g.setColor(valueLabel.getColor());
            g.drawString(valueLabel.getText(), valueLabel.getX(this), valueLabel.getY(this));
        }
    }

    @Override
    public void updateCursorPosition(CursorEvent e) {
        this.repaint();
    }

    public static class CursorLine {
        protected Component source;
        protected int sourceX;
        protected int sourceYMin;
        protected int sourceYMax;
        protected Color color;

        public CursorLine(Component source) {
            this(source, -1, -1, -1);
        }

        public CursorLine(Component source, int sourceX, int sourceYMin, int sourceYMax) {
            this(source, sourceX, sourceYMin, sourceYMax, Color.RED);
        }

        public CursorLine(Component source, int sourceX, int sourceYMin, int sourceYMax, Color color) {
            this.source = source;
            this.sourceX = sourceX;
            this.sourceYMin = sourceYMin;
            this.sourceYMax = sourceYMax;
            this.color = color;
        }

        public void setSourceX(int sourceX) {
            this.sourceX = sourceX;
        }

        public void setSourceYMin(int sourceYMin) {
            this.sourceYMin = sourceYMin;
        }

        public void setSourceYMax(int sourceYMax) {
            this.sourceYMax = sourceYMax;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public int getSourceX() {
            return this.sourceX;
        }

        public int getSourceYMin() {
            return this.sourceYMin;
        }

        public int getSourceYMax() {
            return this.sourceYMax;
        }

        public Color getColor() {
            return this.color;
        }

        public int getX(Component target) {
            if (this.sourceX < 0) {
                return -1;
            }
            return SwingUtilities.convertPoint((Component)this.source, (int)this.sourceX, (int)0, (Component)target).x;
        }

        public int getYMin(Component target) {
            if (this.sourceYMin < 0) {
                return -1;
            }
            return SwingUtilities.convertPoint((Component)this.source, (int)0, (int)this.sourceYMin, (Component)target).y;
        }

        public int getYMax(Component target) {
            if (this.sourceYMax < 0) {
                return -1;
            }
            return SwingUtilities.convertPoint((Component)this.source, (int)0, (int)this.sourceYMax, (Component)target).y;
        }
    }

    public static class Label {
        protected Component source;
        protected String text;
        protected int sourceX;
        protected int sourceY;
        protected Color color;

        public Label(Component source) {
            this(source, null, -1, -1);
        }

        public Label(Component source, String text, int sourceX, int sourceY) {
            this(source, text, sourceX, sourceY, Color.RED);
        }

        public Label(Component source, String text, int sourceX, int sourceY, Color color) {
            this.source = source;
            this.text = text;
            this.sourceX = sourceX;
            this.sourceY = sourceY;
            this.color = color;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setSourceX(int sourceX) {
            this.sourceX = sourceX;
        }

        public void setSourceY(int sourceY) {
            this.sourceY = sourceY;
        }

        public int getSourceX() {
            return this.sourceX;
        }

        public int getSourceY() {
            return this.sourceY;
        }

        public String getText() {
            return this.text;
        }

        public Color getColor() {
            return this.color;
        }

        public int getX(Component target) {
            if (this.sourceX < 0) {
                return -1;
            }
            return SwingUtilities.convertPoint((Component)this.source, (int)this.sourceX, (int)0, (Component)target).x;
        }

        public int getY(Component target) {
            if (this.sourceY < 0) {
                return -1;
            }
            return SwingUtilities.convertPoint((Component)this.source, (int)0, (int)this.sourceY, (Component)target).y;
        }
    }
}

