/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jci.stores;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.jci.stores.ResourceStore;

public final class FileResourceStore
implements ResourceStore {
    private final File root;

    public FileResourceStore(File pFile) {
        this.root = pFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String pResourceName) {
        byte[] byArray;
        FileInputStream is = null;
        try {
            byte[] data;
            is = new FileInputStream(this.getFile(pResourceName));
            byArray = data = IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                byArray2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            return byArray2;
        }
        IOUtils.closeQuietly((InputStream)is);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void write(String pResourceName, byte[] pData) {
        FileOutputStream os = null;
        try {
            File file = this.getFile(pResourceName);
            File parent = file.getParentFile();
            if (!parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("could not create" + parent);
            }
            os = new FileOutputStream(file);
            ((OutputStream)os).write(pData);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(os);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    @Override
    public void remove(String pResourceName) {
        this.getFile(pResourceName).delete();
    }

    private File getFile(String pResourceName) {
        String fileName = pResourceName.replace('/', File.separatorChar);
        return new File(this.root, fileName);
    }

    @Deprecated
    public String[] list() {
        ArrayList<String> files = new ArrayList<String>();
        this.list(this.root, files);
        return files.toArray(new String[files.size()]);
    }

    @Deprecated
    private void list(File pFile, List<String> pFiles) {
        if (pFile.isDirectory()) {
            File[] directoryFiles = pFile.listFiles();
            for (int i = 0; i < directoryFiles.length; ++i) {
                this.list(directoryFiles[i], pFiles);
            }
        } else {
            pFiles.add(pFile.getAbsolutePath().substring(this.root.getAbsolutePath().length() + 1));
        }
    }

    public String toString() {
        return this.getClass().getName() + this.root.toString();
    }
}

