/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.pdf.create.constant;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import de.mn77.base.error.Err;
import java.io.IOException;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_IText_Font
extends A_Immutable {
    private final ArgCallBuffer arg;
    private final String bold;
    private final String italic;
    private final String boldItalic;
    private String regular;

    public JMo_IText_Font() {
        this.arg = null;
        this.regular = "Helvetica";
        this.bold = "Helvetica-Bold";
        this.italic = "Helvetica-Oblique";
        this.boldItalic = "Helvetica-BoldOblique";
    }

    public JMo_IText_Font(Call fontname) {
        this.arg = new ArgCallBuffer(0, fontname);
        this.regular = null;
        this.bold = null;
        this.italic = null;
        this.boldItalic = null;
    }

    public JMo_IText_Font(String regular, String bold, String italic, String boldItalic) {
        this.arg = null;
        this.regular = regular;
        this.bold = bold;
        this.italic = italic;
        this.boldItalic = boldItalic;
    }

    public boolean equals(Object other) {
        if (other instanceof JMo_IText_Font) {
            JMo_IText_Font o2 = (JMo_IText_Font)((Object)other);
            return this.regular.equals(o2.regular) && this.bold.equals(o2.bold) && this.italic.equals(o2.italic) && this.boldItalic.equals(o2.boldItalic);
        }
        return false;
    }

    public boolean equalsLazy(Object other) {
        return this.equals(other);
    }

    public BaseFont getBaseFont(CallRuntime cr, boolean bold, boolean italic) {
        BaseFont result = null;
        try {
            String fontname = this.iGetName(bold, italic);
            if (fontname == null) {
                throw new RuntimeError(cr, "Invalid font", "An individual font name cannot be formatted too bold or italic.");
            }
            result = BaseFont.createFont((String)fontname, (String)"Cp1252", (boolean)false);
        }
        catch (DocumentException e) {
            throw new RuntimeError(cr, "PDF error", e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeError(cr, "PDF font error", e.getMessage());
        }
        Err.ifNull((Object[])new Object[]{result});
        return result;
    }

    public A_Immutable getConstant(CallRuntime cr, String name) {
        switch (name) {
            case "HELVETICA": {
                return new JMo_IText_Font("Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique");
            }
            case "COURIER": {
                return new JMo_IText_Font("Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique");
            }
            case "TIMES": {
                return new JMo_IText_Font("Times", "Times-Bold", "Times-Italic", "Times-BoldItalic");
            }
        }
        throw new CodeError(cr, "Unknown constant", "Constant/Enum is not defined in <" + this.getTypeName() + ">: " + name);
    }

    public void init(CallRuntime cr) {
        if (this.arg != null) {
            Str so = (Str)this.arg.init(cr, (I_Object)this, Str.class);
            this.regular = Lib_Convert.getStringValue((CallRuntime)cr, (I_Object)so);
        }
    }

    protected ObjectCallResult call2(CallRuntime cr, String method) {
        return null;
    }

    private String iGetName(boolean bold, boolean italic) {
        if (!bold && !italic) {
            return this.regular;
        }
        if (bold && !italic) {
            return this.bold;
        }
        if (!bold && italic) {
            return this.italic;
        }
        return this.boldItalic;
    }
}

