/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.ext.db;

import de.mn77.ext.db.sql.A_SqlDB;
import java.sql.ResultSet;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.ext.db.JMo_DBResult;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;

public abstract class A_SqlDatabase
extends A_ObjectSimple {
    private A_SqlDB sqldb = null;

    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "open": 
            case "connect": {
                this.mConnect(cr);
                return this;
            }
            case "close": {
                this.mClose(cr);
                return this;
            }
            case "query": {
                return this.mQuery(cr);
            }
            case "exec": {
                this.mExec(cr);
                return this;
            }
            case "update": {
                return this.mUpdate(cr);
            }
        }
        return null;
    }

    protected abstract A_SqlDB openDatabase(CallRuntime var1);

    private void mConnect(CallRuntime cr) {
        cr.argsNone();
        if (this.sqldb != null) {
            throw new RuntimeError(cr, "Database-Error", "Database is already open.");
        }
        this.sqldb = this.openDatabase(cr);
    }

    private void mClose(CallRuntime cr) {
        cr.argsNone();
        if (this.sqldb == null) {
            throw new RuntimeError(cr, "Database-Error", "Database not open.");
        }
        this.sqldb.close();
        this.sqldb = null;
    }

    private void mExec(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String sql = ((Str)arg).getValue();
        this.iCheckOpen(cr);
        this.sqldb.exec(sql);
    }

    private I_Object mQuery(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String sql = ((Str)arg).getValue();
        this.iCheckOpen(cr);
        ResultSet rs = this.sqldb.query(sql);
        if (rs == null) {
            return Nil.NIL;
        }
        return new JMo_DBResult(rs, this.sqldb.getDBMS());
    }

    private Int mUpdate(CallRuntime cr) {
        I_Object arg = cr.args((I_Object)this, new Class[]{Str.class})[0];
        String sql = ((Str)arg).getValue();
        this.iCheckOpen(cr);
        int result = this.sqldb.update(sql);
        return new Int(result);
    }

    private void iCheckOpen(CallRuntime cr) {
        if (this.sqldb == null) {
            throw new RuntimeError(cr, "Database-Connection-Error", "Please open connection first!");
        }
    }
}

