/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create.page.item;

import com.lowagie.text.pdf.PdfContentByte;
import de.mn77.base.error.Err;
import de.mn77.ext.pdf.create.page.PDF_Page;
import de.mn77.ext.pdf.create.page.item.I_PDF_Item;
import java.awt.Color;

public class PDF_ItemRectangle
implements I_PDF_Item {
    private final float x;
    private final float y;
    private final float dx;
    private final float dy;
    private float thickness;
    private int[] colorFill;
    private int[] colorBorder;
    private boolean isFilled;
    private boolean hasBorder;

    public PDF_ItemRectangle(float x, float y, float dx, float dy) {
        this.x = x;
        this.dx = dx;
        this.y = y;
        this.dy = dy;
        this.thickness = 1.0f;
        this.colorBorder = new int[3];
        this.colorFill = new int[3];
        this.isFilled = false;
        this.hasBorder = true;
    }

    public PDF_ItemRectangle setBorderColor(int r, int g, int b) {
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{r});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{g});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{b});
        this.colorBorder = new int[]{r, g, b};
        return this;
    }

    public PDF_ItemRectangle setFillColor(int r, int g, int b) {
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{r});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{g});
        Err.ifOutOfBounds((double)0.0, (double)255.0, (double[])new double[]{b});
        this.colorFill = new int[]{r, g, b};
        return this;
    }

    public PDF_ItemRectangle setThickness(float thickness) {
        Err.ifOutOfBounds((double)0.0, (double)50.0, (double[])new double[]{thickness});
        this.thickness = thickness;
        return this;
    }

    public PDF_ItemRectangle setStyle(boolean isFilled, boolean hasBorder) {
        if (!isFilled && !hasBorder) {
            Err.invalid((Object[])new Object[]{"A rectangle without filling and border could not be drawed!"});
        }
        this.isFilled = isFilled;
        this.hasBorder = hasBorder;
        return this;
    }

    @Override
    public void draw(PDF_Page page, PdfContentByte cb) {
        if (this.isFilled) {
            cb.setColorFill(new Color(this.colorFill[0], this.colorFill[1], this.colorFill[2]));
            cb.rectangle(this.x, page.getHeight() - this.y - this.dy, this.dx, this.dy);
            cb.fill();
            cb.stroke();
        }
        if (this.hasBorder) {
            cb.setColorStroke(new Color(this.colorBorder[0], this.colorBorder[1], this.colorBorder[2]));
            cb.setLineWidth(this.thickness);
            cb.rectangle(this.x, page.getHeight() - this.y - this.dy, this.dx, this.dy);
            cb.stroke();
        }
    }
}

