/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.ext.pdf.create;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfWriter;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.ext.pdf.create.page.PDF_Page;
import de.mn77.ext.pdf.create.text.I_PDF_TextItem;
import de.mn77.ext.pdf.create.text.PDF_TextChunk;
import de.mn77.ext.pdf.create.text.PDF_TextParagraph;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PDF_Document {
    private OutputStream stream;
    private final I_List<Object> items;

    public PDF_Document(String pdfFile) throws Err_FileSys {
        Err.ifNull((Object[])new Object[]{pdfFile});
        try {
            this.stream = new FileOutputStream(pdfFile);
        }
        catch (FileNotFoundException e) {
            Err.wrap((IOException)e, (Object[])new Object[]{pdfFile});
        }
        this.items = new MList();
    }

    public PDF_Document(File pdfFile) throws Err_FileSys {
        Err.ifNull((Object[])new Object[]{pdfFile});
        try {
            this.stream = new FileOutputStream(pdfFile);
        }
        catch (FileNotFoundException e) {
            throw Err.wrap((IOException)e, (Object[])new Object[]{"File not found"});
        }
        this.items = new MList();
    }

    public PDF_Document(I_File pdfFile) throws Err_FileSys {
        Err.ifNull((Object[])new Object[]{pdfFile});
        this.stream = pdfFile.write();
        this.items = new MList();
    }

    public void close() {
        Document document = null;
        PdfWriter writer = null;
        for (Object item : this.items) {
            if (item instanceof PDF_Page) {
                PDF_Page page = (PDF_Page)item;
                Rectangle rect = page.getFormat().getRectangle();
                if (page.isLandscape()) {
                    rect = rect.rotate();
                }
                try {
                    if (document == null) {
                        document = new Document(page.getFormat().getRectangle());
                        writer = PdfWriter.getInstance((Document)document, (OutputStream)this.stream);
                        writer.setPdfVersion('2');
                        document.open();
                    } else {
                        document.setPageSize(rect);
                        document.newPage();
                        writer.setPageEmpty(false);
                    }
                    document.add((Element)new Chunk(""));
                    page.draw(writer.getDirectContent());
                    continue;
                }
                catch (DocumentException e) {
                    throw Err.direct((String)"PDF-Error", (Object[])new Object[]{e});
                }
            }
            ((I_PDF_TextItem)item).draw(document);
        }
        document.close();
    }

    public PDF_Page newPage() {
        PDF_Page result = new PDF_Page();
        this.items.add((Object)result);
        return result;
    }

    public PDF_TextChunk newText(String text) {
        PDF_TextChunk result = new PDF_TextChunk(text);
        this.items.add((Object)result);
        return result;
    }

    public PDF_TextParagraph newParagraph(String text) {
        PDF_TextParagraph result = new PDF_TextParagraph(text);
        this.items.add((Object)result);
        return result;
    }
}

