/*
 * Decompiled with CFR 0.152.
 */
package javax.visrec.ml.data;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import javax.visrec.ml.data.Column;

public interface DataSet<E>
extends Iterable<E> {
    public List<E> getItems();

    default public DataSet<E> add(E item) {
        Objects.requireNonNull(item, "Null items are not allowed in dataset");
        this.getItems().add(item);
        return this;
    }

    default public DataSet<E> addAll(DataSet<E> dataSet) {
        Objects.requireNonNull(dataSet, "Dataset is null. Cannot add items from null dataset");
        this.getItems().addAll(dataSet.getItems());
        return this;
    }

    default public E get(int idx) {
        return this.getItems().get(idx);
    }

    default public void clear() {
        this.getItems().clear();
    }

    default public boolean isEmpty() {
        return this.getItems().isEmpty();
    }

    default public int size() {
        return this.getItems().size();
    }

    @Override
    default public Iterator<E> iterator() {
        return this.getItems().iterator();
    }

    default public DataSet<E>[] split(int numParts) {
        double part = 1.0 / (double)numParts;
        double[] parts = new double[numParts];
        for (int i = 0; i < numParts; ++i) {
            parts[i] = part;
        }
        return this.split(parts);
    }

    default public DataSet<E>[] split(int numParts, Random rnd) {
        double part = 1.0 / (double)numParts;
        double[] parts = new double[numParts];
        for (int i = 0; i < numParts; ++i) {
            parts[i] = part;
        }
        return this.split(rnd, parts);
    }

    default public DataSet<E>[] split(double part) {
        return this.split(part, 1.0 - part);
    }

    public DataSet<E>[] split(double ... var1);

    default public DataSet<E>[] split(Random rnd, double ... parts) {
        this.shuffle(rnd);
        return this.split(parts);
    }

    default public void shuffle() {
        Collections.shuffle(this.getItems());
    }

    default public void shuffle(Random rnd) {
        Collections.shuffle(this.getItems(), rnd);
    }

    public void setColumns(List<Column> var1);

    public List<Column> getColumns();

    public String[] getTargetColumnsNames();

    default public Stream<E> stream() {
        return this.getItems().stream();
    }
}

