/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.neuroph.util.io.NeurophOutputException;
import org.neuroph.util.io.OutputAdapter;

public class OutputStreamAdapter
implements OutputAdapter {
    protected BufferedWriter bufferedWriter;

    public OutputStreamAdapter(OutputStream outputStream) {
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
    }

    public OutputStreamAdapter(BufferedWriter bufferedWriter) {
        this.bufferedWriter = bufferedWriter;
    }

    @Override
    public void writeOutput(double[] output) {
        try {
            StringBuilder outputLine = new StringBuilder();
            for (int i = 0; i < output.length; ++i) {
                outputLine.append(output[i]).append(' ').append((CharSequence)outputLine);
            }
            outputLine.append(System.lineSeparator());
            this.bufferedWriter.write(outputLine.toString());
        }
        catch (IOException ex) {
            throw new NeurophOutputException("Error writing output to stream!", ex);
        }
    }

    @Override
    public void close() {
        try {
            this.bufferedWriter.close();
        }
        catch (IOException ex) {
            throw new NeurophOutputException("Error closing output stream!", ex);
        }
    }
}

