/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import java.io.Serializable;
import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.data.norm.Normalizer;

public class RangeNormalizer
implements Normalizer,
Serializable {
    private double lowLimit = 0.0;
    private double highLimit = 1.0;
    private double[] maxIn;
    private double[] maxOut;
    private double[] minIn;
    private double[] minOut;

    public RangeNormalizer(double lowLimit, double highLimit) {
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
    }

    @Override
    public void normalize(DataSet dataSet) {
        this.findMaxAndMinVectors(dataSet);
        for (DataSetRow row : dataSet.getRows()) {
            double[] normalizedInput = this.normalizeToRange(row.getInput(), this.minIn, this.maxIn);
            row.setInput(normalizedInput);
            if (!dataSet.isSupervised()) continue;
            double[] normalizedOutput = this.normalizeToRange(row.getDesiredOutput(), this.minOut, this.maxOut);
            row.setDesiredOutput(normalizedOutput);
        }
    }

    private double[] normalizeToRange(double[] vector, double[] min, double[] max) {
        double[] normalizedVector = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            normalizedVector[i] = (vector[i] - min[i]) / (max[i] - min[i]) * (this.highLimit - this.lowLimit) + this.lowLimit;
        }
        return normalizedVector;
    }

    private void findMaxAndMinVectors(DataSet dataSet) {
        int i;
        int inputSize = dataSet.getInputSize();
        int outputSize = dataSet.getOutputSize();
        this.maxIn = new double[inputSize];
        this.minIn = new double[inputSize];
        for (i = 0; i < inputSize; ++i) {
            this.maxIn[i] = Double.MIN_VALUE;
            this.minIn[i] = Double.MAX_VALUE;
        }
        this.maxOut = new double[outputSize];
        this.minOut = new double[outputSize];
        for (i = 0; i < outputSize; ++i) {
            this.maxOut[i] = Double.MIN_VALUE;
            this.minOut[i] = Double.MAX_VALUE;
        }
        for (DataSetRow dataSetRow : dataSet.getRows()) {
            double[] input = dataSetRow.getInput();
            for (int i2 = 0; i2 < inputSize; ++i2) {
                if (input[i2] > this.maxIn[i2]) {
                    this.maxIn[i2] = input[i2];
                }
                if (!(input[i2] < this.minIn[i2])) continue;
                this.minIn[i2] = input[i2];
            }
            double[] output = dataSetRow.getDesiredOutput();
            for (int i3 = 0; i3 < outputSize; ++i3) {
                if (output[i3] > this.maxOut[i3]) {
                    this.maxOut[i3] = output[i3];
                }
                if (!(output[i3] < this.minOut[i3])) continue;
                this.minOut[i3] = output[i3];
            }
        }
    }

    public double getLowLimit() {
        return this.lowLimit;
    }

    public double getHighLimit() {
        return this.highLimit;
    }

    public double[] getMaxIn() {
        return this.maxIn;
    }

    public double[] getMaxOut() {
        return this.maxOut;
    }

    public double[] getMinIn() {
        return this.minIn;
    }

    public double[] getMinOut() {
        return this.minOut;
    }
}

