/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;

public class NeuralNetworkCODEC {
    private NeuralNetworkCODEC() {
    }

    public static void network2array(NeuralNetwork network, double[] array) {
        int index = 0;
        List<Layer> layers = network.getLayers();
        for (Layer layer : layers) {
            for (Neuron neuron : layer.getNeurons()) {
                for (Connection connection : neuron.getOutConnections()) {
                    array[index++] = connection.getWeight().getValue();
                }
            }
        }
    }

    public static void array2network(double[] array, NeuralNetwork network) {
        int index = 0;
        List<Layer> layers = network.getLayers();
        for (Layer layer : layers) {
            for (Neuron neuron : layer.getNeurons()) {
                for (Connection connection : neuron.getOutConnections()) {
                    connection.getWeight().setValue(array[index++]);
                }
            }
        }
    }

    public static int determineArraySize(NeuralNetwork network) {
        int result = 0;
        List<Layer> layers = network.getLayers();
        for (Layer layer : layers) {
            for (Neuron neuron : layer.getNeurons()) {
                result += neuron.getOutConnections().size();
            }
        }
        return result;
    }
}

