/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import java.util.List;
import org.neuroph.core.Layer;
import org.neuroph.core.Neuron;
import org.neuroph.core.transfer.TransferFunction;
import org.neuroph.util.NeuronFactory;
import org.neuroph.util.NeuronProperties;
import org.neuroph.util.TransferFunctionType;

public final class LayerFactory {
    private LayerFactory() {
    }

    public static Layer createLayer(int neuronsCount, NeuronProperties neuronProperties) {
        Layer layer = new Layer(neuronsCount, neuronProperties);
        return layer;
    }

    public static Layer createLayer(int neuronsCount, TransferFunctionType transferFunctionType) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", (Object)transferFunctionType);
        Layer layer = new Layer(neuronsCount, neuronProperties);
        return layer;
    }

    public static Layer createLayer(int neuronsCount, Class<? extends TransferFunction> transferFunctionClass) {
        NeuronProperties neuronProperties = new NeuronProperties();
        neuronProperties.setProperty("transferFunction", transferFunctionClass);
        Layer layer = new Layer(neuronsCount, neuronProperties);
        return layer;
    }

    public static Layer createLayer(List<NeuronProperties> neuronPropertiesVector) {
        Layer layer = new Layer();
        for (NeuronProperties neuronProperties : neuronPropertiesVector) {
            Neuron neuron = NeuronFactory.createNeuron(neuronProperties);
            layer.addNeuron(neuron);
        }
        return layer;
    }
}

