/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.nnet.learning.knn;

import java.io.Serializable;
import java.util.List;
import org.neuroph.nnet.learning.kmeans.KVector;

public class KNearestNeighbour
implements Serializable {
    private List<KVector> dataSet;

    public KNearestNeighbour(List<KVector> dataSet) {
        this.dataSet = dataSet;
    }

    public KVector[] getKNearestNeighbours(KVector vector, int k) {
        KVector[] nearestNeighbours = new KVector[k];
        for (KVector otherVector : this.dataSet) {
            otherVector.setDistanceFrom(vector);
        }
        for (int i = 0; i < k; ++i) {
            int minIndex = i;
            KVector minVector = this.dataSet.get(i);
            double minDistance = minVector.getDistance();
            for (int j = i + 1; j < this.dataSet.size(); ++j) {
                if (!(this.dataSet.get(j).getDistance() <= minDistance)) continue;
                minVector = this.dataSet.get(j);
                minDistance = minVector.getDistance();
                minIndex = j;
            }
            KVector temp = this.dataSet.get(i);
            this.dataSet.set(i, this.dataSet.get(minIndex));
            this.dataSet.set(minIndex, temp);
            nearestNeighbours[i] = this.dataSet.get(i);
        }
        return nearestNeighbours;
    }

    public List<KVector> getDataSet() {
        return this.dataSet;
    }
}

