/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.magic.I_MagicGet;
import org.jaymo_lang.object.magic.I_MagicReplace;
import org.jaymo_lang.object.magic.var.A_MagicVar;
import org.jaymo_lang.object.magic.var.MV_CUR;
import org.jaymo_lang.object.magic.var.MV_EACH;
import org.jaymo_lang.object.magic.var.MV_SUPER;
import org.jaymo_lang.object.magic.var.MV_THIS;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Function;

public class Lib_MagicVar {
    public static void checkForbiddenFuncs(CallRuntime cr, String method) {
        if (method != null && Lib_Function.isVarFunction(method) > -1) {
            throw new CodeError(cr, "Invalid method for this MagicVar", "Can't execute: " + (cr.call.object != null ? String.valueOf(cr.call.object.toString()) + ' ' : "") + method);
        }
    }

    public static I_Object replace(I_Object with, CallRuntime cr, I_Object streamIt, I_Object eachIt) {
        if (with instanceof MV_THIS) {
            Lib_MagicVar.checkForbiddenFuncs(cr, cr.call.method);
            return cr.instance;
        }
        if (with instanceof MV_SUPER) {
            Lib_MagicVar.checkForbiddenFuncs(cr, cr.call.method);
            I_Object parent = cr.instance.internalGetParent();
            if (parent == null) {
                throw new CodeError(cr, "This type has no declared parent!", "Type: " + cr.instance.getTypeName());
            }
            return parent;
        }
        if (with instanceof MV_CUR) {
            if (streamIt instanceof MV_CUR) {
                Err.invalid(with, with, streamIt);
            }
            if ((with = streamIt) instanceof MV_THIS) {
                with = cr.instance;
            }
            if (with == null) {
                with = cr.instance;
            }
            Lib_MagicVar.checkForbiddenFuncs(cr, cr.call.method);
            return with;
        }
        if (with instanceof MV_EACH) {
            if (eachIt == null) {
                throw new CodeError(cr, "Invalid call!", "This type/function currently doesn't support \"each\".");
            }
            Lib_MagicVar.checkForbiddenFuncs(cr, cr.call.method);
            return eachIt;
        }
        if (with instanceof I_MagicGet) {
            I_Object with_copy = with;
            if ((with = ((I_MagicGet)((Object)with)).get(cr)) == null) {
                String type = Lib_MagicVar.magicTypeToVarConstString((I_MagicReplace)((Object)with_copy));
                throw new CodeError(cr, "Invalid use of a magic " + type + "!", with_copy.toString());
            }
            return with;
        }
        return with;
    }

    public static String magicTypeToVarConstString(I_MagicReplace m) {
        return m instanceof A_MagicVar ? "variable" : "constant";
    }
}

