/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_BigMath;
import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_ConvertExact;

public class Lib_AtomicCalc {
    public static A_Number numberCalcBigInt(CallRuntime cr, NOP1 op, BigInteger value, BigInteger arg) {
        switch (op) {
            case ADD: {
                return new JMo_BigInt(arg.add(value));
            }
            case SUB: {
                return new JMo_BigInt(value.subtract(arg));
            }
            case MUL: {
                return new JMo_BigInt(value.multiply(arg));
            }
            case DIV: {
                if (arg.signum() == 0) {
                    throw new RuntimeError(cr, "Division by zero", value + "/" + arg);
                }
                return new JMo_BigDec(new BigDecimal(value).divide(new BigDecimal(arg), JMo_BigDec.CONTEXT));
            }
            case MOD: {
                return new JMo_BigInt(value.mod(arg));
            }
            case LOG: {
                return new JMo_BigDec(Lib_BigMath.log(new BigDecimal(arg), new BigDecimal(value), JMo_BigDec.CONTEXT));
            }
            case POW: {
                return new JMo_BigInt(value.pow(arg.intValueExact()));
            }
            case ROOT: {
                return new JMo_BigDec(Lib_BigCalc.exp(Lib_BigCalc.log(new BigDecimal(value), JMo_BigDec.CONTEXT).divide(new BigDecimal(arg), JMo_BigDec.CONTEXT), JMo_BigDec.CONTEXT));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number numberCalcLong(CallRuntime cr, NOP1 op, long value, long arg) {
        switch (op) {
            case ADD: {
                return new JMo_Long(value + arg);
            }
            case SUB: {
                return new JMo_Long(value - arg);
            }
            case MUL: {
                return new JMo_Long(value * arg);
            }
            case DIV: {
                if (arg == 0L) {
                    throw new RuntimeError(cr, "Division by zero", value + "/" + arg);
                }
                return new Dec((double)value / (double)arg);
            }
            case MOD: {
                return new JMo_Long(value % arg);
            }
            case LOG: {
                return new Dec(Math.log(value) / Math.log(arg));
            }
            case POW: {
                double res = Math.pow(value, arg);
                long l = Lib_ConvertExact.doubleToLong(cr, res);
                return new JMo_Long(l);
            }
            case ROOT: {
                return new Dec(Math.exp(Math.log(value) / (double)arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number numberCalcInt(CallRuntime cr, NOP1 op, int value, int arg) {
        switch (op) {
            case ADD: {
                return new Int(value + arg);
            }
            case SUB: {
                return new Int(value - arg);
            }
            case MUL: {
                return new Int(value * arg);
            }
            case DIV: {
                if (arg == 0) {
                    throw new RuntimeError(cr, "Division by zero", value + "/" + arg);
                }
                return new Dec((double)value / (double)arg);
            }
            case MOD: {
                return new Int(value % arg);
            }
            case LOG: {
                return new Dec(Math.log(value) / Math.log(arg));
            }
            case POW: {
                double res = Math.pow(value, arg);
                int i = Lib_ConvertExact.doubleToInt(cr, res);
                return new Int(i);
            }
            case ROOT: {
                return new Dec(Math.exp(Math.log(value) / (double)arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number numberCalcBigDec(CallRuntime cr, NOP1 op, BigDecimal value, BigDecimal arg) {
        switch (op) {
            case ADD: {
                return new JMo_BigDec(arg.add(value));
            }
            case SUB: {
                return new JMo_BigDec(value.subtract(arg));
            }
            case MUL: {
                return new JMo_BigDec(value.multiply(arg));
            }
            case DIV: {
                if (arg.signum() == 0) {
                    throw new RuntimeError(cr, "Division by zero", value + "/" + arg);
                }
                return new JMo_BigDec(value.divide(arg, JMo_BigDec.CONTEXT));
            }
            case MOD: {
                return new JMo_BigDec(Lib_BigMath.modulo(value, arg));
            }
            case LOG: {
                return new JMo_BigDec(Lib_BigMath.log(arg, value, JMo_BigDec.CONTEXT));
            }
            case POW: {
                return new JMo_BigDec(Lib_BigCalc.pow(value, arg, JMo_BigDec.CONTEXT));
            }
            case ROOT: {
                return new JMo_BigDec(Lib_BigCalc.exp(Lib_BigCalc.log(value, JMo_BigDec.CONTEXT).divide(arg, JMo_BigDec.CONTEXT), JMo_BigDec.CONTEXT));
            }
        }
        throw Err.invalid(new Object[]{op});
    }

    public static A_Number numberCalcDec(CallRuntime cr, NOP1 op, double value, double arg) {
        switch (op) {
            case ADD: {
                return new Dec(value + arg);
            }
            case SUB: {
                return new Dec(value - arg);
            }
            case MUL: {
                return new Dec(value * arg);
            }
            case DIV: {
                if (arg == 0.0) {
                    throw new RuntimeError(cr, "Division by zero", value + "/" + arg);
                }
                return new Dec(value / arg);
            }
            case MOD: {
                return new Dec(value % arg);
            }
            case LOG: {
                return new Dec(Math.log(value) / Math.log(arg));
            }
            case POW: {
                return new Dec(Math.pow(value, arg));
            }
            case ROOT: {
                return new Dec(Math.exp(Math.log(value) / arg));
            }
        }
        throw Err.invalid(new Object[]{op});
    }
}

