/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_BigMath;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_BigDec;
import org.jaymo_lang.object.atom.JMo_BigInt;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Float;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Error;

public class Lib_AtomConv {
    public static I_Atomic convert(CallRuntime cr, I_Atomic obj, ATOMIC to) {
        switch (obj.getEnum()) {
            case BOOL: {
                return Lib_AtomConv.convertBool(cr, to, (Bool)obj);
            }
            case CHAR: {
                return Lib_AtomConv.convertChar(cr, to, (Char)obj);
            }
            case BYTE: {
                return Lib_AtomConv.convertByte(cr, to, (JMo_Byte)obj);
            }
            case SHORT: {
                return Lib_AtomConv.convertShort(cr, to, (JMo_Short)obj);
            }
            case INT: {
                return Lib_AtomConv.convertInt(cr, to, (Int)obj);
            }
            case LONG: {
                return Lib_AtomConv.convertLong(cr, to, (JMo_Long)obj);
            }
            case BIGINT: {
                return Lib_AtomConv.convertBigInt(cr, to, (JMo_BigInt)obj);
            }
            case FLOAT: {
                return Lib_AtomConv.convertFloat(cr, to, (JMo_Float)obj);
            }
            case DEC: {
                return Lib_AtomConv.convertDec(cr, to, (Dec)obj);
            }
            case BIGDEC: {
                return Lib_AtomConv.convertBigDec(cr, to, (JMo_BigDec)obj);
            }
            case STR: {
                return Lib_AtomConv.convertStr(cr, to, (Str)obj);
            }
        }
        throw Lib_AtomConv.iImpossibleConversion(cr, obj.getTypeName(), to, obj);
    }

    public static I_Object getDefaultValue(String type) {
        if (type == null || type.endsWith("?")) {
            return Nil.NIL;
        }
        switch (type) {
            case "Bool": {
                return Bool.FALSE;
            }
            case "Byte": {
                return new JMo_Byte(0);
            }
            case "Short": {
                return new JMo_Short(0);
            }
            case "Int": {
                return new Int(0);
            }
            case "Long": {
                return new JMo_Long(0L);
            }
            case "BigInt": {
                return new JMo_BigInt(BigInteger.valueOf(0L));
            }
            case "Float": {
                return new JMo_Float(0.0f);
            }
            case "Dec": {
                return new Dec(0.0);
            }
            case "BigDec": {
                return new Int(0);
            }
            case "Char": {
                return new Char(' ');
            }
            case "Str": {
                return new Str("");
            }
        }
        return Nil.NIL;
    }

    public static I_Object autoUpgrade(CallRuntime cr, I_Object obj, String objType, String safedType) {
        switch (safedType) {
            case "Short": {
                switch (objType) {
                    case "Byte": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.SHORT);
                    }
                }
                return null;
            }
            case "Int": {
                switch (objType) {
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.INT);
                    }
                }
                return null;
            }
            case "Long": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.LONG);
                    }
                }
                return null;
            }
            case "BigInt": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Long": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.BIGINT);
                    }
                }
                return null;
            }
            case "Float": {
                switch (objType) {
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.FLOAT);
                    }
                }
                return null;
            }
            case "Dec": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Float": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.DEC);
                    }
                }
                return null;
            }
            case "BigDec": {
                switch (objType) {
                    case "Dec": 
                    case "Int": 
                    case "Byte": 
                    case "Long": 
                    case "Float": 
                    case "Short": 
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.BIGDEC);
                    }
                }
                return null;
            }
            case "DecNumber": {
                switch (objType) {
                    case "Int": 
                    case "Byte": 
                    case "Short": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.DEC);
                    }
                    case "Long": 
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.BIGDEC);
                    }
                }
                return null;
            }
            case "Str": {
                switch (objType) {
                    case "Dec": 
                    case "Int": 
                    case "Byte": 
                    case "Char": 
                    case "Long": 
                    case "Float": 
                    case "Short": 
                    case "BigDec": 
                    case "BigInt": {
                        return Lib_AtomConv.convert(cr, (I_Atomic)obj, ATOMIC.STR);
                    }
                }
                return null;
            }
        }
        return null;
    }

    private static I_Atomic convertBool(CallRuntime cr, ATOMIC to, Bool so) {
        boolean v = so.getValue();
        switch (to) {
            case BOOL: {
                return so;
            }
            case CHAR: {
                return new Char(v ? (char)'1' : '0');
            }
            case BYTE: {
                return new JMo_Byte(v ? (byte)1 : 0);
            }
            case SHORT: {
                return new JMo_Short(v ? (short)1 : 0);
            }
            case INT: {
                return new Int(v ? 1 : 0);
            }
            case LONG: {
                return new JMo_Long(v ? 1 : 0);
            }
            case BIGINT: {
                return new JMo_BigInt(BigInteger.valueOf(v ? 1 : 0));
            }
            case FLOAT: {
                return new JMo_Float(v ? 1 : 0);
            }
            case DEC: {
                return new Dec(v ? 1 : 0);
            }
            case BIGDEC: {
                return new JMo_BigDec(BigDecimal.valueOf(v ? 1 : 0));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertByte(CallRuntime cr, ATOMIC to, JMo_Byte so) {
        byte v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "Byte", so, v);
            }
            case BYTE: {
                return so;
            }
            case SHORT: {
                return new JMo_Short(v);
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case BIGINT: {
                return new JMo_BigInt(BigInteger.valueOf(v));
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case BIGDEC: {
                return new JMo_BigDec(BigDecimal.valueOf(v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertChar(CallRuntime cr, ATOMIC to, Char so) {
        char v = so.getValue().charValue();
        try {
            switch (to) {
                case BOOL: {
                    return Bool.getObject(v != '0' && v != '\u0000');
                }
                case CHAR: {
                    return so;
                }
                case BYTE: {
                    return new JMo_Byte(Byte.parseByte("" + v));
                }
                case SHORT: {
                    return new JMo_Short(Short.parseShort("" + v));
                }
                case INT: {
                    return new Int(Integer.parseInt("" + v));
                }
                case LONG: {
                    return new JMo_Long(Long.parseLong("" + v));
                }
                case BIGINT: {
                    return new JMo_BigInt(new BigInteger("" + v));
                }
                case FLOAT: {
                    return new JMo_Float(Float.parseFloat("" + v));
                }
                case DEC: {
                    return new Dec(Double.parseDouble("" + v));
                }
                case BIGDEC: {
                    return new JMo_BigDec(new BigDecimal("" + v));
                }
                case STR: {
                    return new Str("" + v);
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (NumberFormatException e) {
            throw Lib_AtomConv.iImpossibleConversion(cr, "Char", to, so);
        }
    }

    private static I_Atomic convertDec(CallRuntime cr, ATOMIC to, Dec so) {
        double v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0);
            }
            case CHAR: {
                return Lib_AtomConv.iDecToChar(cr, so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Dec");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Dec");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Dec");
                return new Int((int)v);
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, -9.223372036854776E18, 9.223372036854776E18, v, "Dec");
                return new JMo_Long((long)v);
            }
            case BIGINT: {
                BigInteger bi = Lib_BigMath.convertToBigInteger(v);
                return new JMo_BigInt(bi);
            }
            case FLOAT: {
                return new JMo_Float((float)v);
            }
            case DEC: {
                return so;
            }
            case BIGDEC: {
                return new JMo_BigDec(new BigDecimal("" + v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertFloat(CallRuntime cr, ATOMIC to, JMo_Float so) {
        float v = so.getValue().floatValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0.0f);
            }
            case CHAR: {
                return Lib_AtomConv.iDecToChar(cr, so, Float.valueOf(v));
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Float");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Float");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Float");
                return new Int((int)v);
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, -9.223372036854776E18, 9.223372036854776E18, v, "Float");
                return new JMo_Long((long)v);
            }
            case BIGINT: {
                BigInteger bi = Lib_BigMath.convertToBigInteger(v);
                return new JMo_BigInt(bi);
            }
            case FLOAT: {
                return so;
            }
            case DEC: {
                return new Dec(v);
            }
            case BIGDEC: {
                return new JMo_BigDec(new BigDecimal("" + v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertInt(CallRuntime cr, ATOMIC to, Int so) {
        int v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "Int", so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128, 255, v, "Int");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, Short.MIN_VALUE, 65535, v, "Int");
                return new JMo_Short((short)v);
            }
            case INT: {
                return so;
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case BIGINT: {
                return new JMo_BigInt(BigInteger.valueOf(v));
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case BIGDEC: {
                return new JMo_BigDec(BigDecimal.valueOf(v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertLong(CallRuntime cr, ATOMIC to, JMo_Long so) {
        long v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0L);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "Long", so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "Long");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "Long");
                return new JMo_Short((short)v);
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "Long");
                return new Int((int)v);
            }
            case LONG: {
                return so;
            }
            case BIGINT: {
                return new JMo_BigInt(BigInteger.valueOf(v));
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case BIGDEC: {
                return new JMo_BigDec(BigDecimal.valueOf(v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertBigInt(CallRuntime cr, ATOMIC to, JMo_BigInt so) {
        BigInteger v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v.compareTo(BigInteger.valueOf(0L)) == 1);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "BigInt", so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128L, 255L, v, "BigInt");
                return new JMo_Byte((byte)v.intValue());
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768L, 65535L, v, "BigInt");
                return new JMo_Short((short)v.intValue());
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, Integer.MIN_VALUE, 0xFFFFFFFFL, v, "BigInt");
                return new Int((int)v.longValue());
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, Long.MIN_VALUE, Long.MAX_VALUE, v, "BigInt");
                return new JMo_Long(v.longValue());
            }
            case BIGINT: {
                return so;
            }
            case FLOAT: {
                return new JMo_Float(v.floatValue());
            }
            case DEC: {
                return new Dec(v.doubleValue());
            }
            case BIGDEC: {
                return new JMo_BigDec(new BigDecimal(v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertBigDec(CallRuntime cr, ATOMIC to, JMo_BigDec so) {
        BigDecimal v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v.compareTo(BigDecimal.valueOf(0L)) == 1);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "BigDec", so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128.0, 255.0, v, "BigDec");
                return new JMo_Byte((byte)v.intValue());
            }
            case SHORT: {
                Lib_Error.ifNotBetween(cr, -32768.0, 65535.0, v, "BigDec");
                return new JMo_Short((short)v.intValue());
            }
            case INT: {
                Lib_Error.ifNotBetween(cr, -2.147483648E9, 4.294967295E9, v, "BigDec");
                return new Int((int)v.longValue());
            }
            case LONG: {
                Lib_Error.ifNotBetween(cr, -9.223372036854776E18, 9.223372036854776E18, v, "BigDec");
                return new JMo_Long(v.longValue());
            }
            case BIGINT: {
                return new JMo_BigInt(v.toBigInteger());
            }
            case FLOAT: {
                return new JMo_Float(v.floatValue());
            }
            case DEC: {
                return new Dec(v.doubleValue());
            }
            case BIGDEC: {
                return so;
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertShort(CallRuntime cr, ATOMIC to, JMo_Short so) {
        short v = so.getValue();
        switch (to) {
            case BOOL: {
                return Bool.getObject(v > 0);
            }
            case CHAR: {
                return Lib_AtomConv.iToChar(cr, "Short", so, v);
            }
            case BYTE: {
                Lib_Error.ifNotBetween(cr, -128, 255, v, "Short");
                return new JMo_Byte((byte)v);
            }
            case SHORT: {
                return so;
            }
            case INT: {
                return new Int(v);
            }
            case LONG: {
                return new JMo_Long(v);
            }
            case BIGINT: {
                return new JMo_BigInt(BigInteger.valueOf(v));
            }
            case FLOAT: {
                return new JMo_Float(v);
            }
            case DEC: {
                return new Dec(v);
            }
            case BIGDEC: {
                return new JMo_BigDec(BigDecimal.valueOf(v));
            }
            case STR: {
                return new Str("" + v);
            }
        }
        throw Err.impossible(new Object[0]);
    }

    private static I_Atomic convertStr(CallRuntime cr, ATOMIC to, Str so) {
        String v = so.getValue();
        try {
            switch (to) {
                case BOOL: {
                    String lv = v.toLowerCase();
                    if (lv.length() == 0 || lv.equals("false") || lv.equals("0")) {
                        return Bool.FALSE;
                    }
                    return Bool.TRUE;
                }
                case CHAR: {
                    return Lib_AtomConv.iToChar(cr, "Str", so, v);
                }
                case BYTE: {
                    return new JMo_Byte(Byte.parseByte(v));
                }
                case SHORT: {
                    return new JMo_Short(Short.parseShort(v));
                }
                case INT: {
                    return new Int(Integer.parseInt(v));
                }
                case LONG: {
                    return new JMo_Long(Long.parseLong(v));
                }
                case BIGINT: {
                    return new JMo_BigInt(new BigInteger(v));
                }
                case FLOAT: {
                    String s2 = v.replace(',', '.');
                    return new Dec(Float.parseFloat(s2));
                }
                case DEC: {
                    String s3 = v.replace(',', '.');
                    return new Dec(Double.parseDouble(s3));
                }
                case BIGDEC: {
                    String s4 = v.replace(',', '.');
                    return new JMo_BigDec(new BigDecimal(s4));
                }
                case STR: {
                    return so;
                }
            }
        }
        catch (NumberFormatException e) {
            throw Lib_AtomConv.iImpossibleConversion(cr, "Str", to, so);
        }
        throw Err.impossible(new Object[0]);
    }

    private static Char iToChar(CallRuntime cr, String from, I_Atomic atomic, Object v) {
        String vs = v.toString();
        if (vs.length() != 1) {
            throw Lib_AtomConv.iImpossibleConversion(cr, from, ATOMIC.CHAR, atomic);
        }
        return new Char(vs.charAt(0));
    }

    private static Char iDecToChar(CallRuntime cr, I_Atomic atomic, Object v) {
        String vs = v.toString();
        if (vs.endsWith(".0")) {
            vs = vs.substring(0, vs.length() - 2);
        }
        if (vs.length() != 1) {
            throw Lib_AtomConv.iImpossibleConversion(cr, ATOMIC.DEC.name, ATOMIC.CHAR, atomic);
        }
        return new Char(vs.charAt(0));
    }

    private static RuntimeError iImpossibleConversion(CallRuntime cr, String from, ATOMIC to, I_Atomic value) {
        return new RuntimeError(cr, "Impossible conversion", "(" + from + " --> " + to.name + ") " + value.toString(cr, STYPE.IDENT));
    }
}

