/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.group.Group2;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.VarArgsCallBuffer;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.immute.JMo_KeyValue;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Parser;

public class JMo_TreeNode
extends A_Sequence {
    protected final ArrayList<JMo_TreeNode> nodes = new ArrayList();
    private I_Atomic name = null;
    private I_Object value = null;
    private final VarArgsCallBuffer callBuffer;

    public JMo_TreeNode(I_Atomic name) {
        this.name = name;
        this.callBuffer = null;
    }

    public JMo_TreeNode(I_Atomic name, I_Object value) {
        this.name = name;
        this.value = value;
        this.callBuffer = null;
    }

    public JMo_TreeNode(Call ... varArgs) {
        this.callBuffer = new VarArgsCallBuffer(varArgs);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.callBuffer != null) {
            I_Object[] args = this.callBuffer.init(cr, this);
            Lib_Error.ifArgs(args.length, 2, null, cr, this);
            this.name = (I_Atomic)cr.argType(args[0], I_Atomic.class);
            this.value = cr.argType(args[1], null);
            int i = 2;
            while (i < args.length) {
                JMo_TreeNode node = (JMo_TreeNode)cr.argType(args[i], JMo_TreeNode.class);
                this.nodes.add(node);
                ++i;
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    public String toString() {
        return this.name == null ? "Tree<" + this.nodes.size() + '>' : "TreeNode[" + this.name.toString(null, STYPE.IDENT) + ']';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: 
            case IDENT: {
                return this.toString();
            }
            case REGULAR: {
                StringBuilder sb = new StringBuilder();
                this.iToString(cr, sb, 0);
                Lib_Output.removeEnd(sb, '\n');
                return sb.toString();
            }
            case DESCRIBE: {
                StringBuilder sb2 = new StringBuilder();
                this.iToStringDescribe(sb2, cr, 0);
                Lib_Output.removeEnd(sb2, '\n');
                return sb2.toString();
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    private void iToString(CallRuntime cr, StringBuilder sb, int indent) {
        boolean hasValue;
        boolean isRoot = this.name == null;
        boolean bl = hasValue = this.value != null && this.value != Nil.NIL;
        if (!isRoot) {
            String space = Lib_Parser.space(indent);
            String line = this.name.toString(cr, STYPE.NESTED);
            sb.append(String.valueOf(space) + line);
            if (hasValue) {
                sb.append(": " + this.value.toString(cr, STYPE.NESTED));
            }
            sb.append('\n');
            ++indent;
        }
        for (JMo_TreeNode node : this.nodes) {
            node.iToString(cr, sb, indent);
        }
    }

    private void iToStringDescribe(StringBuilder sb, CallRuntime cr, int indent) {
        boolean isRoot;
        String space = Lib_Parser.space(indent);
        boolean bl = isRoot = this.name == null;
        if (!isRoot) {
            sb.append(space);
            String sn = this.name.toString(cr, STYPE.DESCRIBE);
            sb.append(sn);
            if (this.value != null && this.value != Nil.NIL) {
                sb.append(": ");
                String sv = this.value instanceof JMo_TreeNode ? this.value.getTypeName() : this.value.toString(cr, STYPE.DESCRIBE);
                sv = Lib_Output.indentLines(sv, false);
                sb.append(sv);
            }
            sb.append('\n');
            ++indent;
        }
        for (JMo_TreeNode node : this.nodes) {
            node.iToStringDescribe(sb, cr, indent);
        }
    }

    public Group2<I_Atomic, I_Object> internalNameValue() {
        return new Group2<I_Atomic, I_Object>(this.name, this.value);
    }

    public List<JMo_TreeNode> internalNodes() {
        return this.nodes;
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getName": {
                return A_Object.stdResult(this.mGetName(cr));
            }
            case "setName": {
                return A_Object.stdResult(this.mSetName(cr));
            }
            case "getValue": {
                return A_Object.stdResult(this.mGetValue(cr));
            }
            case "setValue": {
                return A_Object.stdResult(this.mSetValue(cr));
            }
            case "addNode": 
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "addNodes": {
                return A_Object.stdResult(this.mAddNodes(cr));
            }
            case "delete": {
                return A_Object.stdResult(this.mRemoveNodes(cr));
            }
            case "remove": 
            case "removeNames": 
            case "--": {
                return A_Object.stdResult(this.mRemoveNames(cr));
            }
            case "removeValues": {
                return A_Object.stdResult(this.mRemoveValues(cr));
            }
        }
        return null;
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(0);
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        return this.nodes.size() == 0 ? Nil.NIL : (I_Object)this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    protected int sequenceSize() {
        return this.nodes.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 1, 1);
        if (args.length > 1) {
            return this.sequenceDeepGet(cr, args, 0, lazy);
        }
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(args[0])) continue;
            return node;
        }
        if (lazy) {
            A_Atomic apar = (A_Atomic)cr.argType(args[0], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            return node;
        }
        throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + args[0].toString());
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] args = cr.argsVar(this, 2, 1);
        if (args.length > 2) {
            this.sequenceDeepSet(cr, args, 1, args[0], lazy);
            return;
        }
        this.sequenceSet(cr, args[1], args[0], lazy);
    }

    @Override
    protected A_Sequence copy(CallRuntime cr) {
        JMo_TreeNode copy = new JMo_TreeNode(this.name, this.value);
        copy.nodes.addAll(this.nodes);
        return copy;
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        JMo_TreeNode hit = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(key)) continue;
            hit = node;
            break;
        }
        if (!lazy && hit == null) {
            throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + key.toString());
        }
        return hit == null && lazy ? Nil.NIL : hit.value;
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        JMo_TreeNode result = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            result = node;
            break;
        }
        if (lazy && result == null) {
            A_Atomic apar = (A_Atomic)cr.argType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            result = node;
        }
        if (result == null) {
            throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + keys[0].toString());
        }
        if (keys.length - offset == 1) {
            return result;
        }
        return result.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        if (keys.length - offset == 0) {
            this.value = value;
            return;
        }
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(keys[offset])) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.argType(keys[offset], A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + keys[offset].toString());
        }
        found.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
    }

    private JMo_TreeNode mSetName(CallRuntime cr) {
        if (this.name == null) {
            throw new RuntimeError(cr, "Invalid name for root element", "Can't set value for root of the tree");
        }
        this.name = (A_Atomic)cr.args(this, A_Atomic.class)[0];
        return this;
    }

    private I_Object mGetName(CallRuntime cr) {
        cr.argsNone();
        return this.name == null ? Nil.NIL : this.name;
    }

    private JMo_TreeNode mSetValue(CallRuntime cr) {
        if (this.name == null) {
            throw new RuntimeError(cr, "Invalid value for root element", "Can't set value for root of the tree");
        }
        this.value = cr.args(this, I_Object.class)[0];
        return this;
    }

    private I_Object mGetValue(CallRuntime cr) {
        cr.argsNone();
        return this.value == null ? Nil.NIL : this.value;
    }

    private JMo_TreeNode mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        I_Object arg0 = args[0];
        int len = args.length;
        if (len == 1 && arg0 instanceof JMo_TreeNode) {
            this.nodes.add((JMo_TreeNode)arg0);
            return (JMo_TreeNode)arg0;
        }
        if (len == 1 && arg0 instanceof JMo_KeyValue) {
            JMo_KeyValue kv = (JMo_KeyValue)arg0;
            if (!(kv.getKey() instanceof A_Atomic)) {
                throw new RuntimeError(cr, "Invalid key for Tree", "Key must be Atomic, but got: " + kv.getKey().toString(cr, STYPE.IDENT));
            }
            JMo_TreeNode result = new JMo_TreeNode((A_Atomic)kv.getKey(), kv.getValue());
            this.nodes.add(result);
            return result;
        }
        A_Atomic aPar = (A_Atomic)cr.argType(arg0, A_Atomic.class);
        JMo_TreeNode result = len == 1 ? new JMo_TreeNode(aPar) : new JMo_TreeNode(aPar, args[1]);
        this.nodes.add(result);
        return result;
    }

    private JMo_TreeNode mAddNodes(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 0, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            if (arg instanceof JMo_TreeNode) {
                this.nodes.add((JMo_TreeNode)arg);
            } else {
                A_Atomic aPar = (A_Atomic)cr.argType(arg, A_Atomic.class);
                this.nodes.add(new JMo_TreeNode(aPar));
            }
            ++n2;
        }
        return this;
    }

    private I_Object mRemoveNodes(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            cr.argType(arg, A_Atomic.class);
            boolean removed = false;
            int i = 0;
            while (i < this.nodes.size()) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.name.equals(arg)) {
                    this.nodes.remove(i);
                    removed = true;
                    break;
                }
                ++i;
            }
            if (!removed) {
                throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + arg.toString());
            }
            ++n2;
        }
        return this;
    }

    private JMo_TreeNode mRemoveNames(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            arg = cr.argType(arg, I_Atomic.class);
            int i = this.nodes.size() - 1;
            while (i >= 0) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.name != null && node.name.equals(arg)) {
                    this.nodes.remove(i);
                } else {
                    node.deepNameRemove(arg);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private void deepNameRemove(I_Object toRemove) {
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.name.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepNameRemove(toRemove);
            }
            --i;
        }
    }

    private JMo_TreeNode mRemoveValues(CallRuntime cr) {
        I_Object[] args;
        I_Object[] i_ObjectArray = args = cr.argsVar(this, 1, 0);
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            int i = this.nodes.size() - 1;
            while (i >= 0) {
                JMo_TreeNode node = this.nodes.get(i);
                if (node.value != null && node.value.equals(arg)) {
                    this.nodes.remove(i);
                } else {
                    node.deepValueRemove(arg);
                }
                --i;
            }
            ++n2;
        }
        return this;
    }

    private void deepValueRemove(I_Object toRemove) {
        int i = this.nodes.size() - 1;
        while (i >= 0) {
            JMo_TreeNode node = this.nodes.get(i);
            if (node.value != null && node.value.equals(toRemove)) {
                this.nodes.remove(i);
            } else {
                node.deepValueRemove(toRemove);
            }
            --i;
        }
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object pos, I_Object obj, boolean lazy) {
        JMo_TreeNode found = null;
        for (JMo_TreeNode node : this.nodes) {
            if (!node.name.equals(pos)) continue;
            found = node;
        }
        if (lazy && found == null) {
            A_Atomic apar = (A_Atomic)cr.argType(pos, A_Atomic.class);
            JMo_TreeNode node = new JMo_TreeNode(apar);
            this.nodes.add(node);
            found = node;
        }
        if (found == null) {
            throw new RuntimeError(cr, "Node not found", "Can't find node with name: " + pos.toString());
        }
        found.value = obj;
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        return this.nodes;
    }
}

