/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.data.form.FormString;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.VarArgsCallBuffer;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.JMo_KeyValue;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Map
extends A_Sequence
implements I_AutoBlockDo {
    private final ArrayList<I_Object> keys;
    private final ArrayList<I_Object> values;
    private final VarArgsCallBuffer init;
    private boolean fixedLength = false;
    private boolean fixedValueTypes = false;

    public JMo_Map() {
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.init = null;
    }

    public JMo_Map(ArrayList<I_Object> keys, ArrayList<I_Object> objects) {
        this.keys = keys;
        this.values = objects;
        this.init = null;
    }

    public JMo_Map(Call ... items) {
        this.keys = new ArrayList();
        this.values = new ArrayList();
        this.init = new VarArgsCallBuffer(items);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init != null) {
            I_Object[] ios = this.init.init(cr, this);
            int i = 0;
            while (i < ios.length) {
                JMo_KeyValue kv = (JMo_KeyValue)cr.instanceArgType(i, ios[i], JMo_KeyValue.class);
                this.keys.add(kv.getKey());
                this.values.add(kv.getValue());
                ++i;
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "addAll": {
                return A_Object.stdResult(this.mAddAll(cr));
            }
            case "remove": 
            case "sub": {
                return A_Object.stdResult(this.mRemove(cr));
            }
            case "clear": {
                return A_Object.stdResult(this.mClear(cr));
            }
            case "count": {
                return A_Object.stdResult(this.mIncDec(cr, true, true));
            }
            case "inc": {
                return A_Object.stdResult(this.mIncDec(cr, false, true));
            }
            case "dec": {
                return A_Object.stdResult(this.mIncDec(cr, false, false));
            }
            case "each": {
                return this.mEach(cr);
            }
            case "keys": {
                return A_Object.stdResult(this.mKeys(cr));
            }
            case "values": {
                return A_Object.stdResult(this.mValues(cr));
            }
            case "hasKey": 
            case "containsKey": {
                return A_Object.stdResult(this.mContainsKey(cr));
            }
            case "containsValue": 
            case "hasValue": {
                return A_Object.stdResult(this.mContainsValue(cr));
            }
            case "toList": {
                return A_Object.stdResult(this.mToList(cr));
            }
            case "toTable": {
                return A_Object.stdResult(this.mToTable(cr));
            }
            case "fixLength": {
                cr.argsNone();
                this.fixedLength = true;
                return A_Object.stdResult(this);
            }
            case "fixTypes": {
                cr.argsNone();
                this.fixedValueTypes = true;
                return A_Object.stdResult(this);
            }
            case "fix": {
                this.fixedLength = true;
                this.fixedValueTypes = true;
                return A_Object.stdResult(this);
            }
        }
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mEach((CallRuntime)cr).obj;
    }

    public I_Table<I_Object> copyToTable() {
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int i = 0;
        while (i < this.keys.size()) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return tab;
    }

    public HashMap<I_Object, I_Object> copyToHashMap() {
        HashMap<I_Object, I_Object> result = new HashMap<I_Object, I_Object>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(this.keys.get(i), this.values.get(i));
            ++i;
        }
        return result;
    }

    public HashMap<String, I_Object> copyToStringMap(CallRuntime cr) {
        HashMap<String, I_Object> result = new HashMap<String, I_Object>();
        int i = 0;
        while (i < this.keys.size()) {
            result.put(Lib_Convert.getStringValue(cr, this.keys.get(i)), this.values.get(i));
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_Map) {
            ArrayList<I_Object> otherKeys = ((JMo_Map)obj).keys;
            if (this.keys.size() != otherKeys.size()) {
                return false;
            }
            int i = 0;
            while (i < this.keys.size()) {
                if (!this.keys.get(i).equals(otherKeys.get(i))) {
                    return false;
                }
                ++i;
            }
            ArrayList<I_Object> otherValues = ((JMo_Map)obj).values;
            if (this.values.size() != otherValues.size()) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.values.size()) {
                if (!this.values.get(i2).equals(otherValues.get(i2))) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    private ObjectCallResult mEach(CallRuntime crOld) {
        JMo_KeyValue item;
        boolean varlet;
        I_Object[] args = crOld.argsFlex(this, 0, 1);
        boolean bl = varlet = args.length == 1;
        if (varlet) {
            crOld.argType(args[0], VarLet.class);
        }
        Call stream = crOld.getStream();
        Block block = crOld.getCallBlock();
        if (stream == null && block == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object res = this;
        int pos = 0;
        while (pos < this.keys.size()) {
            block13: {
                handle.startLap();
                item = new JMo_KeyValue(this.keys.get(pos), this.values.get(pos));
                if (varlet) {
                    Var o = ((VarLet)args[0]).getVar();
                    o.let(crNew, crNew, item);
                }
                if (block != null) {
                    try {
                        res = block.exec(crNew, item);
                    }
                    catch (ReturnException e) {
                        Return temp = e.get();
                        switch (temp.getLevel()) {
                            case NEXT: {
                                break block13;
                            }
                            default: {
                                return temp.getLoopResult();
                            }
                        }
                    }
                }
                if (stream != null && block == null) {
                    res = crNew.execInit(stream, item);
                }
            }
            ++pos;
        }
        if (stream != null && block != null) {
            if (this.keys.size() == 0) {
                Err.todo("Map is empty!");
            }
            int last = this.keys.size() - 1;
            item = new JMo_KeyValue(this.keys.get(last), this.values.get(last));
            res = crNew.execInit(stream, item);
        }
        return new ObjectCallResult(res, true);
    }

    @Override
    protected int sequenceSize() {
        return this.keys.size();
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTypeName()) + '<' + this.keys.size() + '>';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: 
            case IDENT: {
                return this.toString();
            }
            case REGULAR: {
                StringBuilder sb = new StringBuilder();
                int maxKeyLen = 0;
                for (I_Object key : this.keys) {
                    maxKeyLen = Math.max(maxKeyLen, key.toString().length());
                }
                int i = 0;
                while (i < this.keys.size()) {
                    String key = this.keys.get(i).toString();
                    sb.append(FormString.length(maxKeyLen, key, false));
                    sb.append(" -> ");
                    I_Object val = this.values.get(i);
                    sb.append(val == this ? "self" : val.toString(cr, STYPE.NESTED));
                    sb.append('\n');
                    ++i;
                }
                Lib_Output.removeEnd(sb, '\n');
                return sb.toString();
            }
        }
        StringBuilder sb2 = new StringBuilder();
        int i = 0;
        while (i < this.keys.size()) {
            String sk = this.keys.get(i).toString(cr, STYPE.DESCRIBE);
            sk = Lib_Output.indentLines(sk, false);
            sb2.append(sk);
            sb2.append(" -> ");
            I_Object ov = this.values.get(i);
            String sv = ov == this ? "self" : ov.toString(cr, STYPE.DESCRIBE);
            sv = Lib_Output.indentLines(sv, true);
            sb2.append(sv);
            sb2.append('\n');
            ++i;
        }
        Lib_Output.removeEnd(sb2, '\n');
        return sb2.toString();
    }

    private JMo_Map mAdd(CallRuntime cr) {
        I_Object[] args = cr.argsFlex(this, 1, 2);
        this.iFixedLength(cr);
        if (args.length == 1) {
            JMo_KeyValue kv = (JMo_KeyValue)cr.argType(args[0], JMo_KeyValue.class);
            this.iAdd(cr, kv.getKey(), kv.getValue());
        } else {
            this.iAdd(cr, args[0], args[1]);
        }
        return this;
    }

    private JMo_Map mAddAll(CallRuntime cr) {
        I_Object[] args = cr.argsVar(this, 0, 0);
        this.iFixedLength(cr);
        I_Object[] i_ObjectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            I_Object arg = i_ObjectArray[n2];
            JMo_KeyValue kv = (JMo_KeyValue)cr.argType(arg, JMo_KeyValue.class);
            this.iAdd(cr, kv.getKey(), kv.getValue());
            ++n2;
        }
        return this;
    }

    @Override
    protected JMo_Map copy(CallRuntime cr) {
        cr.argsNone();
        ArrayList clonek = (ArrayList)this.keys.clone();
        ArrayList cloneo = (ArrayList)this.values.clone();
        return new JMo_Map(clonek, cloneo);
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_Object key = oa[0];
            int i = this.iGetIndex(cr, key, !lazy);
            return lazy && i == -1 ? Nil.NIL : this.values.get(i);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    private JMo_List mKeys(CallRuntime cr) {
        cr.argsNone();
        ArrayList clone = (ArrayList)this.keys.clone();
        return new JMo_List(clone);
    }

    private JMo_List mValues(CallRuntime cr) {
        cr.argsNone();
        ArrayList clone = (ArrayList)this.values.clone();
        return new JMo_List(clone);
    }

    private Bool mContainsKey(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        int knows = this.iGetIndex(cr, search, false);
        return knows == -1 ? Bool.FALSE : Bool.TRUE;
    }

    private Bool mContainsValue(CallRuntime cr) {
        I_Object search = cr.args(this, I_Object.class)[0];
        for (I_Object o : this.values) {
            if (!o.equals(search)) continue;
            return Bool.TRUE;
        }
        return Bool.FALSE;
    }

    private JMo_Map mRemove(CallRuntime cr) {
        I_Object key = cr.args(this, I_Object.class)[0];
        this.iFixedLength(cr);
        int i = this.iGetIndex(cr, key, true);
        this.keys.remove(i);
        this.values.remove(i);
        return this;
    }

    private JMo_Map mClear(CallRuntime cr) {
        cr.argsNone();
        this.iFixedLength(cr);
        this.keys.clear();
        this.values.clear();
        return this;
    }

    private JMo_Map mIncDec(CallRuntime cr, boolean lazy, boolean inc) {
        block24: {
            int add;
            int idx;
            I_Object key;
            block23: {
                key = cr.args(this, I_Object.class)[0];
                idx = this.iGetIndex(cr, key, !lazy);
                int n = add = inc ? 1 : -1;
                if (!lazy || idx >= 0) break block23;
                this.iAdd(cr, key, new Int(1));
                break block24;
            }
            I_Object value = this.values.get(idx);
            switch (value.getTypeName()) {
                case "Byte": 
                case "Short": {
                    if (this.fixedValueTypes) {
                        throw new RuntimeError(cr, "Fixed values", "Value can't be converted to Int for key: " + key);
                    }
                }
                case "Int": {
                    value = new Int(Lib_Convert.getIntValue(cr, value) + add);
                    break;
                }
                case "Long": {
                    value = new JMo_Long(Lib_Convert.getLongValue(cr, value) + (long)add);
                    break;
                }
                case "Float": {
                    if (this.fixedValueTypes) {
                        throw new RuntimeError(cr, "Fixed values", "Value can't be converted to Dec for key: " + key);
                    }
                }
                case "Dec": {
                    value = new Dec(Lib_Convert.getDoubleValue(cr, value) + (double)add);
                    break;
                }
                default: {
                    throw new RuntimeError(cr, "Invalid value type", "For inc/dec the type of value must be a normal atomic number, but got: " + value.getTypeName());
                }
            }
            this.values.set(idx, value);
        }
        return this;
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 2, 1);
        if (oa.length > 2) {
            this.sequenceDeepSet(cr, oa, 1, oa[0], lazy);
            return;
        }
        this.sequenceSet(cr, oa[1], oa[0], lazy);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object key, I_Object value, boolean lazy) {
        int pos = this.iGetIndex(cr, key, !lazy);
        if (lazy && pos < 0) {
            this.iAdd(cr, key, value);
        } else {
            I_Object curo;
            if (this.fixedValueTypes && (curo = this.values.get(pos)) != Nil.NIL) {
                value = Lib_Type.typeCheck(cr, value, Lib_Type.getName(value), Lib_Type.getName(curo), "value");
            }
            this.values.set(pos, value);
        }
    }

    public void internalAdd(I_Object key, I_Object value) {
        if (this.fixedLength) {
            Err.forbidden(key, value);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    private void iAdd(CallRuntime cr, I_Object key, I_Object value) {
        this.iFixedLength(cr);
        int i = this.iGetIndex(cr, key, false);
        if (i != -1) {
            throw new RuntimeError(cr, "Duplicated Key", "Got: " + key);
        }
        this.keys.add(key);
        this.values.add(value);
    }

    private int iGetIndex(CallRuntime cr, I_Object key, boolean error) {
        String keyString = Lib_Convert.getStringValue(cr, key);
        int i = 0;
        while (i < this.keys.size()) {
            I_Object k = this.keys.get(i);
            if (k instanceof A_Immutable ? k.equals(key) || key instanceof Str && keyString.equals(Lib_Convert.getStringValue(cr, k)) : k.hashCode() == key.hashCode()) {
                return i;
            }
            ++i;
        }
        if (error) {
            throw new RuntimeError(cr, "Unknown key", "Got: " + key);
        }
        return -1;
    }

    private I_Object mToTable(CallRuntime cr) {
        cr.argsNone();
        MTable<I_Object> tab = new MTable<I_Object>(2);
        int len = this.keys.size();
        int i = 0;
        while (i < len) {
            tab.add((I_Object[])new I_Object[]{this.keys.get(i), this.values.get(i)});
            ++i;
        }
        return new JMo_Table(tab);
    }

    private I_Object mToList(CallRuntime cr) {
        cr.argsNone();
        int len = this.keys.size();
        ArrayList<I_Object> list = new ArrayList<I_Object>(len);
        int i = 0;
        while (i < len) {
            list.add(new JMo_KeyValue(this.keys.get(i), this.values.get(i)));
            ++i;
        }
        return new JMo_List(list);
    }

    @Override
    protected JMo_KeyValue getFirst(CallRuntime cr) {
        return new JMo_KeyValue(this.keys.get(0), this.values.get(0));
    }

    @Override
    protected JMo_KeyValue getLast(CallRuntime cr) {
        int idx = this.keys.size() - 1;
        return new JMo_KeyValue(this.keys.get(idx), this.values.get(idx));
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        I_Object key = cr.argType(keys[offset], I_Object.class);
        if (!this.keys.contains(key)) {
            if (lazy) {
                return Nil.NIL;
            }
            throw new RuntimeError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
        }
        if (offset == keys.length - 1) {
            int pos = this.iGetIndex(cr, key, true);
            return this.values.get(pos);
        }
        int pos = this.iGetIndex(cr, key, true);
        I_Object deeper = this.values.get(pos);
        if (!(deeper instanceof A_Sequence)) {
            throw new RuntimeError(cr, "Invalid type of value.", "Value to key " + key.toString(cr, STYPE.IDENT) + " isn't a sequence, so I can't go into it!");
        }
        A_Sequence deeper2 = (A_Sequence)deeper;
        return deeper2.sequenceDeepGet(cr, keys, offset + 1, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        I_Object key = cr.argType(keys[offset], I_Object.class);
        int idx = this.iGetIndex(cr, key, !lazy);
        if (offset == keys.length - 1) {
            if (idx == -1) {
                if (lazy) {
                    this.iFixedLength(cr);
                    this.keys.add(key);
                    this.values.add(value);
                    return;
                }
                throw new RuntimeError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
            }
            this.values.set(idx, value);
        } else {
            I_Object deeper;
            if (idx == -1) {
                if (lazy) {
                    this.iFixedLength(cr);
                    this.keys.add(key);
                    this.values.add(new JMo_Map());
                    idx = this.values.size() - 1;
                } else {
                    throw new RuntimeError(cr, "Unknown key for Map.", "Key is missing! Got: " + key);
                }
            }
            if (!((deeper = this.values.get(idx)) instanceof A_Sequence)) {
                throw new RuntimeError(cr, "Invalid type of value.", "Value to key " + key.toString(cr, STYPE.IDENT) + " isn't a sequence, so I can't go into it!");
            }
            A_Sequence deeper2 = (A_Sequence)deeper;
            deeper2.sequenceDeepSet(cr, keys, offset + 1, value, lazy);
        }
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int i = this.iGetIndex(cr, key, false);
        return lazy && i == -1 ? Nil.NIL : this.values.get(i);
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.impossible(new Object[0]);
    }

    private void iFixedLength(CallRuntime cr) {
        if (this.fixedLength) {
            throw new RuntimeError(cr, "Can't change size of fixed Map", "Adding/Removing elements is not allowed!");
        }
    }

    public List<I_Object> internalGetKeys() {
        return this.keys;
    }

    public List<I_Object> internalGetValues() {
        return this.values;
    }
}

