/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.magic.con;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.debug.DEBUG_LEVEL;
import de.mn77.base.sys.MOut;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.magic.con.A_MagicConst;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Output;

public class MagicDebug
extends A_MagicConst {
    public static final String id = "DEBUG";
    private static final int LINE_LENGTH = 64;

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "note": {
                String t = Lib_Convert.getStringValue(cr, cr.args(this, Str.class)[0]);
                this.iPrint(cr, t);
                break;
            }
            case "line": {
                cr.argsNone();
                this.iPrint(cr, Lib_String.sequence('-', 64L));
                break;
            }
            case "trace": {
                this.mTrace(cr);
                break;
            }
            case "vce": {
                cr.argsNone();
                this.iPrint(cr, cr.vce.toString());
                break;
            }
            default: {
                return null;
            }
        }
        return A_Object.stdResult(this);
    }

    @Override
    public String getName() {
        return id;
    }

    private void mTrace(CallRuntime cr) {
        cr.argsNone();
        DEBUG_LEVEL level = MOut.getDebugLevel();
        boolean java = MOut.getJavaErrors();
        MOut.debugDetail();
        MOut.setJavaErrors(true);
        MOut.trace(new Object[0]);
        MOut.setDebug(level);
        MOut.setJavaErrors(java);
        this.iPrint(cr, Lib_String.sequence('-', 64L));
    }

    private void iPrint(CallRuntime cr, String ... sa) {
        String intro = String.valueOf(new MTime().toString()) + " | ";
        StringBuilder sb = new StringBuilder();
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(intro);
            sb.append(s);
            sb.append('\n');
            ++n2;
        }
        sb.append(intro);
        sb.append("  @ ");
        sb.append(cr.getDebugInfo().toString());
        Lib_Output.out(cr.getApp(), sb.toString(), true);
    }
}

