/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.data.Lib_BigMath;
import de.mn77.base.data.bigcalc.Lib_BigCalc;
import de.mn77.base.error.Err;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_DecNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_BigNumber;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.NOP0;
import org.jaymo_lang.object.atom.NOP1;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_AtomicCalc;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_BigDec
extends A_DecNumber
implements I_Decimal,
I_Atomic,
I_BigNumber {
    public static final MathContext CONTEXT = Lib_BigMath.CONTEXT256;
    public static final MathContext CONTEXT_UP;
    public static final MathContext CONTEXT1;
    public static final MathContext CONTEXT2;
    public static final MathContext CONTEXT3;
    private final BigDecimal value;

    static {
        CONTEXT1 = CONTEXT_UP = new MathContext(CONTEXT.getPrecision(), RoundingMode.UP);
        CONTEXT2 = CONTEXT_UP;
        CONTEXT3 = CONTEXT;
    }

    public JMo_BigDec(BigDecimal val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.BIGDEC;
    }

    @Override
    protected ObjectCallResult call5(CallRuntime cr, String method) {
        return null;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    protected A_Number numberCalc0(CallRuntime cr, NOP0 op) {
        switch (op) {
            case NEG: {
                return new JMo_BigDec(this.value.negate());
            }
            case ABS: {
                return new JMo_BigDec(this.value.abs());
            }
            case EXP: {
                return new JMo_BigDec(Lib_BigCalc.exp(this.value, CONTEXT));
            }
            case INC: {
                return new JMo_BigDec(this.value.add(BigDecimal.ONE, CONTEXT));
            }
            case DEC: {
                return new JMo_BigDec(this.value.subtract(BigDecimal.ONE, CONTEXT));
            }
            case POW: {
                return new JMo_BigDec(this.value.multiply(this.value, CONTEXT));
            }
            case ROOT: {
                return new JMo_BigDec(this.value.sqrt(CONTEXT));
            }
            case LOG10: {
                return new JMo_BigDec(Lib_BigMath.log(this.value, BigDecimal.valueOf(10L), CONTEXT));
            }
            case LOGN: {
                return new JMo_BigDec(Lib_BigMath.log(this.value, Lib_BigMath.EULER_256, CONTEXT));
            }
        }
        throw Err.impossible(new Object[]{op});
    }

    @Override
    protected A_Number numberCalcSame(CallRuntime cr, A_Number num, boolean inc) {
        BigDecimal arg = Lib_Convert.getBigDecimalValue(cr, num);
        return new JMo_BigDec(inc ? this.value.add(arg, CONTEXT) : this.value.subtract(arg, CONTEXT));
    }

    @Override
    protected A_Number numberCalc1(CallRuntime cr, NOP1 op, A_Number arg) {
        return Lib_AtomicCalc.numberCalcBigDec(cr, op, this.value, Lib_Convert.getBigDecimalValue(cr, arg));
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        throw this.newErrorMinMaxValue(cr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String toString(CallRuntime cr, STYPE type) {
        block6: {
            nested = type == STYPE.NESTED;
            v0 = suffix = type == STYPE.IDENT || type == STYPE.DESCRIBE;
            if (Double.isNaN(this.value.doubleValue())) {
                return "not_a_number";
            }
            if (this.value.doubleValue() == Infinity) {
                return "+infinity";
            }
            if (this.value.doubleValue() == -Infinity) {
                return "-infinity";
            }
            result = this.value.toPlainString();
            if (result.indexOf(46) != -1) ** GOTO lbl14
            result = String.valueOf(result) + ".";
            break block6;
lbl-1000:
            // 1 sources

            {
                result = result.substring(0, result.length() - 1);
lbl14:
                // 2 sources

                ** while (result.endsWith((String)"0"))
            }
        }
        if (result.endsWith(".")) {
            result = String.valueOf(result) + "0";
        }
        if (nested && result.length() > 40) {
            result = Lib_BigMath.toNotationE(result, 16);
        }
        return suffix != false ? String.valueOf(result) + 'z' : result;
    }
}

