/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.tcp;

import de.mn77.lib.tcp.TCP_Connection;
import de.mn77.lib.tcp.TCP_Server;
import java.io.IOException;
import org.jaymo_lang.error.ExternalError;
import org.jaymo_lang.lib.tcp.JMo_TcpConnection;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_EventObject;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.pseudo.JMo_Error;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_TcpServer
extends A_EventObject {
    private TCP_Server server;
    private final ArgCallBuffer par_port;

    public JMo_TcpServer(Call port) {
        this.par_port = new ArgCallBuffer(0, port);
    }

    @Override
    public void init(CallRuntime cr) {
        int p = Lib_Convert.getIntValue(cr, this.par_port.init(cr, this, A_IntNumber.class));
        try {
            this.server = new TCP_Server(p);
        }
        catch (IOException e) {
            throw new ExternalError(cr, "TCP-Network error", e.getMessage());
        }
        this.server.onConnect(verb -> {
            JMo_TcpConnection con = new JMo_TcpConnection((TCP_Connection)verb);
            this.eventRun(cr, "@connect", con);
        });
        this.server.onTimeOut(ste -> {
            JMo_Error e = new JMo_Error((Throwable)ste);
            this.eventRun(cr, "@timeout", e);
        });
        this.server.onError(ioe -> {
            JMo_Error e = new JMo_Error((Throwable)ioe);
            this.eventRun(cr, "@error", e);
        });
    }

    @Override
    protected ObjectCallResult callMethod(CallRuntime cr, String method) {
        switch (method) {
            case "wait": {
                I_Object o = cr.args(this, A_IntNumber.class)[0];
                int timeout = Lib_Convert.getIntValue(cr, o);
                this.server.waitForConnection(timeout * 1000);
                return A_Object.stdResult(Nil.NIL);
            }
            case "close": {
                cr.argsNone();
                this.server.close();
                return A_Object.stdResult(Nil.NIL);
            }
        }
        return null;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        switch (event) {
            case "@timeout": 
            case "@connect": 
            case "@error": {
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return String.valueOf(super.toString()) + "(" + this.par_port.get().toString(cr, STYPE.IDENT) + ")";
    }
}

