/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.SpringLayout;
import org.jaymo_lang.lib.swing.A_Swing_Object;
import org.jaymo_lang.lib.swing.I_Swing_Object;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class Swing_FlexItem
extends A_Swing_Object {
    private final Container container;
    private final SpringLayout layout;
    private final Component component;
    private final int[] borders_trbl;

    public Swing_FlexItem(Container container, SpringLayout layout, Component component, int[] borders_trbl) {
        this.container = container;
        this.layout = layout;
        this.component = component;
        this.borders_trbl = borders_trbl;
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    public I_Object callMethod2(CallRuntime cr, String method) {
        switch (method) {
            case "left": {
                return this.anchor(cr, ANCHOR.L);
            }
            case "right": {
                return this.anchor(cr, ANCHOR.R);
            }
            case "top": {
                return this.anchor(cr, ANCHOR.T);
            }
            case "bottom": {
                return this.anchor(cr, ANCHOR.B);
            }
            case "pos": {
                return this.pos(cr);
            }
            case "size": {
                return this.size(cr);
            }
            case "width": {
                return this.width(cr);
            }
            case "height": {
                return this.height(cr);
            }
        }
        return null;
    }

    private Swing_FlexItem anchor(CallRuntime cr, ANCHOR a) {
        I_Object[] oa = cr.argsFlex(this, 0, 2);
        int parlen = oa.length;
        Component target = this.container;
        int pad = 0;
        if (parlen == 2) {
            I_Swing_Object swo = (I_Swing_Object)cr.argType(oa[0], I_Swing_Object.class);
            target = swo.getSwing();
            pad = Lib_Convert.getIntValue(cr, cr.argType(oa[1], A_IntNumber.class));
        }
        if (parlen == 1) {
            I_Object o = cr.argTypeExt(oa[0], I_Swing_Object.class, A_IntNumber.class);
            if (o instanceof I_Swing_Object) {
                target = ((I_Swing_Object)o).getSwing();
            } else {
                pad = Lib_Convert.getIntValue(cr, o);
            }
        }
        this.iAnchorSet(a, target, pad);
        return this;
    }

    private void iAnchorSet(ANCHOR a, Component target, int pad) {
        String targetside = null;
        switch (a) {
            case L: {
                targetside = target == this.container ? "West" : "East";
                break;
            }
            case R: {
                targetside = target == this.container ? "East" : "West";
                break;
            }
            case T: {
                targetside = target == this.container ? "North" : "South";
                break;
            }
            case B: {
                String string = targetside = target == this.container ? "South" : "North";
            }
        }
        if (this.borders_trbl != null && target == this.container) {
            if (a == ANCHOR.T) {
                pad += this.borders_trbl[0];
            }
            if (a == ANCHOR.R) {
                pad += this.borders_trbl[1];
            }
            if (a == ANCHOR.B) {
                pad += this.borders_trbl[2];
            }
            if (a == ANCHOR.L) {
                pad += this.borders_trbl[3];
            }
        }
        switch (a) {
            case L: {
                this.layout.putConstraint("West", this.component, pad, targetside, target);
                break;
            }
            case R: {
                this.layout.putConstraint("East", this.component, -pad, targetside, target);
                break;
            }
            case T: {
                this.layout.putConstraint("North", this.component, pad, targetside, target);
                break;
            }
            case B: {
                this.layout.putConstraint("South", this.component, -pad, targetside, target);
            }
        }
    }

    private Swing_FlexItem pos(CallRuntime cr) {
        Class[] so_in = new Class[]{I_Swing_Object.class, A_IntNumber.class};
        I_Object[] oa = cr.argsExt(this, so_in, so_in, so_in, so_in);
        this.iPos(cr, ANCHOR.T, oa[0]);
        this.iPos(cr, ANCHOR.R, oa[1]);
        this.iPos(cr, ANCHOR.B, oa[2]);
        this.iPos(cr, ANCHOR.L, oa[3]);
        return this;
    }

    private void iPos(CallRuntime cr, ANCHOR a, I_Object o) {
        Component target = this.container;
        int pad = 0;
        if (o != Nil.NIL) {
            if (o instanceof I_Swing_Object) {
                target = ((I_Swing_Object)o).getSwing();
            } else {
                pad = Lib_Convert.getIntValue(cr, o);
            }
            this.iAnchorSet(a, target, pad);
        }
    }

    private Swing_FlexItem size(CallRuntime cr) {
        I_Object[] o = cr.args(this, Int.class, Int.class);
        int w = Lib_Convert.getIntValue(cr, o[0]);
        int h = Lib_Convert.getIntValue(cr, o[1]);
        this.component.setPreferredSize(new Dimension(w, h));
        return this;
    }

    private Swing_FlexItem width(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int w = Lib_Convert.getIntValue(cr, o);
        Dimension d = this.component.getPreferredSize();
        d.width = w;
        this.component.setPreferredSize(d);
        return this;
    }

    private Swing_FlexItem height(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int h = Lib_Convert.getIntValue(cr, o);
        Dimension d = this.component.getPreferredSize();
        d.height = h;
        this.component.setPreferredSize(d);
        return this;
    }

    @Override
    public Component getSwing() {
        return null;
    }

    @Override
    protected ObjectCallResult callEvent(CallRuntime cr, String event) {
        return null;
    }

    @Override
    public boolean validateEvent(CallRuntime cr, String event) {
        return false;
    }

    private static enum ANCHOR {
        L,
        R,
        T,
        B;

    }
}

