/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.lib.csv;

import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.csv.CSV_TableFile;
import de.mn77.lib.csv.Lib_CSV;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.A_ObjectSimple;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.filesys.JMo_File;
import org.jaymo_lang.object.struct.JMo_Table;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Convert;

public class JMo_Csv
extends A_ObjectSimple {
    private final Call call_delimiter_field;
    private final Call call_delimiter_value;
    private final Call call_delimiter_line;
    private char delimiter_field = (char)34;
    private char delimiter_value = (char)44;
    private String delimiter_line = "\n";

    public JMo_Csv() {
        this(null, null, null);
    }

    public JMo_Csv(Call delimiter_value) {
        this(null, delimiter_value, null);
    }

    public JMo_Csv(Call field_delimiter, Call value_delimiter, Call line_delimiter) {
        this.call_delimiter_field = field_delimiter;
        this.call_delimiter_value = value_delimiter;
        this.call_delimiter_line = line_delimiter;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.call_delimiter_field != null) {
            this.delimiter_field = Lib_Convert.getCharValue(cr, cr.execInit(this.call_delimiter_field, this));
        }
        if (this.call_delimiter_value != null) {
            this.delimiter_value = Lib_Convert.getCharValue(cr, cr.execInit(this.call_delimiter_value, this));
        }
        if (this.call_delimiter_line != null) {
            this.delimiter_line = Lib_Convert.getStringValue(cr, cr.execInit(this.call_delimiter_line, this));
        }
    }

    @Override
    protected I_Object call3(CallRuntime cr, String method) {
        switch (method) {
            case "readHead": {
                return this.mRead(cr, READTYPE.HEAD);
            }
            case "readBody": 
            case "readData": {
                return this.mRead(cr, READTYPE.BODY);
            }
            case "read": {
                return this.mRead(cr, READTYPE.COMPLETE);
            }
            case "parseHead": {
                return this.mParse(cr, READTYPE.HEAD);
            }
            case "parseBody": 
            case "parseData": {
                return this.mParse(cr, READTYPE.BODY);
            }
            case "parse": {
                return this.mParse(cr, READTYPE.COMPLETE);
            }
            case "write": {
                return this.mWrite(cr);
            }
        }
        return null;
    }

    private I_Object mRead(CallRuntime cr, READTYPE rt) {
        I_Object o = cr.argsExt(this, new Class[][]{{Str.class, JMo_File.class}})[0];
        String file = o instanceof JMo_File ? ((JMo_File)o).getInternalFile().getAbsolutePath() : Lib_Convert.getStringValue(cr, o);
        CSV_TableFile csv = new CSV_TableFile(file);
        csv.setSeparatorCol(this.delimiter_value);
        csv.setSeparatorField(this.delimiter_field);
        csv.setSeparatorLine(this.delimiter_line);
        try {
            switch (rt) {
                case COMPLETE: {
                    return Lib_Convert.toJMo(csv.get());
                }
                case HEAD: {
                    return Lib_Convert.toJMo(csv.getFirstLine());
                }
                case BODY: {
                    return Lib_Convert.toJMo(csv.getWithoutFirstLine());
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (Err_Runtime r) {
            throw new RuntimeError(cr, "CSV-Table-Error", r.getMessage());
        }
        catch (Err_FileSys f) {
            throw new RuntimeError(cr, "File-Access-Error", f.getMessage());
        }
    }

    private I_Object mWrite(CallRuntime cr) {
        I_Object[] oa = cr.argsExt(this, {Str.class, JMo_File.class}, {JMo_Table.class});
        String file = oa[0] instanceof JMo_File ? ((JMo_File)oa[0]).getInternalFile().getAbsolutePath() : Lib_Convert.getStringValue(cr, oa[0]);
        CSV_TableFile csv = new CSV_TableFile(file);
        csv.setSeparatorCol(this.delimiter_value);
        csv.setSeparatorField(this.delimiter_field);
        csv.setSeparatorLine(this.delimiter_line);
        try {
            I_Table<String> ts = Lib_Convert.toTableString((JMo_Table)oa[1]);
            csv.write(ts);
        }
        catch (Err_FileSys f) {
            throw new RuntimeError(cr, "File-Access-Error", f.getLocalizedMessage());
        }
        return this;
    }

    private I_Object mParse(CallRuntime cr, READTYPE rt) {
        I_Object o = cr.args(this, Str.class)[0];
        String csv = Lib_Convert.getStringValue(cr, o);
        try {
            switch (rt) {
                case COMPLETE: {
                    I_Table<String> tab1 = Lib_CSV.parse(csv, this.delimiter_field, this.delimiter_value, this.delimiter_line, true, true);
                    return Lib_Convert.toJMo(tab1);
                }
                case HEAD: {
                    I_Table<String> tab2 = Lib_CSV.parse(csv, this.delimiter_field, this.delimiter_value, this.delimiter_line, true, false);
                    return Lib_Convert.toJMo(tab2.getRow(1));
                }
                case BODY: {
                    I_Table<String> tab3 = Lib_CSV.parse(csv, this.delimiter_field, this.delimiter_value, this.delimiter_line, false, true);
                    return Lib_Convert.toJMo(tab3);
                }
            }
            throw Err.impossible(new Object[0]);
        }
        catch (Err_Runtime r) {
            throw new RuntimeError(cr, "CSV-Table-Error", r.getLocalizedMessage());
        }
    }

    private static enum READTYPE {
        COMPLETE,
        HEAD,
        BODY;

    }
}

