/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.config;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.convert.ConvString;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.error.Err_Runtime;
import de.mn77.lib.config.I_PropertiesFile_Read;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.Set;

public class PropertiesFile
implements I_PropertiesFile_Read {
    private Properties prop;
    private final String title;
    private final File file;

    public PropertiesFile(String title, File file) {
        Err.ifNull(file);
        this.prop = new Properties();
        this.file = file;
        this.title = title;
    }

    public void read() throws Err_FileSys {
        this.read(false);
    }

    public void read(boolean mustExist) throws Err_FileSys {
        this.iCheckClosed();
        InputStreamReader isr = null;
        try {
            try {
                if (this.file.exists()) {
                    isr = new InputStreamReader((InputStream)new FileInputStream(this.file), "UTF-8");
                    this.prop.load(isr);
                } else if (mustExist) {
                    throw Err.fsFailed("File is missing", this.file);
                }
            }
            catch (IOException e) {
                throw Err.wrap(e, "Can't read properties file.");
            }
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                Err.show(e);
            }
        }
    }

    public void write() throws Err_FileSys {
        this.iCheckClosed();
        OutputStreamWriter osw = null;
        try {
            try {
                FileOutputStream fos = new FileOutputStream(this.file);
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                this.prop.store(osw, this.title);
            }
            catch (Exception e) {
                throw Err.fsFailed(e, "Can't write properties file");
            }
        }
        finally {
            try {
                if (osw != null) {
                    osw.close();
                }
            }
            catch (IOException e) {
                Err.show(e);
            }
        }
    }

    public void close() throws Err_FileSys {
        this.write();
        this.prop = null;
    }

    public I_List<String> getAllKeys() {
        this.iCheckClosed();
        Set<Object> keys = this.prop.keySet();
        MList<String> result = new MList<String>();
        keys.forEach(key -> result.add((String)key));
        return result;
    }

    public void removeKey(String key) {
        this.iCheckClosed();
        this.prop.remove(key);
    }

    @Override
    public String getString(String key) {
        return this.getStringOrDefault(key, null);
    }

    @Override
    public String getStringOrDefault(String key, String defaultValue) {
        this.iCheckClosed();
        return this.prop.getProperty(this.iNormalizeKey(key), defaultValue);
    }

    @Override
    public Integer getInteger(String key) {
        return this.getIntegerOrDefault(key, null);
    }

    @Override
    public Integer getIntegerOrDefault(String key, Integer defaultValue) {
        return ConvString.toInteger(this.getStringOrDefault(key, "" + defaultValue));
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBooleanOrDefault(key, null);
    }

    @Override
    public Boolean getBooleanOrDefault(String key, Boolean defaultValue) {
        return ConvString.toBoolean(this.getStringOrDefault(key, "" + defaultValue));
    }

    @Override
    public void setString(String key, String value) {
        Err.ifNull(key, value);
        this.iCheckClosed();
        this.prop.setProperty(this.iNormalizeKey(key), value);
    }

    @Override
    public void setInteger(String key, Integer value) {
        this.setString(key, ConvObject.toText(value));
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setString(key, ConvObject.toText(value));
    }

    private String iNormalizeKey(String key) {
        Err.ifNull(key);
        return FilterString.only((String.valueOf("abcdefghijklmnopqrstuvwxyz".toLowerCase()) + "0123456789" + "_.-").toCharArray(), key.toLowerCase());
    }

    private void iCheckClosed() {
        if (this.prop == null) {
            throw new Err_Runtime("This properties file is finally closed!", new Object[0]);
        }
    }
}

