/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.convert.ConvChar;
import de.mn77.base.data.form.FormNumber;
import de.mn77.base.data.form.FormString;
import de.mn77.base.data.numsys.Hex;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import de.mn77.base.sys.MOut;

public class FormChar {
    public static void main(String[] args) {
        String v = "Foo\tb'a\"r\nb\u0003a\u0005\u0005k\u0000p";
        String s = FormString.quote("Foo\tb'a\"r\nb\u0003a\u0005\u0005k\u0000p", '\"', '\\', true);
        MOut.print(s);
    }

    public static String escapeSlash(char c) {
        switch (c) {
            case '\u0000': {
                return "\\0";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return "" + c;
    }

    public static String escapeSqlSecure(char c, boolean quotes, boolean doubleQuotes) {
        if (!quotes && doubleQuotes) {
            Err.invalid("Use 'quotes' = true for doubleQuotes!");
        }
        switch (c) {
            case '\u0000': {
                return "\\0";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
            case '\u001a': {
                return "\\u001A";
            }
        }
        if (quotes) {
            switch (c) {
                case '\"': 
                case '\'': {
                    return doubleQuotes ? "" + c + c : "\\" + c;
                }
            }
        }
        return "" + c;
    }

    public static String escapeSpecialChar(char c) {
        if (c > '\u00ff') {
            return ConvChar.getUnicode(c);
        }
        switch (c) {
            case '\u0000': {
                return "\\0";
            }
            case '\n': {
                return "\\n";
            }
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c < ' ') {
            return "\\u" + FormNumber.width(4, Hex.toHex(c), false);
        }
        return "" + c;
    }

    public static int unescapeSpecialChar(String s, int index, StringBuilder sb) {
        if (s.charAt(index) != '\\' || index == s.length() - 1) {
            sb.append(s.charAt(index));
            return 1;
        }
        char c = s.charAt(index + 1);
        switch (c) {
            case '0': {
                sb.append('\u0000');
                return 2;
            }
            case 'n': {
                sb.append('\n');
                return 2;
            }
            case 't': {
                sb.append('\t');
                return 2;
            }
            case 'r': {
                sb.append('\r');
                return 2;
            }
            case 'f': {
                sb.append('\f');
                return 2;
            }
            case 'b': {
                sb.append('\b');
                return 2;
            }
            case '\\': {
                sb.append('\\');
                return 2;
            }
            case '\'': {
                sb.append('\'');
                return 2;
            }
            case '\"': {
                sb.append('\"');
                return 2;
            }
            case 'u': {
                if (index + 5 > s.length() - 1) {
                    throw new Err_Runtime("Invalid unicode sentence", s);
                }
                sb.append(ConvChar.parseUnicode(s.substring(index, index + 6)));
                return 6;
            }
        }
        sb.append(s.charAt(index));
        return 1;
    }
}

