/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.form.FormNumber;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.parser.I_DebugInfoSource;
import org.jaymo_lang.util.Lib_Parser;

public class LineBuffer
implements I_DebugInfoSource {
    private final String[] lines;
    private final int[] line_nrs;
    private final int len;
    private final String filepath;
    private int next = 0;
    private int depth = 0;
    private int downchanged = 0;
    private DebugInfo debug = null;

    public LineBuffer(String filepath, String[] lines, int[] linenrs) {
        this.filepath = filepath;
        this.lines = lines;
        this.line_nrs = linenrs;
        this.len = lines.length;
    }

    @Override
    public DebugInfo getDebugInfo() {
        return this.debug;
    }

    public String getNext() {
        this.downchanged = 0;
        String s = this.lines[this.next];
        this.depth = Lib_Parser.getDepth(s);
        String result = this.depth == 0 ? s : s.substring(this.depth);
        String fileInfo = this.filepath == null || this.filepath.length() == 0 ? null : this.filepath;
        int lineNr = this.line_nrs.length == 0 ? 0 : this.line_nrs[(int)Lib_Math.limit(0.0, this.line_nrs.length - 1, this.next)];
        this.debug = new DebugInfo(fileInfo, lineNr);
        ++this.next;
        return result;
    }

    public boolean hasNext() {
        while (this.next < this.len && this.lines[this.next] == null) {
            ++this.next;
        }
        return this.next < this.len;
    }

    public void levelDownchanged() {
        ++this.downchanged;
    }

    public int nextLevelDiff() {
        while (this.next < this.len && this.lines[this.next] == null) {
            ++this.next;
        }
        if (this.next == this.len) {
            return 0;
        }
        int depthOld = this.depth;
        int depthNew = Lib_Parser.getDepth(this.lines[this.next]);
        if (depthNew == depthOld) {
            return 0;
        }
        int result = depthNew - depthOld;
        return result + this.downchanged;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.len) {
            String prefix = i == this.next + 1 ? "->" : "  ";
            String depth = i == this.next + 1 ? FormNumber.right(2, this.depth) : "  ";
            prefix = String.valueOf(depth) + " " + prefix + " ";
            sb.append(String.valueOf(prefix) + this.lines[i]);
            sb.append("\n");
            ++i;
        }
        return sb.toString();
    }

    public int getCurrentLevel() {
        return this.depth;
    }
}

