/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.struct;

import de.mn77.base.error.Err;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.LoopHandle;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.Bool;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Byte;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.JMo_Short;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.A_Immutable;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.struct.A_Sequence;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Sequence;

public class JMo_ByteArray
extends A_Sequence {
    private byte[] data;
    private final ArgCallBuffer arg1;

    public JMo_ByteArray(byte[] ba) {
        this.data = ba;
        this.arg1 = null;
    }

    public JMo_ByteArray(int size) {
        this.data = new byte[size];
        this.arg1 = null;
    }

    public JMo_ByteArray(Call arg) {
        this.arg1 = new ArgCallBuffer(0, arg);
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.arg1 != null) {
            A_IntNumber a1 = this.arg1.init(cr, this, A_IntNumber.class);
            int size = Lib_Convert.getIntValue(cr, a1);
            this.data = new byte[size];
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "toList": {
                return A_Object.stdResult(this.mToList(cr));
            }
            case "toByte": {
                return A_Object.stdResult(this.mToIntNumber(cr, 1));
            }
            case "toShort": {
                return A_Object.stdResult(this.mToIntNumber(cr, 2));
            }
            case "toInt": {
                return A_Object.stdResult(this.mToIntNumber(cr, 4));
            }
            case "toLong": {
                return A_Object.stdResult(this.mToIntNumber(cr, 8));
            }
            case "toStrUTF8": {
                return A_Object.stdResult(this.mToStr(cr, StandardCharsets.UTF_8));
            }
            case "toStrUTF16": {
                return A_Object.stdResult(this.mToStr(cr, StandardCharsets.UTF_16));
            }
            case "toStrASCII": {
                return A_Object.stdResult(this.mToStr(cr, StandardCharsets.US_ASCII));
            }
            case "fill": {
                this.iFill(cr);
                return A_Object.stdResult(this);
            }
            case "cut": {
                return A_Object.stdResult(this.mCut(cr));
            }
            case "part": {
                return A_Object.stdResult(this.mPart(cr));
            }
            case "left": {
                return A_Object.stdResult(this.mLeft(cr));
            }
            case "right": {
                return A_Object.stdResult(this.mRight(cr));
            }
            case "start": {
                return A_Object.stdResult(this.mStartPos(cr));
            }
            case "end": {
                return A_Object.stdResult(this.mEndPos(cr));
            }
            case "expandLeft": {
                return A_Object.stdResult(this.mExpand(cr, false));
            }
            case "expandRight": {
                return A_Object.stdResult(this.mExpand(cr, true));
            }
            case "append": 
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "delete": 
            case "-": {
                return A_Object.stdResult(this.mRemovePos(cr));
            }
            case "insert": {
                return A_Object.stdResult(this.mInsert(cr));
            }
            case "begin": {
                return A_Object.stdResult(this.mBegin(cr));
            }
            case "concat": 
            case "++": {
                return A_Object.stdResult(this.mConcat(cr));
            }
            case "contains": {
                return A_Object.stdResult(this.mContains(cr));
            }
            case "search": 
            case "searchFirst": {
                return A_Object.stdResult(this.mSearch(cr, true));
            }
            case "searchLast": {
                return A_Object.stdResult(this.mSearch(cr, false));
            }
            case "each": {
                return this.mEach(cr);
            }
        }
        return null;
    }

    private I_Object mExpand(CallRuntime cr, boolean right) {
        Int arg = (Int)cr.args(this, Int.class)[0];
        int toAdd = arg.getValue();
        Lib_Error.ifTooSmall(cr, 1L, toAdd);
        byte[] baNew = new byte[this.data.length + toAdd];
        int destPos = right ? 0 : toAdd;
        System.arraycopy(this.data, 0, baNew, destPos, this.data.length);
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray mAdd(CallRuntime cr) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        byte[] baNew = new byte[this.data.length + oa.length];
        System.arraycopy(this.data, 0, baNew, 0, this.data.length);
        int i = 0;
        while (i < oa.length) {
            byte b;
            baNew[this.data.length + i] = b = ((JMo_Byte)cr.argType(oa[i], JMo_Byte.class)).getValue().byteValue();
            ++i;
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray mRemovePos(CallRuntime cr) {
        Int o = (Int)cr.args(this, Int.class)[0];
        int oi = Lib_Convert.getIntValue(cr, o);
        Lib_Error.ifNotBetween(cr, 1, this.data.length, oi, "position");
        byte[] baNew = new byte[this.data.length - 1];
        if (oi > 1) {
            System.arraycopy(this.data, 0, baNew, 0, oi - 1);
        }
        if (oi < this.data.length) {
            System.arraycopy(this.data, oi, baNew, oi - 1, this.data.length - oi);
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray mInsert(CallRuntime cr) {
        I_Object[] oa = cr.args(this, JMo_Byte.class, A_IntNumber.class);
        int pos = Lib_Convert.getIntValue(cr, oa[1]);
        byte val = ((JMo_Byte)oa[0]).getValue();
        int len = this.data.length;
        Lib_Error.ifIs(cr, 0, pos, "position");
        Lib_Error.ifOutOfBounds(cr, len + 1, pos, "position");
        if (pos < 0) {
            pos = Lib_Sequence.realPos(cr, pos, len, false) + 1;
        }
        byte[] baNew = new byte[len + 1];
        baNew[pos - 1] = val;
        if (pos > 1) {
            System.arraycopy(this.data, 0, baNew, 0, pos - 1);
        }
        if (pos <= this.data.length) {
            System.arraycopy(this.data, pos - 1, baNew, pos, this.data.length - pos + 1);
        }
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray mBegin(CallRuntime cr) {
        byte b = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        int len = this.data.length;
        byte[] baNew = new byte[len + 1];
        baNew[0] = b;
        System.arraycopy(this.data, 0, baNew, 1, len);
        return new JMo_ByteArray(baNew);
    }

    private JMo_ByteArray mConcat(CallRuntime cr) {
        byte[] data2 = ((JMo_ByteArray)cr.args((I_Object)this, new Class[]{JMo_ByteArray.class})[0]).data;
        byte[] baNew = new byte[this.data.length + data2.length];
        System.arraycopy(this.data, 0, baNew, 0, this.data.length);
        System.arraycopy(data2, 0, baNew, this.data.length, data2.length);
        return new JMo_ByteArray(baNew);
    }

    private Bool mContains(CallRuntime cr) {
        byte b = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte lo = byArray[n2];
            if (lo == b) {
                return Bool.TRUE;
            }
            ++n2;
        }
        return Bool.FALSE;
    }

    private A_Immutable mSearch(CallRuntime cr, boolean first) {
        byte search = ((JMo_Byte)cr.args(this, JMo_Byte.class)[0]).getValue();
        if (first) {
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] == search) {
                    return new Int(i + 1);
                }
                ++i;
            }
        } else {
            int i = this.data.length - 1;
            while (i >= 0) {
                if (this.data[i] == search) {
                    return new Int(i + 1);
                }
                --i;
            }
        }
        return Nil.NIL;
    }

    private void iFill(CallRuntime cr) {
        JMo_Byte arg = (JMo_Byte)cr.args(this, JMo_Byte.class)[0];
        byte b = Lib_Convert.getByteValue(cr, arg);
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = b;
            ++i;
        }
    }

    private JMo_ByteArray mStartPos(CallRuntime cr) {
        I_Object arg = cr.args(this, Int.class)[0];
        int start = ((Int)arg).getValue();
        int end = this.data.length;
        Lib_Error.ifNotBetween(cr, 1, end, start, "position");
        return this.iCutCopy(cr, start, end);
    }

    private JMo_ByteArray mEndPos(CallRuntime cr) {
        I_Object arg = cr.args(this, Int.class)[0];
        int end = ((Int)arg).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, end, "position");
        return this.iCutCopy(cr, 1, end);
    }

    private JMo_ByteArray mCut(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int len = ((Int)oa[1]).getValue();
        Lib_Error.ifEmpty(cr, this.data.length, "List");
        Lib_Error.ifNotBetween(cr, 1, this.data.length, start, "start");
        if (len == 0) {
            return new JMo_ByteArray(new byte[0]);
        }
        if (len > this.data.length) {
            len = this.data.length - start + 1;
        }
        return this.iCutCopy(cr, start, Math.min(this.data.length, start + len - 1));
    }

    private JMo_ByteArray mPart(CallRuntime cr) {
        I_Object[] oa = cr.args(this, Int.class, Int.class);
        int start = ((Int)oa[0]).getValue();
        int end = ((Int)oa[1]).getValue();
        int size = this.data.length;
        Lib_Error.ifEmpty(cr, this.data.length, "ByteArray");
        Lib_Error.ifNotBetween(cr, 1, Math.min(end, size), start, "start");
        Lib_Error.ifNotBetween(cr, Math.max(1, start), size, end, "end");
        return this.iCutCopy(cr, start, Math.min(this.data.length, end));
    }

    private JMo_ByteArray mLeft(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int left = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, left, "length");
        return this.iCutCopy(cr, 1, Math.min(left, this.data.length));
    }

    private JMo_ByteArray mRight(CallRuntime cr) {
        I_Object o = cr.args(this, Int.class)[0];
        int right = ((Int)o).getValue();
        Lib_Error.ifNotBetween(cr, 1, this.data.length, right, "length");
        return this.iCutCopy(cr, Math.max(1, this.data.length - right + 1), this.data.length);
    }

    private ObjectCallResult mEach(CallRuntime crOld) {
        crOld.argsNone();
        if (crOld.getStream() == null && crOld.getCallBlock() == null) {
            throw new CodeError(crOld, "No Stream or Block for 'each'", null);
        }
        LoopHandle handle = new LoopHandle(this);
        CallRuntime crNew = crOld.copyLoop(handle);
        I_Object result = this;
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte it = byArray[n2];
            handle.startLap();
            result = Lib_Exec.execBlockStream(crNew, new JMo_Byte(it));
            result = Lib_Exec.loopResult(result);
            if (result instanceof Return) {
                return ((Return)result).getLoopResult();
            }
            ++n2;
        }
        return new ObjectCallResult(result, true);
    }

    private JMo_List mToList(CallRuntime cr) {
        cr.argsNone();
        ArrayList<I_Object> list = new ArrayList<I_Object>();
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            list.add(new JMo_Byte(element));
            ++n2;
        }
        return new JMo_List(list);
    }

    private A_IntNumber mToIntNumber(CallRuntime cr, int bytes) {
        cr.argsNone();
        Lib_Error.ifNot(cr, bytes, this.data.length, "length");
        switch (bytes) {
            case 1: {
                return new JMo_Byte(this.data[0]);
            }
            case 2: {
                short vs = this.data[1];
                vs = (short)(vs + (this.data[0] << 8));
                return new JMo_Short(vs);
            }
            case 4: {
                int vi = this.data[3];
                vi += this.data[2] << 8;
                vi += this.data[1] << 16;
                return new Int(vi += this.data[0] << 24);
            }
            case 8: {
                int vl = this.data[7];
                vl += this.data[6] << 8;
                vl += this.data[5] << 16;
                vl += this.data[4] << 24;
                vl += this.data[3] << 32;
                vl += this.data[2] << 40;
                vl += this.data[1] << 48;
                return new JMo_Long(vl += this.data[0] << 56);
            }
        }
        throw Err.impossible(bytes);
    }

    public byte[] getValue() {
        return this.data;
    }

    private Str mToStr(CallRuntime cr, Charset cs) {
        cr.argsNone();
        return new Str(new String(this.data, cs));
    }

    @Override
    public String toString() {
        return String.valueOf(this.getTypeName()) + '<' + this.data.length + '>';
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: 
            case IDENT: {
                return this.toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTypeName());
        sb.append('[');
        byte[] byArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            sb.append("" + element);
            if (type == STYPE.DESCRIBE) {
                sb.append('b');
            }
            sb.append(",");
            ++n2;
        }
        Lib_Output.removeEnd(sb, ',');
        sb.append("]");
        return sb.toString();
    }

    @Override
    protected int sequenceSize() {
        return this.data.length;
    }

    @Override
    protected boolean sequenceEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof JMo_ByteArray) {
            byte[] other = ((JMo_ByteArray)obj).data;
            if (this.data.length != other.length) {
                return false;
            }
            int i = 0;
            while (i < this.data.length) {
                if (this.data[i] != other[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equalsLazy(Object obj) {
        return this.equals(obj);
    }

    @Override
    protected I_Object getFirst(CallRuntime cr) {
        return new JMo_Byte(this.data[0]);
    }

    @Override
    protected I_Object getLast(CallRuntime cr) {
        return new JMo_Byte(this.data[this.data.length - 1]);
    }

    @Override
    protected A_Sequence copy(CallRuntime cr) {
        int len = this.data.length;
        byte[] copy = new byte[len];
        System.arraycopy(this.data, 0, copy, 0, len);
        return new JMo_ByteArray(copy);
    }

    @Override
    protected I_Object mSequenceGetPull(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.argsVar(this, 1, 0);
        if (oa.length == 1) {
            I_Atomic oav = (I_Atomic)cr.argType(oa[0], I_Atomic.class);
            int oi = Lib_Convert.getIntValue(cr, oav);
            int pos = Lib_Sequence.realPos(cr, oi, this.data.length, lazy);
            return pos == -1 ? Nil.NIL : new JMo_Byte(this.data[pos - 1]);
        }
        return this.sequenceDeepGet(cr, oa, 0, lazy);
    }

    @Override
    protected void sequenceSet(CallRuntime cr, I_Object posObj, I_Object obj, boolean lazy) {
        int posWanted = Lib_Convert.getIntValue(cr, posObj);
        cr.argType(obj, JMo_Byte.class);
        byte value = Lib_Convert.getByteValue(cr, obj);
        if (lazy && Math.abs(posWanted) > this.data.length) {
            throw new RuntimeError(cr, "Fixed ByteArray can't expanded!", "");
        }
        int posReal = Lib_Sequence.realPos(cr, posWanted, this.data.length, lazy);
        Lib_Error.ifNotBetween(cr, 1, this.data.length, posReal, "position");
        this.data[posReal - 1] = value;
    }

    @Override
    protected void mSequenceSetPut(CallRuntime cr, boolean lazy) {
        I_Object[] oa = cr.args(this, JMo_Byte.class, I_Integer.class);
        this.sequenceSet(cr, oa[1], oa[0], lazy);
    }

    @Override
    protected I_Object sequenceSelectGet(CallRuntime cr, I_Object key, boolean lazy) {
        int oi = Lib_Convert.getIntValue(cr, key);
        int pos = Lib_Sequence.realPos(cr, oi, this.data.length, lazy);
        return pos == -1 ? Nil.NIL : new JMo_Byte(this.data[pos - 1]);
    }

    @Override
    public I_Object sequenceDeepGet(CallRuntime cr, I_Object[] keys, int offset, boolean lazy) {
        throw Err.invalid(keys, offset, lazy);
    }

    @Override
    public void sequenceDeepSet(CallRuntime cr, I_Object[] keys, int offset, I_Object value, boolean lazy) {
        throw Err.invalid(keys, offset, value, lazy);
    }

    @Override
    protected Collection<? extends I_Object> getInternalCollection() {
        throw Err.invalid(new Object[0]);
    }

    private JMo_ByteArray iCutCopy(CallRuntime cr, int start, int end) {
        Lib_Error.ifTooSmall(cr, start, end);
        int newLen = end - start + 1;
        byte[] result = new byte[newLen];
        System.arraycopy(this.data, start - 1, result, 0, newLen);
        return new JMo_ByteArray(result);
    }
}

