/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.pseudo;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.error.Err;
import org.jaymo_lang.error.CustomError;
import org.jaymo_lang.error.ErrorBaseDebug;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ErrorComposer;
import org.jaymo_lang.util.Lib_Output;

public class JMo_Error
extends A_Object {
    private final Throwable ex;
    private final ArgCallBuffer par1;
    private final ArgCallBuffer par2;

    public JMo_Error(Call par1, Call par2) {
        this.ex = new Throwable();
        this.par1 = new ArgCallBuffer(0, par1);
        this.par2 = new ArgCallBuffer(1, par2);
    }

    public JMo_Error(Throwable t) {
        this.ex = t;
        this.par1 = null;
        this.par2 = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.par1 != null) {
            this.par1.init(cr, this, Str.class);
        }
        if (this.par2 != null) {
            this.par2.init(cr, this, Str.class);
        }
    }

    public I_Object mShow(CallRuntime cr) {
        cr.argsNone();
        String s = new ErrorComposer(this.ex, cr, this.iGetMessage()).compose();
        Lib_Output.out(cr.getApp(), s, true);
        return this;
    }

    @Override
    public String toString() {
        return this.toString(null, STYPE.REGULAR);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        switch (type) {
            case NESTED: 
            case IDENT: {
                String group = this.par1 != null && this.par2 != null ? CustomError.class.getSimpleName() : this.ex.getClass().getSimpleName();
                return group;
            }
            case REGULAR: {
                if (this.par1 != null && this.par2 != null) {
                    if (cr == null) {
                        return "Error[" + this.par1.toString() + "," + this.par2.toString() + ']';
                    }
                    return "Error[" + this.par1.toString(cr, STYPE.IDENT) + "," + this.par2.toString(cr, STYPE.IDENT) + ']';
                }
                if (this.ex instanceof ErrorBaseDebug) {
                    ErrorBaseDebug ebd = (ErrorBaseDebug)this.ex;
                    String result = "Error[\"" + this.iGetMessage() + '\"';
                    result = String.valueOf(result) + ",\"" + ebd.getDetail() + '\"';
                    result = String.valueOf(result) + ",\"" + ebd.getSource() + '\"';
                    return String.valueOf(result) + ']';
                }
                return this.toString();
            }
            case DESCRIBE: {
                StringBuilder sb = new StringBuilder();
                sb.append(this.getTypeName());
                if (this.par1 != null && this.par2 != null) {
                    sb.append('[');
                    sb.append(this.par1.toString(cr, STYPE.DESCRIBE));
                    sb.append(',');
                    sb.append(this.par2.toString(cr, STYPE.DESCRIBE));
                    sb.append(']');
                } else if (this.ex instanceof ErrorBaseDebug) {
                    ErrorBaseDebug ebd = (ErrorBaseDebug)this.ex;
                    sb.append("[\"" + this.iGetMessage() + '\"');
                    sb.append(",\"" + ebd.getDetail() + '\"');
                    sb.append(",\"" + ebd.getSource() + '\"');
                    sb.append(']');
                }
                return sb.toString();
            }
        }
        throw Err.impossible(new Object[]{type});
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        switch (method) {
            case "throw": {
                this.mThrow(cr);
                return new ObjectCallResult(Nil.NIL, true);
            }
            case "show": {
                return A_Object.stdResult(this.mShow(cr));
            }
            case "message": {
                cr.argsNone();
                return A_Object.stdResult(new Str(this.iGetMessage()));
            }
            case "source": {
                return this.mErrorBaseDebug(cr, EBD.SOURCE);
            }
            case "call": {
                return this.mErrorBaseDebug(cr, EBD.CALL);
            }
            case "detail": {
                return this.mErrorBaseDebug(cr, EBD.DETAIL);
            }
            case "instance": {
                return this.mErrorBaseDebug(cr, EBD.INSTANCE);
            }
            case "group": {
                return this.mErrorBaseDebug(cr, EBD.GROUP);
            }
            case "file": {
                return A_Object.stdResult(this.mFileLine(cr, true));
            }
            case "line": {
                return A_Object.stdResult(this.mFileLine(cr, false));
            }
            case "info": {
                return A_Object.stdResult(this.mInfo(cr));
            }
        }
        return null;
    }

    private String iErrorBaseDebugText(CallRuntime cr, EBD source) {
        if (!(this.ex instanceof ErrorBaseDebug)) {
            return null;
        }
        String s = null;
        ErrorBaseDebug ebd = (ErrorBaseDebug)this.ex;
        switch (source) {
            case SOURCE: {
                s = ebd.getSource();
                break;
            }
            case CALL: {
                s = ebd.getCall();
                break;
            }
            case DETAIL: {
                s = ebd.getDetail();
                break;
            }
            case INSTANCE: {
                s = ebd.getInstance();
                break;
            }
            case GROUP: {
                s = this.ex.getClass().getSimpleName();
                break;
            }
            default: {
                Err.impossible(new Object[]{source});
            }
        }
        return s;
    }

    private String iGetMessage() {
        return this.par1 != null ? ((Str)this.par1.get()).getValue() : this.ex.getMessage();
    }

    private ObjectCallResult mErrorBaseDebug(CallRuntime cr, EBD source) {
        cr.argsNone();
        String value = this.iErrorBaseDebugText(cr, source);
        return A_Object.stdResult(value == null ? Nil.NIL : new Str(value));
    }

    private I_Object mFileLine(CallRuntime cr, boolean useFile) {
        cr.argsNone();
        if (!(this.ex instanceof ErrorBaseDebug)) {
            return Nil.NIL;
        }
        String source = ((ErrorBaseDebug)this.ex).getSource();
        if (useFile) {
            String file = FilterString.to(":", true, source);
            if (file.length() > 0 && file.charAt(file.length() - 1) == ':') {
                file = file.substring(0, file.length() - 1);
            }
            return new Str(file);
        }
        String line = FilterString.right(":", source);
        if (line.length() > 0 && line.charAt(0) == ':') {
            line = line.substring(1);
        }
        return line.length() == 0 ? Nil.NIL : new Int(Integer.parseInt(line));
    }

    private I_Object mInfo(CallRuntime cr) {
        cr.argsNone();
        String result = this.iGetMessage();
        String value = this.iErrorBaseDebugText(cr, EBD.DETAIL);
        if (value != null) {
            result = String.valueOf(result) + " | " + value;
        }
        result = String.valueOf(result) + " | " + this.iErrorBaseDebugText(cr, EBD.SOURCE);
        return new Str(result);
    }

    private void mThrow(CallRuntime cr) {
        cr.argsNone();
        if (this.par1 != null && this.par2 != null) {
            throw new CustomError(cr, Lib_String.unquote(this.par1.toString(cr, STYPE.REGULAR)), Lib_String.unquote(this.par2.toString(cr, STYPE.REGULAR)));
        }
        throw new CustomError(cr, "Thrown again", this.toString(cr, STYPE.REGULAR));
    }

    private static enum EBD {
        SOURCE,
        CALL,
        DETAIL,
        INSTANCE,
        GROUP;

    }
}

