/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_DateTime;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.Lib_DateTime;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.A_DateTimeBase;
import org.jaymo_lang.object.immute.datetime.JMo_Date;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Type;

public class JMo_DateTime
extends A_DateTimeBase {
    private I_DateTime datetime;
    private final ArgCallBuffer[] init;

    public JMo_DateTime(I_DateTime datetime) {
        this.init = null;
        this.datetime = datetime;
    }

    public JMo_DateTime() {
        this.init = null;
        this.datetime = null;
    }

    public JMo_DateTime(Call arg) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, arg)};
        this.datetime = null;
    }

    public JMo_DateTime(Call date, Call time) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, date), new ArgCallBuffer(1, time)};
    }

    public JMo_DateTime(Call y, Call m, Call d) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, y), new ArgCallBuffer(1, m), new ArgCallBuffer(2, d)};
    }

    public JMo_DateTime(Call y, Call m, Call d, Call hh, Call mm, Call ss) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, y), new ArgCallBuffer(1, m), new ArgCallBuffer(2, d), new ArgCallBuffer(3, hh), new ArgCallBuffer(4, mm), new ArgCallBuffer(5, ss)};
    }

    public JMo_DateTime(Call y, Call m, Call d, Call hh, Call mm, Call ss, Call nn) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, y), new ArgCallBuffer(1, m), new ArgCallBuffer(2, d), new ArgCallBuffer(3, hh), new ArgCallBuffer(4, mm), new ArgCallBuffer(5, ss), new ArgCallBuffer(6, nn)};
        this.datetime = null;
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.init == null) {
            if (this.datetime == null) {
                this.datetime = new MDateTime();
            }
            return;
        }
        int argsLen = this.init.length;
        if (argsLen == 1) {
            I_Object o = this.init[0].initExt(cr, this, A_IntNumber.class, Str.class);
            try {
                if (o instanceof A_IntNumber) {
                    long ms = Lib_Convert.getLongValue(cr, o);
                    this.datetime = new MDateTime(ms);
                } else {
                    String s = Lib_Convert.getStringValue(cr, o);
                    this.datetime = new MDateTime(s);
                }
            }
            catch (Err_Runtime err) {
                throw new RuntimeError(cr, "Can't create DateTime-Object", String.valueOf(err.getMessage()) + " Got: DateTime(" + o.toString(cr, STYPE.IDENT) + ")");
            }
            return;
        }
        if (argsLen == 2) {
            JMo_Date d = this.init[0].init(cr, this, JMo_Date.class);
            JMo_Time t = this.init[1].init(cr, this, JMo_Time.class);
            try {
                this.datetime = new MDateTime(d.getInternalDate(), t.getInternalTime());
            }
            catch (Err_Runtime err) {
                throw new RuntimeError(cr, "Can't create DateTime-Object", String.valueOf(err.getMessage()) + " Got: DateTime(" + d.toString() + "," + t.toString() + ")");
            }
            return;
        }
        int iy = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, A_IntNumber.class));
        int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, A_IntNumber.class));
        int id = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, A_IntNumber.class));
        int ihh = argsLen < 4 ? 0 : Lib_Convert.getIntValue(cr, this.init[3].init(cr, this, A_IntNumber.class));
        int imm = argsLen < 5 ? 0 : Lib_Convert.getIntValue(cr, this.init[4].init(cr, this, A_IntNumber.class));
        int iss = argsLen < 6 ? 0 : Lib_Convert.getIntValue(cr, this.init[5].init(cr, this, A_IntNumber.class));
        int inn = argsLen < 7 ? 0 : Lib_Convert.getIntValue(cr, this.init[6].init(cr, this, A_IntNumber.class));
        try {
            this.datetime = new MDateTime(iy, im, id, ihh, imm, iss, inn);
        }
        catch (Err_Runtime err) {
            throw new RuntimeError(cr, "Invalid datetime", "DateTime(" + iy + "," + im + "," + id + "," + ihh + "," + imm + "," + iss + ")");
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getYear": {
                return A_Object.stdResult(this.mGetYear(cr));
            }
            case "getMonth": {
                return A_Object.stdResult(this.mGetMonth(cr));
            }
            case "getDay": {
                return A_Object.stdResult(this.mGetDay(cr));
            }
            case "getHour": 
            case "getHours": {
                return A_Object.stdResult(this.mGetHours(cr));
            }
            case "getMin": 
            case "getMinutes": {
                return A_Object.stdResult(this.mGetMinutes(cr));
            }
            case "getSeconds": 
            case "getSec": {
                return A_Object.stdResult(this.mGetSeconds(cr));
            }
            case "dayOfWeek": 
            case "weekDay": {
                return A_Object.stdResult(this.mDayOfWeek(cr));
            }
            case "addTime": {
                return A_Object.stdResult(this.mAddSubTime(cr, true));
            }
            case "addSec": 
            case "addSeconds": {
                return A_Object.stdResult(this.mAddSubSeconds(cr, true));
            }
            case "addMin": 
            case "addMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, true));
            }
            case "addHours": 
            case "addHour": {
                return A_Object.stdResult(this.mAddSubHours(cr, true));
            }
            case "addDay": 
            case "addDays": {
                return A_Object.stdResult(this.mAddSubDays(cr, true));
            }
            case "addMonth": 
            case "addMonths": {
                return A_Object.stdResult(this.mAddSubMonths(cr, true));
            }
            case "addYears": 
            case "addYear": {
                return A_Object.stdResult(this.mAddSubYears(cr, true));
            }
            case "subTime": {
                return A_Object.stdResult(this.mAddSubTime(cr, false));
            }
            case "subSec": 
            case "subSeconds": {
                return A_Object.stdResult(this.mAddSubSeconds(cr, false));
            }
            case "subMin": 
            case "subMinutes": {
                return A_Object.stdResult(this.mAddSubMinutes(cr, false));
            }
            case "subHours": 
            case "subHour": {
                return A_Object.stdResult(this.mAddSubHours(cr, false));
            }
            case "subDays": 
            case "subDay": {
                return A_Object.stdResult(this.mAddSubDays(cr, false));
            }
            case "subMonth": 
            case "subMonths": {
                return A_Object.stdResult(this.mAddSubMonths(cr, false));
            }
            case "subYears": 
            case "subYear": {
                return A_Object.stdResult(this.mAddSubYears(cr, false));
            }
            case "setDay": {
                return A_Object.stdResult(this.mSetDay(cr));
            }
            case "setMonth": {
                return A_Object.stdResult(this.mSetMonth(cr));
            }
            case "setYear": {
                return A_Object.stdResult(this.mSetYear(cr));
            }
            case "setHour": {
                return A_Object.stdResult(this.mSetHour(cr));
            }
            case "setMinute": {
                return A_Object.stdResult(this.mSetMinute(cr));
            }
            case "setSecond": {
                return A_Object.stdResult(this.mSetSecond(cr));
            }
            case "date": {
                return A_Object.stdResult(this.mDate(cr));
            }
            case "time": {
                return A_Object.stdResult(this.mTime(cr));
            }
            case "diffDays": {
                return A_Object.stdResult(this.mDiffDays(cr));
            }
            case "diffHours": {
                return A_Object.stdResult(this.mDiffHours(cr));
            }
            case "diffMinutes": {
                return A_Object.stdResult(this.mDiffMinutes(cr));
            }
            case "diffSeconds": {
                return A_Object.stdResult(this.mDiffSeconds(cr));
            }
            case "diffMSec": 
            case "diff": 
            case "diffMilliSeconds": {
                return A_Object.stdResult(this.mDiffMilliSeconds(cr));
            }
        }
        return null;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (this.datetime == null) {
            return Lib_Type.getName(this);
        }
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.datetime.toStringShort();
            }
        }
        return String.valueOf(Lib_Type.getName(this)) + "(\"" + this.datetime.toString() + "\")";
    }

    @Override
    public String toStringFull() {
        if (this.datetime == null) {
            return Lib_Type.getName(this);
        }
        return this.datetime.toString();
    }

    @Override
    protected boolean[] mCompare2(CallRuntime cr) {
        JMo_DateTime d = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        boolean isEqual = this.datetime.isEqual(d.getInternalDateTime());
        boolean isGreater = this.datetime.isGreater(d.getInternalDateTime());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_DateTime ? this.datetime.isEqual(((JMo_DateTime)arg).getInternalDateTime()) : false;
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            switch (s.length()) {
                case 19: {
                    return s.equals(this.datetime.toStringShort()) || s.equals(this.datetime.toStringDE());
                }
                case 23: {
                    return s.equals(this.datetime.toString());
                }
            }
            return false;
        }
        return this.equals(other);
    }

    private Int mDiffDays(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        int diff = this.datetime.diffDays(arg.getInternalDateTime());
        return new Int(diff);
    }

    private JMo_Long mDiffMilliSeconds(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        long diff = this.datetime.diffMilliSeconds(arg.getInternalDateTime());
        return new JMo_Long(diff);
    }

    private JMo_Long mDiffSeconds(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        long diff = this.datetime.diffSeconds(arg.getInternalDateTime());
        return new JMo_Long(diff);
    }

    private JMo_Long mDiffMinutes(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        long diff = this.datetime.diffMinutes(arg.getInternalDateTime());
        return new JMo_Long(diff);
    }

    private JMo_Long mDiffHours(CallRuntime cr) {
        JMo_DateTime arg = (JMo_DateTime)cr.args(this, JMo_DateTime.class)[0];
        long diff = this.datetime.diffHours(arg.getInternalDateTime());
        return new JMo_Long(diff);
    }

    private Int mGetDay(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getDay());
    }

    private Int mGetMonth(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getMonth());
    }

    private Int mGetYear(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getYear());
    }

    private Int mGetSeconds(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getSeconds());
    }

    private Int mGetMinutes(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getMinutes());
    }

    private Int mGetHours(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.datetime.getHours());
    }

    private Int mDayOfWeek(CallRuntime cr) {
        cr.argsNone();
        int dow = this.datetime.getDayOfWeek();
        if (dow == 0) {
            dow = 7;
        }
        return new Int(dow);
    }

    private JMo_Date mDate(CallRuntime cr) {
        cr.argsNone();
        return new JMo_Date(this.datetime.getDate());
    }

    private JMo_Time mTime(CallRuntime cr) {
        cr.argsNone();
        return new JMo_Time(this.datetime.getTime());
    }

    private I_Object mAddSubSeconds(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int val = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            val = -val;
        }
        I_DateTime date2 = this.datetime.getAddSeconds(val);
        return new JMo_DateTime(date2);
    }

    private I_Object mAddSubTime(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, JMo_Time.class)[0];
        long val = ((JMo_Time)arg).getInternalTime().getValueMilliSeconds();
        if (!add) {
            val = -val;
        }
        I_DateTime date2 = this.datetime.getAddMilliSeconds(val);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddSubMinutes(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_DateTime date2 = this.datetime.getAddMinutes(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddSubHours(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_DateTime date2 = this.datetime.getAddHours(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddSubDays(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_DateTime date2 = this.datetime.getAddDays(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddSubMonths(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_DateTime date2 = this.datetime.getAddMonths(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mAddSubYears(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_DateTime date2 = this.datetime.getAddYears(pari);
        return new JMo_DateTime(date2);
    }

    private JMo_DateTime mSetDay(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetDay(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetMonth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMonth(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetYear(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetYear(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetHour(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetHour(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetMinute(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetMinute(pari);
        return new JMo_DateTime(dt2);
    }

    private JMo_DateTime mSetSecond(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_DateTime dt2 = this.datetime.getSetSecond(pari);
        return new JMo_DateTime(dt2);
    }

    @Override
    protected A_DateTimeBase incdec2(boolean inc, int amount) {
        if (inc) {
            I_DateTime date2 = this.datetime.getAddSeconds(amount);
            return new JMo_DateTime(date2);
        }
        I_DateTime date2 = this.datetime.getAddSeconds(-amount);
        return new JMo_DateTime(date2);
    }

    @Override
    protected JMo_DateTime mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_DateTime.class, JMo_DateTime.class);
        I_DateTime min = ((JMo_DateTime)args[0]).datetime;
        I_DateTime max = ((JMo_DateTime)args[1]).datetime;
        if (this.datetime.isGreater(max)) {
            return (JMo_DateTime)args[1];
        }
        if (min.isGreater(this.datetime)) {
            return (JMo_DateTime)args[0];
        }
        return this;
    }

    @Override
    protected I_Object mStyle(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.argsNone();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "DD.MM.YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "DD/MM/YYYY hh:mm:ss", this.getInternalDate(), this.getInternalTime());
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "M/DD/YYYY i:mm:ss p", this.getInternalDate(), this.getInternalTime());
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    protected I_DateTime getInternalDateTime() {
        return this.datetime;
    }

    @Override
    protected I_Date getInternalDate() {
        return this.datetime.getDate();
    }

    @Override
    protected I_Time getInternalTime() {
        return this.datetime.getTime();
    }

    @Override
    protected I_Object pAddSub(CallRuntime cr, A_Number arg, boolean add) {
        double d = Lib_Convert.getDoubleValue(cr, arg);
        if (!add) {
            d = -d;
        }
        long ms = Lib_DateTime.toMilliSec(d);
        I_DateTime dt2 = this.datetime.getAddMilliSeconds(ms);
        return new JMo_DateTime(dt2);
    }

    @Override
    protected JMo_Long pToMilliSeconds() {
        return new JMo_Long(this.datetime.getValueMilliSeconds());
    }
}

