/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.immute.datetime;

import de.mn77.base.data.type.datetime.I_Date;
import de.mn77.base.data.type.datetime.I_Time;
import de.mn77.base.data.type.datetime.MDate;
import de.mn77.base.data.type.datetime.MDateTime;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_Runtime;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.ArgCallBuffer;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_IntNumber;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.object.immute.datetime.A_DateTimeBase;
import org.jaymo_lang.object.immute.datetime.JMo_DateTime;
import org.jaymo_lang.object.immute.datetime.JMo_Time;
import org.jaymo_lang.object.immute.datetime.Lib_DateTime_Format;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Error;
import org.jaymo_lang.util.Lib_Type;

public class JMo_Date
extends A_DateTimeBase {
    private I_Date date = null;
    private final ArgCallBuffer[] init;

    public JMo_Date(I_Date date) {
        this.init = null;
        this.date = date;
    }

    public JMo_Date() {
        this.init = null;
    }

    public JMo_Date(Call str) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, str)};
    }

    public JMo_Date(Call y, Call m, Call d) {
        this.init = new ArgCallBuffer[]{new ArgCallBuffer(0, y), new ArgCallBuffer(0, m), new ArgCallBuffer(0, d)};
    }

    @Override
    public void init(CallRuntime cr) {
        if (this.date != null) {
            return;
        }
        if (this.init == null) {
            this.date = new MDate();
        } else if (this.init.length == 1) {
            I_Object o = this.init[0].initExt(cr, this, A_IntNumber.class, Str.class);
            try {
                if (o instanceof A_IntNumber) {
                    long ms = Lib_Convert.getLongValue(cr, o);
                    this.date = new MDate(ms);
                }
                String s = Lib_Convert.getStringValue(cr, o);
                this.date = new MDate(s);
            }
            catch (Err_Runtime err) {
                throw new RuntimeError(cr, "Can't create Date-Object", String.valueOf(err.getMessage()) + " Got: Date(" + o.toString(cr, STYPE.IDENT) + ")");
            }
        } else {
            int iy = Lib_Convert.getIntValue(cr, this.init[0].init(cr, this, Int.class));
            Lib_Error.ifNotBetween(cr, 0, 2500, iy, "Year");
            int im = Lib_Convert.getIntValue(cr, this.init[1].init(cr, this, Int.class));
            Lib_Error.ifNotBetween(cr, 1, 12, im, "Month");
            int id = Lib_Convert.getIntValue(cr, this.init[2].init(cr, this, Int.class));
            Lib_Error.ifNotBetween(cr, 1, 31, id, "Day");
            try {
                this.date = new MDate(iy, im, id);
            }
            catch (Err_Runtime err) {
                throw new RuntimeError(cr, err.getMessage(), "Date(" + iy + "," + im + "," + id + ")");
            }
        }
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "getYear": {
                return A_Object.stdResult(this.mYear(cr));
            }
            case "getMonth": {
                return A_Object.stdResult(this.mMonth(cr));
            }
            case "getDay": {
                return A_Object.stdResult(this.mDay(cr));
            }
            case "dayOfWeek": 
            case "weekDay": {
                return A_Object.stdResult(this.mDayOfWeek(cr));
            }
            case "addDay": 
            case "addDays": {
                return A_Object.stdResult(this.mAddSubDays(cr, true));
            }
            case "addMonth": 
            case "addMonths": {
                return A_Object.stdResult(this.mAddSubMonths(cr, true));
            }
            case "addYears": 
            case "addYear": {
                return A_Object.stdResult(this.mAddSubYears(cr, true));
            }
            case "subDays": 
            case "subDay": {
                return A_Object.stdResult(this.mAddSubDays(cr, false));
            }
            case "subMonth": 
            case "subMonths": {
                return A_Object.stdResult(this.mAddSubMonths(cr, false));
            }
            case "subYears": 
            case "subYear": {
                return A_Object.stdResult(this.mAddSubYears(cr, false));
            }
            case "setDay": {
                return A_Object.stdResult(this.mSetDay(cr));
            }
            case "setMonth": {
                return A_Object.stdResult(this.mSetMonth(cr));
            }
            case "setYear": {
                return A_Object.stdResult(this.mSetYear(cr));
            }
            case "combine": {
                return A_Object.stdResult(this.mCombine(cr));
            }
            case "diffDays": 
            case "diff": {
                return A_Object.stdResult(this.mDiffDays(cr));
            }
            case "diffMonths": {
                return A_Object.stdResult(this.mDiffMonths(cr));
            }
            case "diffYears": {
                return A_Object.stdResult(this.mDiffYears(cr));
            }
        }
        return null;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (this.date == null) {
            return "Date";
        }
        switch (type) {
            case REGULAR: 
            case NESTED: {
                return this.date.toString();
            }
        }
        return String.valueOf(Lib_Type.getName(this)) + "(\"" + this.date.toString() + "\")";
    }

    @Override
    public String toStringFull() {
        return this.toString(null, STYPE.REGULAR);
    }

    @Override
    public boolean equalsLazy(Object other) {
        if (other instanceof Str) {
            String s = ((Str)other).getValue();
            return s.equals(this.date.toString()) || s.equals(this.date.toStringDE());
        }
        return this.equals(other);
    }

    @Override
    protected boolean[] mCompare2(CallRuntime cr) {
        JMo_Date d = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        boolean isEqual = this.date.isEqual(d.getInternalValue());
        boolean isGreater = this.date.isGreater(d.getInternalValue());
        return new boolean[]{isEqual, isGreater};
    }

    @Override
    public boolean equals(Object arg) {
        return arg instanceof JMo_Date ? this.date.isEqual(((JMo_Date)arg).getInternalValue()) : false;
    }

    private Int mDiffDays(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffDays(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffMonths(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffMonths(arg.getInternalValue());
        return new Int(diff);
    }

    private Int mDiffYears(CallRuntime cr) {
        JMo_Date arg = (JMo_Date)cr.args(this, JMo_Date.class)[0];
        int diff = this.date.diffYears(arg.getInternalValue());
        return new Int(diff);
    }

    @Override
    protected A_DateTimeBase incdec2(boolean inc, int amount) {
        if (inc) {
            I_Date date2 = this.date.getAddDays(amount);
            return new JMo_Date(date2);
        }
        I_Date date2 = this.date.getAddDays(-amount);
        return new JMo_Date(date2);
    }

    @Override
    protected I_Object pAddSub(CallRuntime cr, A_Number num, boolean add) {
        int pari = Lib_Convert.getIntValue(cr, num);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddDays(pari);
        return new JMo_Date(date2);
    }

    @Override
    protected JMo_Date mLimit(CallRuntime cr) {
        I_Object[] args = cr.args(this, JMo_Date.class, JMo_Date.class);
        I_Date min = ((JMo_Date)args[0]).date;
        I_Date max = ((JMo_Date)args[1]).date;
        if (this.date.isGreater(max)) {
            return (JMo_Date)args[1];
        }
        if (min.isGreater(this.date)) {
            return (JMo_Date)args[0];
        }
        return this;
    }

    private Int mDay(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.date.getDay());
    }

    private Int mMonth(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.date.getMonth());
    }

    private Int mYear(CallRuntime cr) {
        cr.argsNone();
        return new Int(this.date.getYear());
    }

    private Int mDayOfWeek(CallRuntime cr) {
        cr.argsNone();
        int dow = this.date.getDayOfWeek();
        if (dow == 0) {
            dow = 7;
        }
        return new Int(dow);
    }

    private I_Object mCombine(CallRuntime cr) {
        I_Object arg = cr.args(this, JMo_Time.class)[0];
        MDateTime dt = new MDateTime(this.date, ((JMo_Time)arg).getInternalTime());
        return new JMo_DateTime(dt);
    }

    private I_Object mAddSubDays(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddDays(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date mAddSubMonths(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddMonths(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date mAddSubYears(CallRuntime cr, boolean add) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        if (!add) {
            pari = -pari;
        }
        I_Date date2 = this.date.getAddYears(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date mSetDay(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetDay(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date mSetMonth(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetMonth(pari);
        return new JMo_Date(date2);
    }

    private JMo_Date mSetYear(CallRuntime cr) {
        I_Object arg = cr.args(this, A_IntNumber.class)[0];
        int pari = Lib_Convert.getIntValue(cr, arg);
        I_Date date2 = this.date.getSetYear(pari);
        return new JMo_Date(date2);
    }

    @Override
    protected I_Object mStyle(CallRuntime cr, A_DateTimeBase.COUNTRY country) {
        cr.argsNone();
        switch (country) {
            case DE: {
                return Lib_DateTime_Format.format(cr, "DD.MM.YYYY", this.getInternalDate(), null);
            }
            case EN: {
                return Lib_DateTime_Format.format(cr, "DD/MM/YYYY", this.getInternalDate(), null);
            }
            case US: {
                return Lib_DateTime_Format.format(cr, "M/DD/YYYY", this.getInternalDate(), null);
            }
        }
        throw Err.impossible(new Object[]{country});
    }

    private I_Date getInternalValue() {
        return this.date;
    }

    @Override
    protected I_Date getInternalDate() {
        return this.date;
    }

    @Override
    protected I_Time getInternalTime() {
        return null;
    }

    @Override
    protected JMo_Long pToMilliSeconds() {
        return new JMo_Long(this.date.getValueMilliSeconds());
    }
}

