/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.ReturnException;
import org.jaymo_lang.error.RuntimeError;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.ConstManager;
import org.jaymo_lang.model.Function;
import org.jaymo_lang.model.FunctionPar;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.model.Type;
import org.jaymo_lang.model.VarManager;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.immute.Nil;
import org.jaymo_lang.object.magic.var.MV_THIS;
import org.jaymo_lang.object.passthrough.Const;
import org.jaymo_lang.object.passthrough.I_VarConst;
import org.jaymo_lang.object.passthrough.Var;
import org.jaymo_lang.object.pseudo.NonAtomic;
import org.jaymo_lang.object.pseudo.Return;
import org.jaymo_lang.object.pseudo.VarLet;
import org.jaymo_lang.object.struct.JMo_List;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.Instance;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_MagicVar;
import org.jaymo_lang.util.Lib_Output;
import org.jaymo_lang.util.Lib_Type;

public class Block
extends A_Object {
    private static int counter = 0;
    private final int nr;
    private ArrayList<Call> items = null;
    private final Block parent;
    private final Function func;
    private final Type typ;
    private final VarManager vars;
    private final ConstManager consts;

    public Block(Type typ) {
        this(typ, null, null);
    }

    public Block(Type typ, Function func, Block parent) {
        this.typ = typ;
        this.func = func;
        this.parent = parent;
        this.nr = ++counter;
        this.vars = new VarManager(parent == null ? null : parent.getVarManager());
        this.consts = new ConstManager(parent == null ? null : parent.getConstManager());
    }

    @Override
    public void init(CallRuntime cr) {
    }

    @Override
    protected ObjectCallResult call2(CallRuntime cr, String method) {
        throw Err.forbidden(cr);
    }

    public final void add(Call m) {
        Err.ifNull(m);
        if (this.items == null) {
            this.items = new ArrayList();
        }
        this.items.add(m);
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        if (type != STYPE.DESCRIBE) {
            return "Block_" + this.nr;
        }
        StringBuilder sb = new StringBuilder();
        if (this.vars != null) {
            sb.append(Lib_Output.appShowPart("Variables:", this.vars.toString(cr, STYPE.DESCRIBE)));
            sb.append('\n');
        }
        if (this.consts != null && this.consts.getCount() > 0) {
            sb.append(Lib_Output.appShowPart("Constants:", this.consts.toString(cr, STYPE.DESCRIBE)));
            sb.append('\n');
        }
        if (this.items != null) {
            StringBuilder sbi = new StringBuilder();
            for (Call c : this.items) {
                String s = c.toString(cr, STYPE.DESCRIBE);
                sbi.append(String.valueOf(s) + '\n');
            }
            sb.append(Lib_Output.appShowPart("Calls:", sbi.toString()));
        }
        Lib_Output.removeEnd(sb, '\n');
        return Lib_Output.appShowPart(this.toString(cr, STYPE.IDENT), sb.toString());
    }

    public final I_Object execAppRoot(CallRuntime cr) throws ReturnException {
        return this.iExec(cr, null, true);
    }

    public final I_Object exec(CallRuntime cr, I_Object blockIT) throws ReturnException {
        cr = cr.copyCall(cr.call, true);
        return this.iExec(cr, blockIT, false);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, I_Object[] args) {
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), args);
    }

    public void reInit(CallRuntime crOut, CallRuntime crIn, int parsGiven, int parToInit, I_Object parValue) {
        I_Object[] args = new I_Object[parsGiven];
        args[parToInit - 1] = parValue;
        this.initPars(crOut, crIn, crIn.instance.getType().getVars(), args);
    }

    public I_Object execOverwrite(CallRuntime cr, Instance instance, Function f) {
        CallRuntime crInside = cr.copyVCE(instance, instance.getMainEnv(), true);
        if (f.hasControl()) {
            throw new CodeError(crInside, "Invalid function overwrite", "Function has control-functionality: " + f.getNames()[0]);
        }
        try {
            return f.getBlock().execFunction(cr, crInside, f);
        }
        catch (ReturnException e) {
            if (e.get().getLevel() != Return.LEVEL.RETURN) {
                throw new RuntimeError(crInside, "Invalid return from overwritten function!", "Function " + f.toString(crInside, STYPE.IDENT) + " returns " + (Object)((Object)e.get().getLevel()));
            }
            return e.get().getResult();
        }
    }

    public I_Object execFunction(CallRuntime crOutside, CallRuntime crInside, Function f) throws ReturnException {
        String fReturnType;
        boolean throw_return;
        I_Object checkValue;
        I_Object returnValue;
        CallRuntime crNew;
        block15: {
            if (!f.hasControl() && crInside.hasBlock()) {
                throw new CodeError(crInside, "No Block allowed", "Function has no control functionality: " + crInside.call.toString());
            }
            crNew = crInside.copyFunction(crOutside);
            if (!f.hasControl()) {
                this.initPars(crOutside, crNew, f.getVars(), crOutside.getArgs(null));
            } else {
                crNew.vce.setFuncInit(this, crOutside, crNew, f.getVars());
            }
            returnValue = null;
            checkValue = null;
            throw_return = false;
            fReturnType = f.getReturnType();
            try {
                checkValue = returnValue = this.iExec(crNew, Nil.NIL, false);
            }
            catch (ReturnException e) {
                Return r = e.get();
                returnValue = r;
                checkValue = r.getResult();
                throw_return = true;
                if (r.getLevel() == Return.LEVEL.RETURN) break block15;
                Err.todo(r);
            }
        }
        if (checkValue == null) {
            returnValue = Nil.NIL;
            checkValue = Nil.NIL;
        }
        if (fReturnType != null) {
            if (fReturnType.equals("Same")) {
                if (throw_return && checkValue != Nil.NIL && !(checkValue instanceof MV_THIS) && !(checkValue instanceof Instance)) {
                    throw new CodeError(crNew, "Invalid value for return type 'Same'", "Got " + Lib_Type.getTypeString(checkValue.getClass(), checkValue) + ", need '" + "this" + "'");
                }
                Instance newValue = crNew.instance;
                returnValue = throw_return ? new Return(((Return)returnValue).getLevel(), newValue) : newValue;
            } else {
                String resultType = Lib_Type.getTypeString(checkValue.getClass(), checkValue);
                String wantedType = fReturnType;
                if (!Lib_Type.isInstanceOf(checkValue, wantedType)) {
                    if (resultType.equals("<Nil>")) {
                        if (!f.getReturnNil()) {
                            throw new CodeError(crNew, "Invalid return value", "Return value of function is nil");
                        }
                    } else {
                        throw new CodeError(crNew, "Invalid return type", "Got " + resultType + ", need <" + wantedType + ">");
                    }
                }
            }
        }
        if (throw_return) {
            throw new ReturnException((Return)returnValue);
        }
        return returnValue;
    }

    public void initTypeBlock(CallRuntime cpOutside, CallRuntime cpInside, I_Object[] args) {
        this.initPars(cpOutside, cpInside, cpInside.instance.getType().getVars(), args);
    }

    public void execTypeBlock(CallRuntime cr) {
        try {
            this.iExec(cr, null, false);
        }
        catch (ReturnException e) {
            throw new CodeError(cr, "Invalid condition", "'" + e.get().toString() + "' in Type-Body is forbidden.");
        }
    }

    public ConstManager getConstManager() {
        return this.consts;
    }

    public Function getFunction(CallRuntime cr) {
        return this.func;
    }

    public Collection<Call> getItems() {
        return this.items;
    }

    public Block getParent() {
        return this.parent;
    }

    public Type getType() {
        return this.typ;
    }

    public boolean isEmpty() {
        return this.items == null || this.items.size() == 0;
    }

    public VarManager getVarManager() {
        return this.vars;
    }

    private final I_Object iExec(CallRuntime cr, I_Object blockIT, boolean returnLast) throws ReturnException {
        Var var = new Var("it??");
        cr.vce.vars.set(cr, var, blockIT == null ? Nil.NIL : blockIT, false, true, false);
        if (cr.call != null && cr.call.getBlockStore() != null) {
            I_VarConst vc = cr.call.getBlockStore();
            if (vc instanceof Var) {
                ((Var)vc).let(cr, cr, blockIT);
            } else {
                ((Const)vc).set(cr, cr, blockIT);
            }
        }
        if (this.items == null) {
            return null;
        }
        I_Object last_result = null;
        for (Call c : this.items) {
            I_Object result;
            CallRuntime crCall = cr.copyBlockItem(c);
            last_result = result = crCall.exec(blockIT, false);
            if (!(result instanceof Return)) continue;
            throw new ReturnException((Return)result);
        }
        return returnLast ? last_result : cr.vce.vars.get(cr, var);
    }

    public void initPars(CallRuntime crOld, CallRuntime crNew, FunctionPar[] pars, I_Object[] args) {
        block24: {
            int fDefaults;
            boolean hasVarArgs;
            int argsLen = args == null ? 0 : args.length;
            int parsLen = pars == null ? 0 : pars.length;
            boolean bl = hasVarArgs = this.func != null && this.func.isVarArgs() || this.func == null && this.typ != null && this.typ.isVarArgs();
            int n = this.func != null ? this.func.getDefaultArgs() : (fDefaults = this.typ != null ? this.typ.getDefaultArgs() : 0);
            if (argsLen > parsLen && !hasVarArgs) {
                throw new CodeError(crOld, "Too much arguments", "Got " + argsLen + ", need " + parsLen + " argument(s).");
            }
            int parsNeeded = parsLen - fDefaults - (hasVarArgs ? 1 : 0);
            if (argsLen < parsNeeded) {
                throw new CodeError(crOld, "Missing argument or default value", "Got " + argsLen + ", need " + parsNeeded + " argument(s).");
            }
            if (pars == null) break block24;
            Err.ifNull(new Object[]{args});
            int offset = parsLen - argsLen;
            int i = parsLen - 1;
            while (i >= 0) {
                block28: {
                    I_Object arg;
                    boolean useVarArgs;
                    FunctionPar par;
                    block26: {
                        I_Object par1;
                        int parIdx;
                        block27: {
                            block25: {
                                boolean useDefault;
                                par = pars[i];
                                boolean bl2 = useDefault = offset > 0 && par.defaultValue != null;
                                if (useDefault) {
                                    --offset;
                                }
                                boolean bl3 = useVarArgs = hasVarArgs && i == parsLen - 1;
                                if (useVarArgs) {
                                    offset = argsLen >= parsLen - 1 ? 0 : --offset;
                                }
                                if ((parIdx = i - offset) < 0) {
                                    throw new CodeError(crOld, "Missing argument or default value", "Got " + argsLen + ", need " + parsLen + " argument(s).");
                                }
                                arg = null;
                                if (!useDefault) break block25;
                                I_Object defaultObj = crOld.execInit(par.defaultValue, crNew.instance);
                                arg = Lib_MagicVar.replace(defaultObj, crOld, crNew.instance, null);
                                break block26;
                            }
                            if (!useVarArgs) break block27;
                            if (argsLen >= 1 && parsLen == argsLen && parIdx == argsLen - 1 && args[parIdx] instanceof VarLet) {
                                I_Object paro = ((VarLet)args[parIdx]).getVar().get(crOld);
                                if (!Lib_Type.typeIs(crOld, paro, JMo_List.class)) {
                                    throw new RuntimeError(crOld, "Invalid type of variable for varargs", "To use Var-Args with a VarLet, the variable must be a <List>");
                                }
                                arg = paro;
                            } else {
                                ArrayList<I_Object> al = new ArrayList<I_Object>();
                                int v = parsLen - 1;
                                while (v < argsLen) {
                                    I_Object p = args[v];
                                    if (p != null) {
                                        if (par.typeName != null && arg != Nil.NIL && !Lib_Type.isInstanceOf(p, par.typeName)) {
                                            throw new CodeError(crOld, "Invalid type of argument in VarArgs", "Got " + p.getType(crNew).toString() + ", need <" + par.typeName + '>');
                                        }
                                        al.add(p);
                                    }
                                    ++v;
                                }
                                arg = new JMo_List(al);
                            }
                            break block26;
                        }
                        if (parIdx > argsLen - 1) {
                            Err.invalid(parIdx, argsLen, parsLen);
                        }
                        if ((par1 = args[parIdx]) == null) break block28;
                        arg = Lib_Convert.getValue(crOld, par1);
                        if (par.typeName != null && !(arg instanceof VarLet) && par1 instanceof Var && crOld.getStrict().isValid_AutoVarLet() && par.typeName.equals(Lib_Type.getName(VarLet.class, null))) {
                            arg = new VarLet((Var)par1);
                        }
                    }
                    if (!useVarArgs && par.typeName != null && arg != Nil.NIL) {
                        boolean valid = Lib_Type.isInstanceOf(arg, par.typeName);
                        if (!valid && arg instanceof A_Atomic && crOld.getStrict().isValid_ArgConvert()) {
                            arg = Lib_Convert.toSafeType(crOld, (I_Atomic)arg, par.typeName);
                            valid = Lib_Type.isInstanceOf(arg, par.typeName);
                        }
                        if (!valid) {
                            throw new CodeError(crOld, "Invalid type of argument", "Got " + arg.getType(crNew).toString() + ", need <" + par.typeName + '>');
                        }
                    }
                    if (this.vars.parentKnowsRaw(par.name)) {
                        throw new CodeError(crOld, "Can't create Var/Const with this name!", "Name is already used/known in this block: " + par.name);
                    }
                    if (par.isConst) {
                        Const con = (Const)this.consts.use_RunTime(crOld, par.name);
                        con.set(crOld, crNew, arg);
                    } else {
                        Var var = (Var)this.vars.use_RunTime(crOld, par.name);
                        if (arg instanceof NonAtomic) {
                            arg = ((NonAtomic)arg).create(crNew);
                        }
                        var.let(crOld, crNew, arg);
                    }
                }
                --i;
            }
            Err.ifNot(offset, 0);
        }
    }
}

