/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.debug;

import de.mn77.base.data.Lib_Math;
import de.mn77.base.data.type.datetime.MTime;
import de.mn77.base.sys.MOut;

public class Stopwatch {
    private final long start = System.currentTimeMillis();
    private Long diff = this.start;

    public long getMillisec() {
        return System.currentTimeMillis() - this.start;
    }

    public double getSeconds() {
        return (double)(System.currentTimeMillis() - this.start) / 1000.0;
    }

    public long getDiffMillisec() {
        return System.currentTimeMillis() - this.diff;
    }

    public double getDiffSeconds() {
        return (double)(System.currentTimeMillis() - this.diff) / 1000.0;
    }

    public String gStringMillisec() {
        return String.valueOf(this.getMillisec()) + " ms";
    }

    public String getStringSeconds() {
        return String.valueOf(Lib_Math.roundToString(this.getSeconds(), 1)) + " Sec";
    }

    public String getStringHHMMSS() {
        return new MTime(this.getMillisec()).toString();
    }

    public String getStringDiffMillisec() {
        return String.valueOf(this.getDiffMillisec()) + " ms";
    }

    public String getStringDiffSeconds() {
        return String.valueOf(Lib_Math.roundToString(this.getDiffSeconds(), 1)) + " Sec";
    }

    public String getStringDiffHHMMSS() {
        return String.valueOf(new MTime(this.getDiffMillisec()).toString()) + " Min";
    }

    public void print() {
        this.iPrint(null, false);
    }

    public void print(String info) {
        this.iPrint(info, false);
    }

    public void printShort() {
        this.iPrint(null, true);
    }

    public void printShort(String info) {
        this.iPrint(info, true);
    }

    public void resetDiff() {
        this.diff = System.currentTimeMillis();
    }

    private void iPrint(String info, boolean compact) {
        String ds = this.getDiffSeconds() >= 120.0 ? this.getStringDiffHHMMSS() : this.getStringDiffSeconds();
        String gs = this.getSeconds() >= 120.0 ? this.getStringHHMMSS() : this.getStringSeconds();
        String s1 = "Diff : " + ds + "   (" + this.getStringDiffMillisec() + ")";
        String s2 = "Total: " + gs + "   (" + this.gStringMillisec() + ")";
        if (compact) {
            MOut.print(String.valueOf(info == null ? "" : info) + ":  " + ds + " / " + gs);
        } else if (info == null) {
            MOut.print(s1, s2);
        } else {
            MOut.print(info, s1, s2);
        }
        MOut.originLine(3);
        this.resetDiff();
    }

    public String toString() {
        return "Duration: " + this.getStringSeconds() + "   (" + this.gStringMillisec() + ")";
    }
}

