/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.keypot;

import de.mn77.base.data.convert.ConvObject;
import de.mn77.base.data.group.Group2;
import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.keypot.I_KeyPot;
import de.mn77.base.data.struct.set.I_Set;
import de.mn77.base.data.struct.set.MSet;
import de.mn77.base.data.struct.sort.Sort;
import de.mn77.base.error.Err;
import java.util.Iterator;

public abstract class A_KeyPot<TA, TB>
implements I_KeyPot<TA, TB> {
    protected I_Set<TA> keys = new MSet<TA>();

    @Override
    public boolean isEmpty() {
        return this.keys.size() == 0;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public int getWidth() {
        return 2;
    }

    @Override
    public I_Set<TA> getKeys() {
        return (I_Set)this.keys.copy();
    }

    @Override
    public Group2<TA, I_Sequence<TB>> get(int zeile) {
        Object ta = this.keys.get(zeile);
        return new Group2(ta, this.getPot(ta));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int pos = 1;
        while (pos <= this.size()) {
            sb.append(String.valueOf(ConvObject.toText(this.getKeys().get(pos))) + ": ");
            sb.append(String.valueOf(ConvObject.toText(this.get(2, pos))) + "\n");
            ++pos;
        }
        return sb.toString();
    }

    @Override
    public String toStringDebug() {
        StringBuilder sb = new StringBuilder();
        int pos = 1;
        while (pos <= this.size()) {
            sb.append(String.valueOf(ConvObject.toStringIdent(this.getKeys().get(pos))) + ": ");
            sb.append(String.valueOf(ConvObject.toStringIdent(this.get(2, pos))) + "\n");
            ++pos;
        }
        return sb.toString();
    }

    @Override
    public void addAll(TA key, Iterable<TB> objects) {
        for (TB o : objects) {
            this.add(key, o);
        }
    }

    @Override
    public void sort(int ... columnOrder) {
        Sort.sort(this, columnOrder);
    }

    @Override
    public void sortRandom() {
        Err.todo("Testen");
        Sort.random(this);
    }

    @Override
    public Iterator<Group2<TA, I_Sequence<TB>>> iterator() {
        return new Iterator<Group2<TA, I_Sequence<TB>>>(){
            int next = 1;

            @Override
            public boolean hasNext() {
                return A_KeyPot.this.size() >= this.next;
            }

            @Override
            public Group2<TA, I_Sequence<TB>> next() {
                Object ta = A_KeyPot.this.keys.get(this.next++);
                return new Group2(ta, A_KeyPot.this.getPot(ta));
            }

            @Override
            public void remove() {
                Err.forbidden(new Object[0]);
            }
        };
    }
}

