/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.form;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.constant.position.POSITION_H;
import de.mn77.base.data.filter.FilterString;
import de.mn77.base.data.form.FormChar;
import de.mn77.base.error.Err;

public class FormString {
    public static String width(int width, String s, boolean cutOverflow) {
        return FormString.width(width, ' ', s, POSITION_H.LEFT, cutOverflow);
    }

    public static String width(int width, char fill, String t, POSITION_H align, boolean cutOverflow) {
        Err.ifToSmall(0.0, width);
        Err.ifNull(t, align);
        int space = width - t.length();
        if (align == POSITION_H.CENTER) {
            if (space >= 0) {
                t = String.valueOf(Lib_String.sequence(fill, (long)((int)Math.floor((double)space / 2.0)))) + t + Lib_String.sequence(fill, (long)((int)Math.ceil((double)space / 2.0)));
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.LEFT) {
            if (space >= 0) {
                t = String.valueOf(t) + Lib_String.sequence(fill, (long)space);
            } else {
                String string = t = cutOverflow ? t.substring(0, t.length() + space) : t;
            }
        }
        if (align == POSITION_H.RIGHT) {
            t = space >= 0 ? String.valueOf(Lib_String.sequence(fill, (long)space)) + t : (cutOverflow ? t.substring(-space, t.length()) : t);
        }
        return t;
    }

    public static String length(int length, String s, boolean cutOverflow) {
        return length >= 0 ? FormString.width(length, ' ', s, POSITION_H.LEFT, cutOverflow) : FormString.width(Math.abs(length), ' ', s, POSITION_H.RIGHT, cutOverflow);
    }

    public static String quoteForSQL(String s) {
        Err.ifNull(s);
        return FormString.quote(s, '\'', '\'', false);
    }

    public static String toSQL_Identifier(String s) {
        Err.ifNull(s);
        return FilterString.only(("abcdefghijklmnopqrstuvwxyz" + "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "_").toCharArray(), s);
    }

    public static String toFilename(String s) {
        Err.ifNull(s);
        String allowed = String.valueOf("abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toUpperCase()) + "abcdefghijklmnopqrstuvwxyz\u00df\u00e4\u00f6\u00fc".toLowerCase() + "0123456789" + "_- #.,'(){}[]&";
        return FilterString.only(allowed.toCharArray(), s);
    }

    public static String fill(String template, String ... values) {
        Err.ifNull(template, values);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Err.ifNull(s);
            ++n2;
        }
        Err.ifToBig(27.0, values.length);
        int i = 0;
        while (i < values.length) {
            String suche = "%" + "abcdefghijklmnopqrstuvwxyz".charAt(i);
            template = template.replaceAll(suche, values[i]);
            ++i;
        }
        return template;
    }

    public static String limit(String s, int maxLength, String finishItWith) {
        Err.ifToSmall(finishItWith.length(), maxLength);
        if (s.length() <= maxLength) {
            return s;
        }
        return String.valueOf(FilterString.cut(maxLength - finishItWith.length(), true, s)) + finishItWith;
    }

    public static String quote(String value, char quote, char insideprefix, boolean escapeSpecialChars) {
        Err.ifNull(value);
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == quote) {
                sb.append(insideprefix);
                sb.append(quote);
            } else {
                sb.append(escapeSpecialChars ? FormChar.escapeSpecialChar(c) : FormChar.escapeSlash(c));
            }
            ++n2;
        }
        sb.append(quote);
        return sb.toString();
    }

    public static String quoteSpecialChars(String value) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = value.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(FormChar.escapeSpecialChar(c));
            ++n2;
        }
        return sb.toString();
    }

    public static String unquote(String value, char quote, char insideprefix) {
        Err.ifNull(value);
        int len = value.length();
        int left = 0;
        int right = len;
        if (len <= 0 || value.charAt(0) != quote) {
            return value;
        }
        left = 1;
        if (len > 1 && value.charAt(len - 1) == quote) {
            --right;
        }
        value = value.substring(left, right);
        len = value.length();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            String check;
            char c = value.charAt(i);
            if (c == insideprefix && (check = value.substring(i, Math.min(len, i + 2))).equals("" + insideprefix + quote)) {
                sb.append(quote);
                ++i;
            } else {
                i += FormChar.unescapeSpecialChar(value, i, sb) - 1;
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeSpecialChars(String s, boolean singleQuote, boolean doubleQuote) {
        Err.ifNull(s);
        StringBuffer sb = new StringBuffer((int)((double)s.length() * 1.1));
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\'': {
                    sb.append(singleQuote ? "\\'" : Character.valueOf(c));
                    break;
                }
                case '\"': {
                    sb.append(doubleQuote ? "\\\"" : Character.valueOf(c));
                    break;
                }
                default: {
                    sb.append(FormChar.escapeSpecialChar(c));
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String escapeSlashes(String s) {
        Err.ifNull(s);
        StringBuilder sb = new StringBuilder(s.length());
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(FormChar.escapeSlash(c));
            ++n2;
        }
        return sb.toString();
    }

    public static String escapeSqlSecureChars(String s, boolean quotes, boolean doubleQuotes) {
        Err.ifNull(s);
        StringBuilder sb = new StringBuilder(s.length());
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append(FormChar.escapeSqlSecure(c, quotes, doubleQuotes));
            ++n2;
        }
        return sb.toString();
    }

    public static String unescapeSpecialChars(String s) {
        Err.ifNull(s);
        StringBuilder sb = new StringBuilder((int)((double)s.length() * 1.1));
        int len = s.length();
        int i = 0;
        while (i < len) {
            i += FormChar.unescapeSpecialChar(s, i, sb) - 1;
            ++i;
        }
        return sb.toString();
    }
}

