/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data;

import de.mn77.base.error.Err;
import de.mn77.base.error.Warning;

public class Lib_String {
    public static String sequence(char c, long width) {
        Warning.ifOver(10000L, width);
        Err.ifToSmall(0.0, width);
        StringBuffer result = new StringBuffer();
        int i = 0;
        while ((long)i < width) {
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static String sequence(String s, long count) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while ((long)i < count) {
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    public static String insert(String insertion, int pos, String base) {
        Err.ifNull(insertion, base);
        Err.ifEqual(0, pos);
        Err.ifOutOfBounds(base.length() + 1, pos);
        pos = pos < 0 ? base.length() + pos + 1 : --pos;
        return String.valueOf(base.substring(0, pos)) + insertion + base.substring(pos);
    }

    public static String remove(String base, int start_pos, int end_pos) {
        Err.ifNull(base);
        Err.ifEqual(0, start_pos);
        Err.ifOutOfBounds(base.length() + 1, start_pos);
        Err.ifOutOfBounds(base.length() + 1, end_pos);
        Err.ifToSmall(start_pos, end_pos);
        return String.valueOf(base.substring(0, start_pos - 1)) + base.substring(end_pos);
    }

    public static String replace(String base, char replace, String with) {
        Err.ifNull(base, with);
        char[] ca = base.toCharArray();
        StringBuilder sb = new StringBuilder();
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == replace) {
                sb.append(with);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String capitalizeWords(String s) {
        char[] ca = s.toCharArray();
        char last = ' ';
        int pos = 0;
        while (pos >= 0 && pos < ca.length) {
            Character current = Character.valueOf(ca[pos]);
            if (Character.isLetter(current.charValue()) && !Character.isLetter(last)) {
                ca[pos] = Character.toUpperCase(ca[pos]);
            }
            ++pos;
            last = current.charValue();
        }
        return new String(ca);
    }

    public static String capitalize(String s, boolean onlyFirst) {
        Err.ifNull(s);
        if (s.length() == 0) {
            return s;
        }
        boolean inside = false;
        boolean firstDone = false;
        StringBuilder sb = new StringBuilder();
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u0080' && c <= '\u00a5') {
                if (inside) {
                    sb.append(c);
                } else {
                    sb.append(Character.toUpperCase(c));
                    inside = true;
                    firstDone = true;
                }
            } else {
                sb.append(c);
                inside = onlyFirst && firstDone;
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String unquote(String s) {
        if (s.startsWith("\"")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static int diffFirst(String s1, String s2) {
        Err.ifNull(s1, s2);
        int min = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < min) {
            if (s1.charAt(i) != s2.charAt(i)) {
                return i;
            }
            ++i;
        }
        if (s1.length() != s2.length()) {
            return min;
        }
        return -1;
    }
}

