/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.edit.editor.styler;

import de.mn77.base.error.Err;
import de.mn77.base.sys.MOut;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.jaymo_lang.edit.editor.styler.styles.SECTION_TYPE;
import org.jaymo_lang.edit.editor.styler.styles.Styles;
import org.jaymo_lang.edit.lib.Lib_IDE;

public class Scanner {
    private final StyledDocument doc;
    private final Styles styles;
    boolean scanning = false;
    private int start = 0;
    private SECTION_TYPE style = SECTION_TYPE.LINEBREAK;

    public Scanner(StyledDocument doc, Styles styles) {
        this.doc = doc;
        this.styles = styles;
    }

    public void update() {
        if (this.scanning) {
            return;
        }
        this.scanning = true;
        int len = this.doc.getLength();
        String text = null;
        try {
            text = this.doc.getText(0, len);
        }
        catch (BadLocationException e) {
            MOut.temp((Object[])new Object[]{"Bad location", e, 0, len});
            Err.exit((Throwable)e);
        }
        this.start = 0;
        this.style = SECTION_TYPE.LINEBREAK;
        boolean lock = false;
        boolean inCommand = false;
        int i = 0;
        while (i < len) {
            block63: {
                char c;
                block78: {
                    char c1;
                    block79: {
                        block77: {
                            block76: {
                                block75: {
                                    block74: {
                                        block73: {
                                            block72: {
                                                block71: {
                                                    block70: {
                                                        block69: {
                                                            block68: {
                                                                block67: {
                                                                    block66: {
                                                                        block65: {
                                                                            block64: {
                                                                                c = text.charAt(i);
                                                                                if (c == '?' || c == '\u00bf') break block63;
                                                                                if (c != '#' || this.style == SECTION_TYPE.CHAR || this.style == SECTION_TYPE.STRING || this.style == SECTION_TYPE.COMMENT_BLOCK) break block64;
                                                                                if (this.style != SECTION_TYPE.COMMENT_LINE && i + 3 < len && text.substring(i, i + 4).equals("#**#")) {
                                                                                    this.iCheck(text, i, SECTION_TYPE.COMMENT_SCRIPT);
                                                                                    i = len;
                                                                                } else {
                                                                                    this.iCheck(text, i, SECTION_TYPE.COMMENT_LINE);
                                                                                }
                                                                                break block63;
                                                                            }
                                                                            if (c != '/' || i + 1 >= len || text.charAt(i + 1) != '*' || this.style == SECTION_TYPE.CHAR || this.style == SECTION_TYPE.STRING || this.style == SECTION_TYPE.COMMAND) break block65;
                                                                            lock = true;
                                                                            this.iCheck(text, i, SECTION_TYPE.COMMENT_BLOCK);
                                                                            break block63;
                                                                        }
                                                                        if (c != '/' || i < 1 || text.charAt(i - 1) != '*' || this.style != SECTION_TYPE.COMMENT_BLOCK) break block66;
                                                                        lock = false;
                                                                        break block63;
                                                                    }
                                                                    if (lock && this.style == SECTION_TYPE.COMMENT_BLOCK) break block63;
                                                                    if (c != '\n' || this.style != SECTION_TYPE.COMMENT_LINE) break block67;
                                                                    this.iCheck(text, i, SECTION_TYPE.LINEBREAK);
                                                                    break block63;
                                                                }
                                                                if (this.style == SECTION_TYPE.COMMENT_LINE) break block63;
                                                                if (c != '\u00b4' && c != '`' || !inCommand || this.style == SECTION_TYPE.CHAR || this.style == SECTION_TYPE.STRING) break block68;
                                                                this.iCheck(text, i, SECTION_TYPE.COMMAND);
                                                                lock = false;
                                                                inCommand = false;
                                                                break block63;
                                                            }
                                                            if (c != '\u00b4' && c != '`' || inCommand || lock || this.style == SECTION_TYPE.CHAR || this.style == SECTION_TYPE.STRING || this.style == SECTION_TYPE.COMMAND) break block69;
                                                            this.iCheck(text, i, SECTION_TYPE.COMMAND);
                                                            boolean calc = text.length() > i + 1 && text.charAt(i + 1) == '(';
                                                            inCommand = true;
                                                            lock = !calc;
                                                            break block63;
                                                        }
                                                        if (!lock || this.style != SECTION_TYPE.COMMAND) break block70;
                                                        if (c == '\n') {
                                                            this.iCheck(text, i, SECTION_TYPE.ERROR);
                                                            i = len;
                                                        }
                                                        break block63;
                                                    }
                                                    if (c == '(' && this.style == SECTION_TYPE.COMMAND) break block63;
                                                    if (c != ')' || !inCommand || text.length() <= i + 1 || text.charAt(i + 1) != '\u00b4' && text.charAt(i + 1) != '`') break block71;
                                                    this.iCheck(text, i, SECTION_TYPE.COMMAND);
                                                    break block63;
                                                }
                                                if (c != '\'' || this.style != SECTION_TYPE.CHAR || text.charAt(i - 1) == '\\') break block72;
                                                lock = false;
                                                break block63;
                                            }
                                            if (c != '\'' || lock || this.style == SECTION_TYPE.STRING || this.style == SECTION_TYPE.CHAR) break block73;
                                            this.iCheck(text, i, SECTION_TYPE.CHAR);
                                            lock = true;
                                            break block63;
                                        }
                                        if (!lock || this.style != SECTION_TYPE.CHAR) break block74;
                                        if (c == '\n') {
                                            this.iCheck(text, i, SECTION_TYPE.ERROR);
                                            i = len;
                                        }
                                        break block63;
                                    }
                                    if (c != '\"' || this.style != SECTION_TYPE.STRING || text.charAt(i - 1) == '\\') break block75;
                                    lock = false;
                                    break block63;
                                }
                                if (c != '\"' || lock || this.style == SECTION_TYPE.STRING || this.style == SECTION_TYPE.CHAR) break block76;
                                this.iCheck(text, i, SECTION_TYPE.STRING);
                                if (text.startsWith("\"\"\"\"", i)) {
                                    int endIndex = text.indexOf("\"\"\"\"", i + 4);
                                    if (endIndex > -1) {
                                        i = endIndex + 3;
                                    } else {
                                        this.iCheck(text, i, SECTION_TYPE.ERROR);
                                        i = len;
                                    }
                                } else {
                                    lock = true;
                                }
                                break block63;
                            }
                            if (!lock || this.style != SECTION_TYPE.STRING) break block77;
                            if (c == '\n') {
                                this.iCheck(text, i, SECTION_TYPE.ERROR);
                                i = len;
                            }
                            break block63;
                        }
                        if (this.style != SECTION_TYPE.NUMBER) break block78;
                        if ("_abcdefABCDEFxosil".indexOf(c) <= -1) break block79;
                        if (!(c != 'e' && c != 'E' || i + 1 >= len || (c1 = text.charAt(i + 1)) != '+' && c1 != '-')) {
                            ++i;
                        }
                        break block63;
                    }
                    if (c == '.' && i + 1 < len && (c1 = text.charAt(i + 1)) >= '0' && c1 <= '9') break block63;
                }
                if (c >= '0' && c <= '9' && this.style != SECTION_TYPE.UNKNOWN_WORD && this.style != SECTION_TYPE.FUNCTION && this.style != SECTION_TYPE.DEFINITION) {
                    this.iCheck(text, i, SECTION_TYPE.NUMBER);
                } else if (c == '\n') {
                    this.iCheck(text, i, SECTION_TYPE.LINEBREAK);
                } else if (c == '\t') {
                    this.iCheck(text, i, SECTION_TYPE.TABULATOR);
                } else if (c == ' ' && this.style == SECTION_TYPE.LINEBREAK) {
                    this.iCheck(text, i, SECTION_TYPE.WHITESPACE_LEADING);
                } else if (c != ' ' || this.style != SECTION_TYPE.WHITESPACE_LEADING) {
                    if (c == ' ') {
                        if (this.style != SECTION_TYPE.DEFINITION && this.style != SECTION_TYPE.PARSERSETTING) {
                            this.iCheck(text, i, SECTION_TYPE.WHITESPACE);
                        }
                    } else if ((c == '\n' || c == '(' || c == '=') && this.style == SECTION_TYPE.PARSERSETTING) {
                        this.iCheck(text, i, c == '\n' ? SECTION_TYPE.LINEBREAK : SECTION_TYPE.BRACKET);
                    } else if (c == '>' && this.style == SECTION_TYPE.LINEBREAK) {
                        this.iCheck(text, i, SECTION_TYPE.PARSERSETTING);
                    } else if (this.style != SECTION_TYPE.PARSERSETTING) {
                        if (c == ':') {
                            if (i + 1 < len && text.charAt(i + 1) == ':') {
                                this.iCheck(text, i, SECTION_TYPE.DEFINITION);
                            }
                        } else if (c == '!') {
                            if (i + 1 < len && text.charAt(i + 1) == '!') {
                                this.iCheck(text, i, SECTION_TYPE.DEFINITION);
                            }
                        } else if (!(this.style == SECTION_TYPE.DEFINITION && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '@' || c == ' ' || c == '|') || this.style == SECTION_TYPE.FUNCTION && (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_'))) {
                            if (c == '.') {
                                if (i + 1 < len && text.charAt(i + 1) == '.') {
                                    this.iCheck(text, i, SECTION_TYPE.IGNORE);
                                    ++i;
                                } else {
                                    this.iCheck(text, i, SECTION_TYPE.FUNCTION);
                                }
                            } else if (this.style == SECTION_TYPE.MAGIC_SHORT) {
                                this.iCheck(text, i, SECTION_TYPE.FUNCTION);
                            } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '@') {
                                this.iCheck(text, i, SECTION_TYPE.UNKNOWN_WORD);
                            } else if (this.style != SECTION_TYPE.UNKNOWN_WORD || (c < '0' || c > '9') && c != '?' && c != '\u00bf') {
                                if (this.style == SECTION_TYPE.UNKNOWN_WORD && c == '{') {
                                    int lineEnd = text.indexOf(10, i);
                                    int closing = text.indexOf(125, i);
                                    if (closing == -1 || lineEnd >= 0 && lineEnd < closing) {
                                        this.iCheck(text, i, SECTION_TYPE.ERROR);
                                    } else {
                                        i = closing + 1;
                                        this.iCheck(text, i, SECTION_TYPE.IGNORE);
                                    }
                                } else if ("\u00b0%$\u00a7\u20ac".indexOf(c) > -1) {
                                    if (this.style != SECTION_TYPE.LINEBREAK && this.style != SECTION_TYPE.TABULATOR && this.style != SECTION_TYPE.BRACKET && this.style != SECTION_TYPE.PUNCTUATION) {
                                        this.iCheck(text, i, SECTION_TYPE.IGNORE);
                                    } else {
                                        this.iCheck(text, i, SECTION_TYPE.MAGIC_SHORT);
                                        if (i + 1 < len && text.charAt(i + 1) == '$') {
                                            ++i;
                                        }
                                    }
                                } else if (";,".indexOf(c) > -1) {
                                    this.iCheck(text, i, SECTION_TYPE.PUNCTUATION);
                                } else if ("(){}<>[]".indexOf(c) > -1) {
                                    this.iCheck(text, i, SECTION_TYPE.BRACKET);
                                } else {
                                    this.iCheck(text, i, SECTION_TYPE.IGNORE);
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
        this.iCheck(text, len, SECTION_TYPE.LINEBREAK);
        this.scanning = false;
    }

    private void iCheck(String text, int offset, SECTION_TYPE next) {
        block11: {
            int length;
            block12: {
                if (this.style == next) break block11;
                length = offset - this.start;
                if (this.style == SECTION_TYPE.UNKNOWN_WORD) {
                    this.style = this.iCheckWord(text.substring(this.start, offset));
                }
                if (this.style != SECTION_TYPE.FUNCTION) break block12;
                switch (text.substring(this.start, offset)) {
                    case ".each": 
                    case ".times": {
                        this.style = SECTION_TYPE.LOOP_FUNCTION;
                    }
                }
            }
            if (length > 0) {
                this.doc.setCharacterAttributes(this.start, length, this.styles.styles[this.style.ordinal()], true);
            }
            this.start = offset;
            this.style = next;
        }
    }

    private SECTION_TYPE iCheckWord(String s) {
        char c0 = s.charAt(0);
        if (Lib_IDE.isAtomicWord(s)) {
            return SECTION_TYPE.ATOMIC_LITERAL;
        }
        if (Lib_IDE.isMagicVariable(s)) {
            return SECTION_TYPE.MAGIC_LONG;
        }
        if (s.equals(s.toUpperCase())) {
            if (c0 == '_') {
                return s.length() >= 2 && s.charAt(1) == '_' ? SECTION_TYPE.MAGIC_LONG : SECTION_TYPE.TYPE;
            }
            return SECTION_TYPE.CONST;
        }
        if (c0 >= 'A' && c0 <= 'Z' || c0 == '_') {
            return SECTION_TYPE.TYPE;
        }
        return SECTION_TYPE.VAR;
    }
}

