/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.parser.func;

import de.mn77.base.data.group.Group2;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.parser.Parser_Call;
import org.jaymo_lang.parser.Parser_Script;
import org.jaymo_lang.parser.func.I_ParseFunc;
import org.jaymo_lang.util.Lib_Error;

public class ParseFunc_MathLet
implements I_ParseFunc {
    private static final String l1 = "+-*/%&^|~";
    private static final String l2 = "+-*/&^|<>";

    @Override
    public boolean hits(char c0, String s) {
        if (s.length() < 3) {
            return false;
        }
        char c1 = s.charAt(1);
        if (l1.indexOf(c0) > -1 && c1 == '=') {
            return true;
        }
        if (c0 != c1 || l2.indexOf(c1) == -1) {
            return false;
        }
        return s.charAt(2) == '=';
    }

    @Override
    public Group2<Call, String> parse(Parser_Script parser, Block current, I_Object obj, String s, boolean isArgument) {
        int eIdx = s.indexOf(61, 1);
        if (eIdx == s.length() - 1) {
            throw new ParseError("Argument is missing", "Got only: " + s, parser.getDebugInfo());
        }
        boolean letRight = s.charAt(eIdx + 1) == '>';
        int ePos = letRight ? eIdx + 2 : eIdx + 1;
        String m1 = s.substring(0, ePos);
        String arg = s.substring(ePos).trim();
        Call[] args = Parser_Call.parseArguments(parser, current, arg);
        Lib_Error.ifArgs(args.length, 1, (Integer)1, m1, parser.getDebugInfo());
        Call c = new Call(current, obj, m1, args, parser.getDebugInfo());
        return new Group2<Call, Object>(c, null);
    }
}

