/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.object.atom;

import de.mn77.base.error.Err;
import org.jaymo_lang.model.Block;
import org.jaymo_lang.model.COMPARE;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.model.I_AutoBlockDo;
import org.jaymo_lang.model.ObjectCallResult;
import org.jaymo_lang.object.A_Object;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.object.atom.A_Atomic;
import org.jaymo_lang.object.atom.A_Number;
import org.jaymo_lang.object.atom.Char;
import org.jaymo_lang.object.atom.Dec;
import org.jaymo_lang.object.atom.I_Atomic;
import org.jaymo_lang.object.atom.I_AtomicValue;
import org.jaymo_lang.object.atom.I_Decimal;
import org.jaymo_lang.object.atom.I_Integer;
import org.jaymo_lang.object.atom.Int;
import org.jaymo_lang.object.atom.JMo_Long;
import org.jaymo_lang.object.atom.Str;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.runtime.STYPE;
import org.jaymo_lang.util.ATOMIC;
import org.jaymo_lang.util.Lib_Convert;
import org.jaymo_lang.util.Lib_Exec;
import org.jaymo_lang.util.Lib_MagicVar;

public class Bool
extends A_Atomic
implements I_Integer,
I_Atomic,
I_AutoBlockDo {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    private final boolean value;

    public static final Bool getObject(boolean b) {
        return b ? TRUE : FALSE;
    }

    private Bool(boolean val) {
        this.value = val;
    }

    @Override
    public ATOMIC getEnum() {
        return ATOMIC.BOOL;
    }

    @Override
    protected ObjectCallResult call3(CallRuntime cr, String method) {
        switch (method) {
            case "else": {
                return this.mDoElse(cr);
            }
            case "+": 
            case "add": {
                return A_Object.stdResult(this.mAdd(cr));
            }
            case "!&&": 
            case "nand": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.NAND));
            }
            case "!||": 
            case "nor": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.NOR));
            }
            case "!^^": 
            case "xnor": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.XNOR));
            }
            case "!": 
            case "not": {
                return A_Object.stdResult(this.mNot(cr));
            }
            case "&&": 
            case "and": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.AND));
            }
            case "or": 
            case "||": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.OR));
            }
            case "^^": 
            case "xor": {
                return A_Object.stdResult(this.mComparsion2(cr, COMPARE2.XOR));
            }
        }
        Lib_MagicVar.checkForbiddenFuncs(cr, method);
        return null;
    }

    @Override
    public I_Object autoBlockDo(CallRuntime cr) {
        return this.mDoIf((CallRuntime)cr, (boolean)false, (boolean)false, (boolean)false).obj;
    }

    @Override
    public Integer compareTo3(I_AtomicValue o) {
        if (o instanceof Bool) {
            return Boolean.valueOf(this.value).compareTo(((Bool)o).getValue());
        }
        return null;
    }

    @Override
    protected Int getLength(CallRuntime cr) {
        return new Int(this.value ? 4 : 5);
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public int getIntValue(CallRuntime cr) {
        return this.value ? 1 : 0;
    }

    @Override
    public String toString(CallRuntime cr, STYPE type) {
        return "" + this.value;
    }

    @Override
    protected Bool mComparsion(CallRuntime cr, COMPARE m) {
        I_Object raw = cr.argsExt(this, new Class[][]{{Bool.class, A_Number.class}})[0];
        int arg = Lib_Convert.getIntValue(cr, raw);
        int val = this.value ? 1 : 0;
        switch (m) {
            case G: {
                return Bool.getObject(val > arg);
            }
            case L: {
                return Bool.getObject(val < arg);
            }
            case GE: {
                return Bool.getObject(val >= arg);
            }
            case LE: {
                return Bool.getObject(val <= arg);
            }
        }
        throw Err.impossible(new Object[]{m});
    }

    @Override
    protected A_Atomic getMinValue(CallRuntime cr) {
        return FALSE;
    }

    @Override
    protected A_Atomic getMaxValue(CallRuntime cr) {
        return TRUE;
    }

    private Bool mComparsion2(CallRuntime cr, COMPARE2 m) {
        boolean val = this.value;
        if (val) {
            switch (m) {
                case OR: {
                    return TRUE;
                }
                case NOR: {
                    return FALSE;
                }
            }
        } else {
            switch (m) {
                case AND: {
                    return FALSE;
                }
                case NAND: {
                    return TRUE;
                }
            }
        }
        I_Object raw = cr.args(this, Bool.class)[0];
        boolean arg = Lib_Convert.getBoolValue(cr, raw);
        switch (m) {
            case AND: {
                return Bool.getObject(val && arg);
            }
            case OR: {
                return Bool.getObject(val || arg);
            }
            case XOR: {
                return Bool.getObject(val ^ arg);
            }
            case NAND: {
                return Bool.getObject(!val || !arg);
            }
            case NOR: {
                return Bool.getObject(!val && !arg);
            }
            case XNOR: {
                return Bool.getObject(!(val ^ arg));
            }
        }
        throw Err.todo(new Object[]{cr, m});
    }

    private I_Object mAdd(CallRuntime cr) {
        int vn;
        String vb;
        I_Object para = cr.args(this, A_Atomic.class)[0];
        String string = vb = this.value ? "true" : "false";
        if (para instanceof Str) {
            return new Str(String.valueOf(vb) + ((Str)para).getValue());
        }
        if (para instanceof Char) {
            return new Str(String.valueOf(vb) + ((Char)para).getValue());
        }
        int n = vn = this.value ? 1 : 0;
        if (para instanceof Bool) {
            return this.mComparsion2(cr, COMPARE2.AND);
        }
        if (para instanceof JMo_Long) {
            return new JMo_Long((long)vn + ((JMo_Long)para).getValue());
        }
        if (para instanceof I_Decimal) {
            return new Dec((double)vn + Lib_Convert.getDoubleValue(cr, para));
        }
        if (para instanceof I_Integer) {
            return new Int(vn + Lib_Convert.getIntValue(cr, para));
        }
        throw Err.invalid(para);
    }

    private Bool mNot(CallRuntime cr) {
        cr.argsNone();
        return Bool.getObject(!this.value);
    }

    private ObjectCallResult mDoElse(CallRuntime cr) {
        boolean withPar;
        I_Object[] args = cr.argsFlex(this, 0, 1);
        if (this.value) {
            return new ObjectCallResult(this, true);
        }
        Call stream = cr.getStream();
        Block block = cr.getCallBlock();
        boolean bl = withPar = args != null && args.length == 1;
        if (!withPar && stream == null && block == null) {
            return new ObjectCallResult(this, true);
        }
        boolean check = this.value;
        if (withPar) {
            I_Object base = cr.argType(args[0], Bool.class);
            check = ((Bool)base).getValue();
        } else {
            check = !this.value;
        }
        I_Object res = Bool.getObject(check);
        res = Lib_Exec.execIf(cr, check, res, false);
        return new ObjectCallResult(res, true);
    }

    static enum COMPARE2 {
        AND,
        OR,
        XOR,
        NAND,
        NOR,
        XNOR;

    }
}

