/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.model;

import org.jaymo_lang.error.CodeError;
import org.jaymo_lang.error.DebugInfo;
import org.jaymo_lang.error.ParseError;
import org.jaymo_lang.parser.PARSER_LEVEL;
import org.jaymo_lang.parser.ParseManagerFunc;
import org.jaymo_lang.parser.ParseManagerObj;
import org.jaymo_lang.runtime.CallRuntime;

public class StrictManager {
    private static boolean limitDec = true;
    private final ParseManagerObj parsemanager_obj;
    private final ParseManagerFunc parsemanager_func;
    private boolean strictAutoBlock = false;
    private boolean strictFuncResultType = false;
    private boolean strictAutoProperty = false;
    private boolean strictFuncParType = false;
    private boolean strictShortenMethod = false;
    private boolean strict_GroupIf = false;
    private boolean strictShortImports = false;
    private boolean strictVarConstShortcut = false;
    private boolean strictAutoVarLet = false;
    private boolean strictArgConvert = false;
    private boolean strictAtomicAutoUpgrade = false;
    private boolean strictSandbox = false;
    private boolean strictWebstart = false;
    private boolean strictJava = false;
    private boolean strictAnotherScript = false;
    private boolean strictOpenArg = false;
    private PARSER_LEVEL parserLevel = PARSER_LEVEL.OPEN;
    private boolean lazyErrors = false;
    private boolean unsafeHotCode = false;
    private boolean clearFlow = false;

    public static boolean limitDec() {
        return limitDec;
    }

    public StrictManager(ParseManagerObj parsemanager_obj, ParseManagerFunc parsemanager_func) {
        this.parsemanager_obj = parsemanager_obj;
        this.parsemanager_func = parsemanager_func;
        limitDec = true;
    }

    public void set(PARSER_LEVEL level, DebugInfo debug) {
        if (this.parserLevel != PARSER_LEVEL.OPEN && level != this.parserLevel) {
            throw new ParseError("Parser-Level already set!", level.name().toLowerCase(), debug);
        }
        this.parserLevel = level;
        this.parsemanager_obj.strictLevel(level);
        this.parsemanager_func.strictLevel(level);
        switch (level) {
            case HIGH: 
            case INSANE: {
                this.strictAutoProperty = true;
                this.strictAutoBlock = true;
                this.strictFuncResultType = true;
            }
            case MEDIUM: {
                this.strictVarConstShortcut = true;
                this.strictShortImports = true;
                this.strictOpenArg = true;
                this.strictArgConvert = true;
                this.strictAtomicAutoUpgrade = true;
            }
            case LOW: {
                this.strictAutoVarLet = true;
                this.strictFuncParType = true;
                this.strictShortenMethod = true;
                this.strict_GroupIf = true;
            }
        }
    }

    public void setSandbox() {
        this.strictSandbox = true;
        this.strictJava = true;
        this.parsemanager_obj.strictSandbox();
        this.parsemanager_func.strictSandbox();
    }

    public void setWebstart() {
        this.strictWebstart = true;
    }

    public void setNoJava() {
        this.strictJava = true;
    }

    public void setAnotherScript() {
        this.strictAnotherScript = true;
    }

    public void setLazyErrors() {
        this.lazyErrors = true;
    }

    public boolean getLazyErrors() {
        return this.lazyErrors;
    }

    public void setUnsafeHotCode() {
        this.unsafeHotCode = true;
    }

    public void setClearFlow() {
        this.clearFlow = true;
    }

    public void setOpenDec() {
        limitDec = false;
    }

    public void checkSandbox(CallRuntime cr, String of) {
        if (this.strictSandbox) {
            throw new CodeError(cr, "Sandbox-Mode! This object/function is forbidden!", of);
        }
    }

    public void checkSandbox(DebugInfo debug, String of) {
        if (this.strictSandbox) {
            throw new ParseError("Sandbox-Mode! This object/function is forbidden!", of, debug);
        }
    }

    public void checkNoJava(DebugInfo debug) {
        if (this.strictJava) {
            throw new ParseError("Java restricted!", "Pure Java objects are forbidden by parser switch!", debug);
        }
    }

    public void checkWebstart(CallRuntime cr, String of) {
        if (this.strictWebstart) {
            throw new CodeError(cr, "Webstart-Mode! This object/function is not available!", of);
        }
    }

    public void checkUnsafeHotCode(CallRuntime cr, String infoTypeCall) {
        if (!this.unsafeHotCode) {
            throw new CodeError(cr, "Execution of unsafe hot code is prohibited.", "Forbidden call: " + infoTypeCall);
        }
    }

    public void checkAutoBlock(CallRuntime cr) {
        if (this.strictAutoBlock) {
            throw new CodeError(cr, "Strict! Auto-Block-Function and .do are forbidden!", "Use it with the correct function, for example '.each'");
        }
    }

    public void checkFuncParType(String pType, String pName, DebugInfo debug) {
        if (this.strictFuncParType && pType == null) {
            throw new ParseError("Strict! Missing type of parameter!", pName, debug);
        }
    }

    public void checkFuncResultType(String fType, boolean fReturnNil, String fName, DebugInfo debug) {
        if (this.strictFuncResultType && fType == null && !fReturnNil) {
            throw new ParseError("Strict! Missing return-type for function!", fName, debug);
        }
    }

    public void checkGroupIf(CallRuntime cr) {
        if (this.strict_GroupIf) {
            throw new CodeError(cr, "Strict! Auto-Block-Function for Group is forbidden!", "Use If()");
        }
    }

    public void checkParseTimeSwitch(String s, DebugInfo debug) {
        if (this.strictAnotherScript) {
            throw new ParseError("Strict! This command is invalid or only allowed at the top of the first files!", s, debug);
        }
    }

    public void checkShortImports(DebugInfo debug) {
        if (this.strictShortImports) {
            throw new CodeError("Strict! Short imports are forbidden!", "Use >import() and >java()", debug);
        }
    }

    public void checkVarConstShortcut(DebugInfo debug, String raw, String full) {
        if (this.strictVarConstShortcut) {
            throw new CodeError("Strict! Shortcut of variables and constants are not allowed!", "Please write '" + full + "' instead of '" + raw + "'!", debug);
        }
    }

    public void checkClearFlow(DebugInfo debug) {
        if (this.clearFlow) {
            throw new CodeError("Strict! Clear flow enforced!", "Function.return, Loop.break and Loop.next are unavailable.", debug);
        }
    }

    public void checkOpenArg(DebugInfo debug) {
        if (this.strictOpenArg) {
            throw new CodeError("Strict! Open argument is forbidden!", "Please use brackets for arguments.", debug);
        }
    }

    public boolean isValid_ShortenMethod() {
        return !this.strictShortenMethod;
    }

    public boolean isValid_AutoProperty() {
        return !this.strictAutoProperty;
    }

    public boolean isValid_AutoVarLet() {
        return !this.strictAutoVarLet;
    }

    public boolean isValid_ArgConvert() {
        return !this.strictArgConvert;
    }

    public boolean isValid_AtomicAutoUpgrade() {
        return !this.strictAtomicAutoUpgrade;
    }
}

