/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.lang;

import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.sys.MOut;
import de.mn77.lib.lang.PoItem;

public class PoData {
    private final I_List<PoItem> data = new MList<PoItem>();

    public void add(PoItem item) {
        this.data.add(item);
    }

    public I_List<PoItem> getItems() {
        return this.data;
    }

    public I_List<String> getWithoutTranslation() {
        MList<String> result = new MList<String>();
        for (PoItem item : this.data) {
            String str = item.getStr();
            if (str != null && str.length() != 0) continue;
            result.add(item.getId());
        }
        return result;
    }

    public void setTranslation(String id, String translation, boolean fuzzy) {
        for (PoItem item : this.data) {
            if (!item.getId().equals(id)) continue;
            item.strSet(translation);
            if (fuzzy) {
                item.setFuzzy();
            }
            return;
        }
    }

    public String translate(String id) {
        for (PoItem item : this.data) {
            if (!item.getId().equals(id)) continue;
            return item.getStr();
        }
        MOut.print("Unknown ID for translation: '" + id + "'");
        return id;
    }

    public String toString() {
        return "PoData[" + this.data.size() + "]";
    }
}

