/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.lib.csv;

import de.mn77.base.data.struct.I_Sequence;
import de.mn77.base.data.struct.list.I_List;
import de.mn77.base.data.struct.list.MList;
import de.mn77.base.data.struct.table.I_Table;
import de.mn77.base.data.struct.table.MTable;
import de.mn77.base.error.Err;
import de.mn77.base.error.Err_FileSys;
import de.mn77.base.sys.file.I_File;
import de.mn77.base.sys.file.Lib_TextFile;
import de.mn77.lib.csv.Lib_CSV;
import java.io.File;

public class CSV_TableFile {
    private final File file;
    private char separator_field = (char)34;
    private char separator_col = (char)44;
    private String separator_line = "\n";

    public CSV_TableFile(File f) {
        Err.ifNull(f);
        this.file = f;
    }

    public CSV_TableFile(String file) {
        this(new File(file));
    }

    public CSV_TableFile(I_File file) {
        this(file.getFile());
    }

    public CSV_TableFile setSeparatorLine(String s) {
        this.separator_line = s;
        return this;
    }

    public CSV_TableFile setSeparatorCol(char c) {
        this.separator_col = c;
        return this;
    }

    public CSV_TableFile setSeparatorField(char c) {
        this.separator_field = c;
        return this;
    }

    public CSV_TableFile write(I_Table<String> table) throws Err_FileSys {
        Err.ifNull(table);
        try {
            if (this.file.exists()) {
                this.file.delete();
            }
            MList<String> data = new MList<String>();
            int row = 1;
            while (row <= table.size()) {
                String line = "";
                int col = 1;
                while (col <= table.getWidth()) {
                    String feld = (String)table.getCol(col).get(row);
                    if (feld == null) {
                        feld = "";
                    }
                    if ((feld = feld.replaceAll("" + this.separator_field, "" + this.separator_field + this.separator_field)).length() > 0) {
                        feld = String.valueOf(this.separator_field) + feld + this.separator_field;
                    }
                    line = String.valueOf(line) + feld + (col < table.getWidth() ? "" + this.separator_col : "");
                    ++col;
                }
                data.add(line);
                ++row;
            }
            Lib_TextFile.set(this.file, data, true);
        }
        catch (Exception err) {
            throw Err.fsAccess(err);
        }
        return this;
    }

    public void write(I_List<String> head, I_Table<String> table) throws Err_FileSys {
        MTable<String> tab = new MTable<String>(head.size());
        tab.add((I_Sequence<String>)head);
        for (I_Sequence i_Sequence : table) {
            tab.add(i_Sequence);
        }
        this.write(tab);
    }

    public I_Table<String> get() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, true);
        return Lib_CSV.parse(csv, this.separator_field, this.separator_col, this.separator_line, true, true);
    }

    public I_Table<String> getWithoutFirstLine() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, true);
        return Lib_CSV.parse(csv, this.separator_field, this.separator_col, this.separator_line, false, true);
    }

    public I_List<String> getFirstLine() throws Err_FileSys {
        String csv = Lib_TextFile.read(this.file, true);
        return Lib_CSV.parse(csv, this.separator_field, this.separator_col, this.separator_line, true, false).getRow(1);
    }

    public char getSeparatorCol() {
        return this.separator_col;
    }

    public char getSeparatorField() {
        return this.separator_field;
    }

    public String getSeparatorLine() {
        return this.separator_line;
    }
}

