/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.struct.table;

import de.mn77.base.data.Lib_String;
import de.mn77.base.data.form.FormString;
import de.mn77.base.error.Err;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ArrayTable<T>
implements List<T[]> {
    private static final String ERR_ADD_WIDTH = "The amount of items doesn't fit to the width of the table!";
    private final ArrayList<T[]> table;
    private final int width;

    public ArrayTable(int width) {
        Err.ifToSmall(1.0, width);
        this.width = width;
        this.table = new ArrayList();
    }

    @Override
    public void add(int index, T[] e) {
        Err.ifNot(e.length, this.width, ERR_ADD_WIDTH);
        this.table.add(index, e);
    }

    @Override
    public boolean add(T[] e) {
        Err.ifNot(e.length, this.width, ERR_ADD_WIDTH);
        this.table.add(e);
        return true;
    }

    public boolean addRow(T ... row) {
        Err.ifNot(row.length, this.width, ERR_ADD_WIDTH);
        this.table.add(row);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T[]> c) {
        for (T[] TArray : c) {
            this.add(TArray);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T[]> c) {
        throw Err.todo(c);
    }

    @Override
    public void clear() {
        this.table.clear();
    }

    @Override
    public boolean contains(Object o) {
        Iterator<T[]> iterator = this.table.iterator();
        while (iterator.hasNext()) {
            T[] row;
            T[] TArray = row = iterator.next();
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                T cell = TArray[n2];
                if (cell.equals(o)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public T[] get(int index) {
        return this.getRow(index);
    }

    public T[] getRow(int index) {
        return this.table.get(index);
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public int indexOf(Object o) {
        throw Err.todo(o);
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public Iterator<T[]> iterator() {
        return this.table.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw Err.todo(o);
    }

    @Override
    public ListIterator<T[]> listIterator() {
        return this.table.listIterator();
    }

    @Override
    public ListIterator<T[]> listIterator(int index) {
        return this.table.listIterator(index);
    }

    @Override
    public T[] remove(int index) {
        return this.table.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        throw Err.todo(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw Err.todo(c);
    }

    @Override
    public T[] set(int index, T[] element) {
        throw Err.todo(index, element);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public List<T[]> subList(int fromIndex, int toIndex) {
        return this.table.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.table.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.table.toArray(a);
    }

    public T get(int col, int row) {
        return this.table.get(row)[col];
    }

    public void set(int col, int row, T o) {
        this.table.get((int)row)[col] = o;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String[] titles) {
        int x;
        StringBuilder sb = new StringBuilder();
        int[] max = new int[this.width];
        int y = 0;
        while (y < this.size()) {
            x = 0;
            while (x < this.width) {
                T o = this.get(x, y);
                int len = ("" + o).length();
                if (len > max[x]) {
                    max[x] = len;
                }
                ++x;
            }
            ++y;
        }
        if (titles != null) {
            Err.ifNot(titles.length, this.width, ERR_ADD_WIDTH);
            int x2 = 0;
            while (x2 < this.width) {
                int len = titles[x2].length();
                if (len > max[x2]) {
                    max[x2] = len;
                }
                ++x2;
            }
            x2 = 0;
            while (x2 < this.width) {
                if (x2 > 0) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(max[x2], titles[x2], false));
                ++x2;
            }
            sb.append('\n');
            x2 = 0;
            while (x2 < this.width) {
                if (x2 > 0) {
                    sb.append(" | ");
                }
                sb.append(Lib_String.sequence('=', (long)max[x2]));
                ++x2;
            }
            sb.append('\n');
        }
        y = 0;
        while (y < this.size()) {
            x = 0;
            while (x < this.width) {
                if (x > 0) {
                    sb.append(" | ");
                }
                sb.append(FormString.width(max[x], "" + this.get(x, y), false));
                ++x;
            }
            if (y < this.size() - 1) {
                sb.append("\n");
            }
            ++y;
        }
        return sb.toString();
    }

    public ArrayList<T> getColumn(int index) {
        Err.ifOutOfBounds(0.0, this.width - 1, index);
        ArrayList<T> result = new ArrayList<T>(this.table.size());
        int i = 0;
        while (i < this.table.size()) {
            T[] row = this.table.get(i);
            result.add(row[index]);
            ++i;
        }
        return result;
    }
}

