/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.convert;

import de.mn77.base.data.form.FormString;

public class ConvObject {
    public static String toText(Object o) {
        return o == null ? "null" : (o instanceof String ? (String)o : o.toString());
    }

    public static String toString(Object o) {
        return o == null ? null : (o instanceof String ? (String)o : o.toString());
    }

    public static String toTextOutput(Object o) {
        return ConvObject.iToText(o, false);
    }

    public static String toTextDebug(Object o) {
        return ConvObject.iToText(o, true);
    }

    private static String iToText(Object o, boolean debug) {
        if (o == null) {
            return "null";
        }
        if (o instanceof String) {
            return debug ? FormString.quote((String)o, '\"', '\\', true) : (String)o;
        }
        if (o.getClass().isArray()) {
            if (o instanceof boolean[]) {
                return ConvObject.toTextDebug((boolean[])o);
            }
            if (o instanceof byte[]) {
                return ConvObject.toTextDebug((byte[])o);
            }
            if (o instanceof char[]) {
                return ConvObject.toTextDebug((char[])o);
            }
            if (o instanceof short[]) {
                return ConvObject.toTextDebug((short[])o);
            }
            if (o instanceof int[]) {
                return ConvObject.toTextDebug((int[])o);
            }
            if (o instanceof long[]) {
                return ConvObject.toTextDebug((long[])o);
            }
            if (o instanceof float[]) {
                return ConvObject.toTextDebug((float[])o);
            }
            if (o instanceof double[]) {
                return ConvObject.toTextDebug((double[])o);
            }
            return ConvObject.toTextDebug((Object[])o);
        }
        if (o instanceof Boolean) {
            return "" + o;
        }
        if (o instanceof Byte) {
            return "(byte)" + o;
        }
        if (o instanceof Character) {
            return ConvObject.toTextDebug(((Character)o).charValue());
        }
        if (o instanceof Short) {
            return "(short)" + o;
        }
        if (o instanceof Integer) {
            return "" + o;
        }
        if (o instanceof Long) {
            return o + "L";
        }
        if (o instanceof Float) {
            return o + "F";
        }
        if (o instanceof Double) {
            return o + "D";
        }
        if (o instanceof Class) {
            return String.valueOf(((Class)o).isInterface() ? "(Interface)" : "(Class)") + ((Class)o).getSimpleName();
        }
        if (o.getClass() == Object.class) {
            return "Object";
        }
        return o.toString();
    }

    public static String toTextDebug(boolean[] r) {
        StringBuffer b = new StringBuffer();
        boolean[] blArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            boolean element = blArray[n2];
            b.append("," + element);
            ++n2;
        }
        return "boolean[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(byte[] r) {
        StringBuffer b = new StringBuffer();
        byte[] byArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            b.append("," + element);
            ++n2;
        }
        return "byte[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(short[] r) {
        StringBuffer b = new StringBuffer();
        short[] sArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            short element = sArray[n2];
            b.append("," + element);
            ++n2;
        }
        return "short[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(int[] r) {
        StringBuffer b = new StringBuffer();
        int[] nArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            b.append("," + element);
            ++n2;
        }
        return "int[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(long[] r) {
        StringBuffer b = new StringBuffer();
        long[] lArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            long element = lArray[n2];
            b.append("," + ConvObject.toTextDebug(element));
            ++n2;
        }
        return "long[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(float[] r) {
        StringBuffer b = new StringBuffer();
        float[] fArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            float element = fArray[n2];
            b.append("," + ConvObject.toTextDebug(Float.valueOf(element)));
            ++n2;
        }
        return "float[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(double[] r) {
        StringBuffer b = new StringBuffer();
        double[] dArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            double element = dArray[n2];
            b.append("," + ConvObject.toTextDebug(element));
            ++n2;
        }
        return "double[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(char[] r) {
        StringBuffer b = new StringBuffer();
        char[] cArray = r;
        int n = r.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            b.append("," + ConvObject.toTextDebug(element));
            ++n2;
        }
        return "char[" + (b.length() == 0 ? "" : b.substring(1)) + "]";
    }

    public static String toTextDebug(Object[] oa) {
        if (oa == null) {
            return "null";
        }
        String type = oa.getClass().toString().replaceFirst("^.*\\.([A-Za-z_]+);.*", "$1");
        StringBuffer result1 = new StringBuffer(String.valueOf(type) + "[");
        int i = 0;
        while (i < oa.length) {
            result1.append("\n   " + ConvObject.toTextDebug(oa[i]) + (i == oa.length - 1 ? "" : ","));
            ++i;
        }
        String result2 = result1.toString();
        return String.valueOf(result2.length() < 100 ? result2.replaceAll("\n   ", "") : result2) + "]";
    }

    public static String toTextDebug(char c) {
        return c > '\u001f' && c < '\u007f' ? "(char)" + c : "(char)" + c;
    }
}

