/*
 * Decompiled with CFR 0.152.
 */
package de.mn77.base.data.bigcalc;

import de.mn77.base.data.bigcalc.BigPowerIterator;
import de.mn77.base.data.bigcalc.BigRational;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public abstract class BigSeriesCalculator {
    private final boolean calculateInPairs;
    private final List<BigRational> factors = new ArrayList<BigRational>();

    protected BigSeriesCalculator() {
        this(false);
    }

    protected BigSeriesCalculator(boolean calculateInPairs) {
        this.calculateInPairs = calculateInPairs;
    }

    public BigDecimal calculate(BigDecimal x, MathContext mathContext) {
        BigDecimal step;
        BigDecimal acceptableError = BigDecimal.ONE.movePointLeft(mathContext.getPrecision() + 1);
        BigPowerIterator powerIterator = this.createPowerIterator(x, mathContext);
        BigDecimal sum = BigDecimal.ZERO;
        int i = 0;
        do {
            BigRational factor = this.getFactor(i);
            BigDecimal xToThePower = powerIterator.getCurrentPower();
            powerIterator.calculateNextPower();
            step = factor.getNumerator().multiply(xToThePower).divide(factor.getDenominator(), mathContext);
            ++i;
            if (this.calculateInPairs) {
                factor = this.getFactor(i);
                xToThePower = powerIterator.getCurrentPower();
                powerIterator.calculateNextPower();
                BigDecimal step2 = factor.getNumerator().multiply(xToThePower).divide(factor.getDenominator(), mathContext);
                step = step.add(step2);
                ++i;
            }
            sum = sum.add(step);
        } while (step.abs().compareTo(acceptableError) > 0);
        return sum.round(mathContext);
    }

    protected abstract void calculateNextFactor();

    protected abstract BigPowerIterator createPowerIterator(BigDecimal var1, MathContext var2);

    protected abstract BigRational getCurrentFactor();

    protected synchronized BigRational getFactor(int index) {
        while (this.factors.size() <= index) {
            BigRational factor = this.getCurrentFactor();
            this.addFactor(factor);
            this.calculateNextFactor();
        }
        return this.factors.get(index);
    }

    private void addFactor(BigRational factor) {
        this.factors.add(Objects.requireNonNull(factor, "Factor cannot be null"));
    }
}

