/*
 * Decompiled with CFR 0.152.
 */
package org.jaymo_lang.util;

import de.mn77.base.error.Err;
import org.jaymo_lang.model.Call;
import org.jaymo_lang.object.I_Object;
import org.jaymo_lang.runtime.CallRuntime;
import org.jaymo_lang.util.Lib_Error;

public class Lib_Function {
    public static byte isVarFunction(String method) {
        switch (method) {
            case "=": 
            case "=~": 
            case "let": 
            case "convertLet": {
                return 1;
            }
            case "sqrtLet": 
            case "notLet": 
            case "=!": 
            case "=**": 
            case "=++": 
            case "=--": 
            case "=//": 
            case "=<<": 
            case "=>>": {
                return 0;
            }
            case "addLet": 
            case "andLet": 
            case "divLet": 
            case "modLet": 
            case "mulLet": 
            case "subLet": 
            case "bitAndLet": 
            case "xorLet": 
            case "bitXorLet": 
            case "%=": 
            case "&=": 
            case "*=": 
            case "+=": 
            case "-=": 
            case "/=": 
            case "^=": 
            case "|=": 
            case "&&=": 
            case "**=": 
            case "++=": 
            case "--=": 
            case "//=": 
            case "<<=": 
            case ">>=": 
            case "^^=": 
            case "||=": 
            case "orLet": 
            case "bitOrLet": {
                return 1;
            }
            case "shiftRightLet": 
            case "shiftLeftLet": 
            case "decLet": 
            case "incLet": 
            case "powLet": 
            case "rootLet": {
                return 2;
            }
        }
        return -1;
    }

    public static I_Object mCalcLet(CallRuntime cr, String method, byte methodParState, I_Object oldVarValue) {
        if (methodParState == 2) {
            byte by = methodParState = cr.argCount() == 0 ? (byte)0 : 1;
        }
        if (methodParState == 0) {
            return Lib_Function.mCalcLetNoPar(cr, method, oldVarValue);
        }
        if (methodParState == 1) {
            return Lib_Function.mCalcLetWithPar(cr, method, oldVarValue);
        }
        throw Err.todo(method);
    }

    public static boolean isMathematicFunction(String m) {
        if (m == null || m.length() == 0) {
            return false;
        }
        char c = m.charAt(0);
        return (c < 'a' || c > 'z') && c != '_' && c != '@';
    }

    private static I_Object mCalcLetWithPar(CallRuntime cr, String method, I_Object oldVarValue) {
        Lib_Error.ifArgs(cr.argCount(), 1, (Integer)1, cr, oldVarValue);
        String calcMethod = Lib_Function.iConvertMethod(method);
        Call c3 = new Call(cr.getSurrBlock(), oldVarValue, calcMethod, cr.call.argCalls, cr.getDebugInfo());
        CallRuntime crx = cr.copyCall(c3, false);
        return crx.exec(null, true);
    }

    private static I_Object mCalcLetNoPar(CallRuntime cr, String method, I_Object oldVarValue) {
        cr.argsNone();
        String calcMethod = Lib_Function.iConvertMethod(method);
        Call[] parCalls = new Call[]{};
        Call c3 = new Call(cr.getSurrBlock(), oldVarValue, calcMethod, parCalls, cr.getDebugInfo());
        CallRuntime crx = cr.copyCall(c3, false);
        return crx.exec(null, true);
    }

    private static String iConvertMethod(String method) {
        if (method.charAt(0) == '=') {
            method = method.substring(1);
        }
        if (method.endsWith("=")) {
            method = method.substring(0, method.length() - 1);
        }
        if (method.endsWith("Let")) {
            method = method.substring(0, method.length() - 3);
        }
        return method;
    }
}

